/*----------------------------------------------------------
	Direct3D9Tv
		EMicrosoft DirectX SDK (June 2010)
		EVisual Studio 2010 Express
		EWindows XP or Windows Vista or Windows 7
		E_/sNZEVF[_2.0
		Ή

	D3D9Sample20.cpp
		ueNX`EbsOE[h̃Tvv
--------------------------------------------------------------*/

#define D3DXFX_LARGEADDRESS_HANDLE	// D3DXHANDLEp[^ɓnȂ
#define DXUT_AUTOLIB		// DXUTŕKvȃCu(dsound.libȊO)IɃN
#include "DXUT.h"			// DXUTg
#include "SDKmisc.h"		// DXUT Optionalg
#include "DXUTgui.h"		// DXUT OptionalGUIg
#include "DXUTSettingsDlg.h"	//DXUT OptionalCD3DSettingsDlgNXg	
#include "resource.h"

// DXUT̃CuN
#if defined(DEBUG) || defined(_DEBUG)
#pragma comment( lib, "..\\Debug\\DXUT.lib" )
#pragma comment( lib, "..\\Debug\\DXUTOpt.lib" )
#else
#pragma comment( lib, "..\\Release\\DXUT.lib" )
#pragma comment( lib, "..\\Release\\DXUTOpt.lib" )
#endif

// *****************************************
// **** O[oϐ

// J
D3DXVECTOR3 g_vEye(0.0f, 4.0f, -6.0f);		// J̍W
D3DXVECTOR3 g_vAt(0.0f, 0.0f, 0.0f);		// _
D3DXVECTOR3 g_vUp(0.0f, 1.0f, 0.0f);		// J̏xNg

D3DXMATRIX g_matWorldViewProj;				// [h~r[~ϊs
float g_Aspect;								// ʂ̃AXyNg

// GtFNg
LPD3DXEFFECT g_pD3DXEffect = NULL;			// `ɎgGtFNg
const int    MAX_TECH = 16;
D3DXHANDLE   g_hTech[MAX_TECH];				// eNjbNEnh

D3DXHANDLE g_hWorldViewProj = NULL;	// ϊs
D3DXHANDLE g_hTex           = NULL;	// GtFNg̃eNX`

// _f[^̌`
struct VertexBuffer   // _obt@Ɏ߂f[^
{
	FLOAT x, y, z;		// _W
	FLOAT tx, ty;		// eNX`W
};

// _vf
D3DVERTEXELEMENT9 g_decl[] = 
{
	{ 0,  0,              D3DDECLTYPE_FLOAT3, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_POSITION, 0 },
	{ 0, sizeof(FLOAT)*3, D3DDECLTYPE_FLOAT2, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_TEXCOORD, 0 },
	D3DDECL_END()   // z̏I
};

LPDIRECT3DVERTEXDECLARATION9 g_pVertexDeclaration = NULL;	// _錾IuWFNg

// _obt@ƃCfbNXEobt@
LPDIRECT3DVERTEXBUFFER9 g_pD3DVBuffer = NULL;	// _obt@
LPDIRECT3DINDEXBUFFER9  g_pD3DIBuffer = NULL;	// CfbNXEobt@

LPDIRECT3DTEXTURE9 g_pTexture = NULL;			// }eA(eNX`)

// *****************************************
// **** O[oϐ(GUI@\)

// GUI\[XǗ
CDXUTDialogResourceManager	g_DialogResourceManager; // _CAÕ\[XǗ
CD3DSettingsDlg				g_SettingsDlg;           // foCXݒ_CAO

// foCX֘Aݒ_CAO(E)
enum { ID_DISPLAYMODE = 0, ID_HALREF, ID_CHANGEDEVICE, ID_PAUSE }; // Rg[ID
CDXUTDialog  g_DeviceUI;    // _CAO

// Xe[^X\_CAO()
enum { ID_DEVICESTATUS = 50, ID_FRAMESTATUS }; // Rg[ID
CDXUTDialog  g_StatusUI;    // _CAO

// _CAO@(ݒBE)
enum {  ID_LISTBOX1  =100 }; // Rg[ID
CDXUTDialog  g_SampleUI;   // _CAO@

// *****************************************
// **** GUI֘Å֐

// _CAOĂяoR[obN֐
void CALLBACK DXUTCallbackGUIEvent(UINT nEvent, int nControlID, CDXUTControl* pControl, void* pUserContext)
{
	switch (nControlID)
	{
	// foCX֘Aݒ_CAO
	case ID_DISPLAYMODE:	// ʃ[h؂ւ(EChEE[hƃtXN[E[h)
		DXUTToggleFullScreen();
		break;
	case ID_HALREF:			// foCX؂ւ(REFHAL)
		DXUTToggleREF();
		break;
	case ID_CHANGEDEVICE:	// foCXݒʂ̕\
		g_SettingsDlg.SetActive(!g_SettingsDlg.IsActive());
		break;
	case ID_PAUSE:			// ꎞ~
		DXUTPause(!DXUTIsTimePaused(), false);
		break;
	}
}

// *****************************************
// **** foCX쐬֘ÃR[obN֐

// p\ȃfoCX̗(R[obN֐)
bool CALLBACK DXUTCallbackIsDeviceAcceptable(
		D3DCAPS9 *pCaps, D3DFORMAT AdapterFormat, D3DFORMAT BackBufferFormat, bool bWindowed, void* pUserContext)

{
	if (pCaps->MaxPrimitiveCount < 0xFFFF)		// v~eBu
		return false;
	if (pCaps->MaxVertexIndex < 0xFFF0)			// CfbNX
		return false;
	if (pCaps->PixelShaderVersion < D3DPS_VERSION(2, 0))	// sNZEVF[_
		return false;

	return true;	// ̃foCX̎gpe
}

// 쐬foCXݒ̕ύX(R[obN֐)
bool CALLBACK DXUTCallbackModifyDeviceSettings(
		DXUTDeviceSettings *pDeviceSettings, void* pUserContext)
{
	// Direct3D 9foCXg邱ƂmF
	if( pDeviceSettings->ver == DXUT_D3D9_DEVICE )
	{
		// D3D9foCX̔\͂擾
		D3DCAPS9 caps;
		DXUTGetD3D9DeviceCaps( pDeviceSettings, &caps );

		// ŏɃt@X foCXIꂽƂɁAx\
		static bool s_bFirstTime = true;
		if( s_bFirstTime )
		{
			s_bFirstTime = false;
			if( pDeviceSettings->d3d9.DeviceType == D3DDEVTYPE_REF )
				DXUTDisplaySwitchingToREFWarning(pDeviceSettings->ver);
		}

		// o[W2.0̒_VF[_n[hEFAŃT|[gĂȂꍇ́A\tgEFAg
		if ((caps.DevCaps & D3DDEVCAPS_HWTRANSFORMANDLIGHT) == 0 ||
				caps.VertexShaderVersion < D3DVS_VERSION(2, 0))
		{
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_HARDWARE_VERTEXPROCESSING;
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_PUREDEVICE;
			pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_SOFTWARE_VERTEXPROCESSING;	// \tgEFA_
		}
		else
		{
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_SOFTWARE_VERTEXPROCESSING;
			pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_HARDWARE_VERTEXPROCESSING;	//n[hEFA_
		}

		// Avdouble^g(x͒ቺ)
		pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_FPU_PRESERVE;
	}

	return true;
}

// foCX쐬̏(R[obN֐)
HRESULT CALLBACK DXUTCallbackDeviceCreated(
			LPDIRECT3DDEVICE9 pd3dDevice, const D3DSURFACE_DESC *pBackBufferSurfaceDesc, void* pUserContext)
{
	HRESULT hr;

	// GUI\[XǗ
	V_RETURN( g_DialogResourceManager.OnD3D9CreateDevice( pd3dDevice ) );
	V_RETURN( g_SettingsDlg.OnD3D9CreateDevice( pd3dDevice ) );

	// XgE{bNX̃NA
	g_SampleUI.GetListBox(ID_LISTBOX1)->RemoveAllItems();

	// **** _錾IuWFNg̍쐬 ****
	V_RETURN(pd3dDevice->CreateVertexDeclaration(g_decl, &g_pVertexDeclaration));

	// **** _obt@̍쐬 ****
	V_RETURN(pd3dDevice->CreateVertexBuffer(
			sizeof(VertexBuffer)*24,	// obt@ETCY(̂̒_)
			0,							// gp@
			0,							// FVF_obt@
			D3DPOOL_MANAGED,			// Direct3DŃǗ
			&g_pD3DVBuffer,			// _obt@󂯎ϐ
			NULL));

	// **** _obt@ւ̏ ****
	VertexBuffer *pVBuffer;
	V_RETURN(g_pD3DVBuffer->Lock(
			0, 0,             // ŜbN
			(LPVOID*)&pVBuffer, 0));
	// ̂̒_f[^
	pVBuffer[0].x =  1.0f; pVBuffer[0].y =  1.0f; pVBuffer[0].z = -1.0f; pVBuffer[0].tx = 0.8f; pVBuffer[0].ty = 0.8f;
	pVBuffer[1].x =  1.0f; pVBuffer[1].y =  1.0f; pVBuffer[1].z =  1.0f; pVBuffer[1].tx = 0.2f; pVBuffer[1].ty = 0.8f;
	pVBuffer[2].x =  1.0f; pVBuffer[2].y = -1.0f; pVBuffer[2].z = -1.0f; pVBuffer[2].tx = 0.8f; pVBuffer[2].ty = 0.2f;
	pVBuffer[3].x =  1.0f; pVBuffer[3].y = -1.0f; pVBuffer[3].z =  1.0f; pVBuffer[3].tx = 0.2f; pVBuffer[3].ty = 0.2f;
	for (int i=0; i<4; i++)
	{
		pVBuffer[i+ 4] = pVBuffer[i]; pVBuffer[i+ 4].x = -pVBuffer[i].y; pVBuffer[i+ 4].y =  pVBuffer[i].x; // Y+
		pVBuffer[i+ 8] = pVBuffer[i]; pVBuffer[i+ 8].x = -pVBuffer[i].x; pVBuffer[i+ 8].z = -pVBuffer[i].z; // X-
		pVBuffer[i+12] = pVBuffer[i]; pVBuffer[i+12].x =  pVBuffer[i].y; pVBuffer[i+12].y = -pVBuffer[i].x; // Y-
		pVBuffer[i+16] = pVBuffer[i]; pVBuffer[i+16].x = -pVBuffer[i].z; pVBuffer[i+16].z =  pVBuffer[i].x; // Z+
		pVBuffer[i+20] = pVBuffer[i]; pVBuffer[i+20].x =  pVBuffer[i].z; pVBuffer[i+20].z = -pVBuffer[i].x; // Z-
	}
	g_pD3DVBuffer->Unlock(); // AbN

	// **** CfbNXEobt@̍쐬 ****
	V_RETURN(pd3dDevice->CreateIndexBuffer(
			36 * 2,					// 36_16rbgECfbNXEobt@
			0,						// gp@
			D3DFMT_INDEX16,			// 16rbgECfbNXEobt@
			D3DPOOL_MANAGED,		// Direct3DŃǗ
			&g_pD3DIBuffer,			// CfbNXEobt@󂯎ϐ
			NULL));

	// **** CfbNXEobt@ւ̏ ****
	WORD *pIBuffer;
	V_RETURN(g_pD3DIBuffer->Lock(0, 0, (LPVOID*)&pIBuffer, 0));  // bN
	// CfbNX̏
	for (int h=0,i=0; i<36; h+=4,i+=6)
	{
		pIBuffer[i]   = h;   pIBuffer[i+1] = h+1; pIBuffer[i+2] = h+2;
		pIBuffer[i+3] = h+2; pIBuffer[i+4] = h+1; pIBuffer[i+5] = h+3;
	}
	g_pD3DIBuffer->Unlock();    // AbN

	// **** GtFNg̍쐬 ****
	// fxt@Č
	WCHAR fxFileName[MAX_PATH];
	DXUTFindDXSDKMediaFileCch(fxFileName, MAX_PATH, L"Shader5.fx");

	// ID3DXEffectC^[tFCX̍쐬
	V_RETURN(D3DXCreateEffectFromFile(
		pd3dDevice,				// GtFNgfoCX
		fxFileName,				// GtFNgEt@C
		NULL,
		NULL,
		0,						// RpCEIvV
		NULL,
		&g_pD3DXEffect,			// GtFNg󂯎ϐ
		NULL));

	// eNjbN̗
	D3DXHANDLE hTech = NULL;    // ݂̃eNjbÑnh
	D3DXHANDLE hTechNext;       // ̃eNjbÑnh
	for (int i=0; i<MAX_TECH; i++)
	{
		V(g_pD3DXEffect->FindNextValidTechnique(hTech, &hTechNext));
		if (FAILED(hr))
			break;	// G[
		if (hTechNext == NULL)
			break;

		// eNjbÑnh(hTechNext)擾
		hTech = hTechNext;

		// eNjbN̑Ó`FbN
		V_RETURN(g_pD3DXEffect->ValidateTechnique(hTech));

		// eNjbNo^
		g_hTech[i] = hTech;

		// eNjbNXgE{bNXɓo^
		D3DXTECHNIQUE_DESC TechDesc;
		g_pD3DXEffect->GetTechniqueDesc(hTech, &TechDesc);  // eNjbN̖O
		WCHAR strTechName[256];
		MultiByteToWideChar(CP_ACP, 0, TechDesc.Name, -1, strTechName, 256);  // ANSIUNICODE
		strTechName[255] = 0;
		g_SampleUI.GetListBox(ID_LISTBOX1)->AddItem(strTechName, NULL);
	}
	g_SampleUI.GetListBox(ID_LISTBOX1)->SelectItem(0);

	// nh̎擾
	g_hWorldViewProj = g_pD3DXEffect->GetParameterByName(NULL, "WorldViewProj");
	g_hTex           = g_pD3DXEffect->GetParameterByName(NULL, "Tex");

	// **** eNX`̍쐬 ****
	// ǂݍރeNX`Et@Č
	TCHAR TexFileName[MAX_PATH];
	V_RETURN(DXUTFindDXSDKMediaFileCch(TexFileName, MAX_PATH, L"image2.dds"));

	// eNX`ǂݍ
	V_RETURN(D3DXCreateTextureFromFile(pd3dDevice, TexFileName, &g_pTexture));

	return hr;
}

// *****************************************
// **** bZ[W֘ÃR[obN֐

// EChEEbZ[W̏(R[obN֐)
LRESULT CALLBACK DXUTCallbackMsgProc(
			HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, bool *pbNoFurtherProcessing, void* pUserContext)
{
	// GUI\[XǗ
	*pbNoFurtherProcessing = g_DialogResourceManager.MsgProc( hWnd, uMsg, wParam, lParam );
	if( *pbNoFurtherProcessing )
		return 0;

	// foCXݒ_CAO
	if( g_SettingsDlg.IsActive() )
	{
		g_SettingsDlg.MsgProc( hWnd, uMsg, wParam, lParam );
		return 0;
	}

	// foCX֘A_CAÕbZ[W
	*pbNoFurtherProcessing = g_DeviceUI.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	// Xe[^X\_CAÕbZ[W
	*pbNoFurtherProcessing = g_StatusUI.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	// _CAO@̃bZ[W
	*pbNoFurtherProcessing = g_SampleUI.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	*pbNoFurtherProcessing = false;  // t[[NŃbZ[W
	return 0;
}

// *****************************************
// **** V[`֘ÃR[obN֐

// V[̍XV(R[obN֐)
void CALLBACK DXUTCallbackFrameMove(
		double fTime, float fElapsedTime, void* pUserContext)
{
	// D3D9foCX̎擾
	LPDIRECT3DDEVICE9 pd3dDevice = DXUTGetD3D9Device();

	// Xe[^X̕\
	g_StatusUI.GetStatic(ID_DEVICESTATUS)->SetText(DXUTGetDeviceStats());
	g_StatusUI.GetStatic(ID_FRAMESTATUS)->SetText(DXUTGetFrameStats(true));

	// V[̕`pϊs
	D3DXMATRIX matWorld, matView, matProj;
	FLOAT ry = (float)fTime * D3DX_PI / 2.0f;		// ]px(4b1])
	D3DXMatrixRotationY(&matWorld, ry);				// [hϊs(Y𒆐Sɉ])

	D3DXMatrixLookAtLH(&matView, &g_vEye, &g_vAt, &g_vUp);	// r[ϊs

	D3DXMatrixPerspectiveFovLH(&matProj,				// eϊ
				D3DX_PI/6.0f,							// p30x
				g_Aspect,	// AXyNg
				1.0f,		// Oeʂ܂ł̋
				15.0f);		// eʂ܂ł̋

	g_matWorldViewProj = matWorld * matView * matProj;

	// _錾̓o^
	HRESULT hr;
	V(pd3dDevice->SetVertexDeclaration(g_pVertexDeclaration));
	// _Xg[̓o^
	V(pd3dDevice->SetStreamSource(0, g_pD3DVBuffer, 0, sizeof(VertexBuffer)));
	// CfbNXEobt@̓o^
	V(pd3dDevice->SetIndices(g_pD3DIBuffer));
}

// V[̕`(R[obN֐)
void CALLBACK DXUTCallbackFrameRender(
		LPDIRECT3DDEVICE9 pd3dDevice, double fTime, float fElapsedTime, void* pUserContext)
{
	HRESULT hr;

	// foCXݒ_CAO
	if( g_SettingsDlg.IsActive() )
	{
		g_SettingsDlg.OnRender( fElapsedTime );
		return;
	}

	// V[̃NA
	pd3dDevice->Clear(0, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER, D3DCOLOR_XRGB(0, 0, 255), 1.0f, 0);

	// V[̕`Jn
	if (SUCCEEDED(pd3dDevice->BeginScene()))
	{
		// VF[_ŎgeNjbNI
		int TechNum = g_SampleUI.GetListBox(ID_LISTBOX1)->GetSelectedIndex();
		TechNum = TechNum < 0 ? TechNum = 0 : (TechNum >= MAX_TECH ? MAX_TECH - 1 : TechNum);
		g_pD3DXEffect->SetTechnique(g_hTech[TechNum]);    // XgE{bNXőIĂeNjbNg

		// GtFNg̃O[oϐݒ
		g_pD3DXEffect->SetMatrix(g_hWorldViewProj, &g_matWorldViewProj);	// ϊs̐ݒ

		// GtFNǵuTexvϐɁAeNX`ݒ
		g_pD3DXEffect->SetTexture(g_hTex, g_pTexture);

		// eNjbN̊Jn
		UINT numPass;
		V(g_pD3DXEffect->Begin(&numPass, 0));      //eNjbN̊Jn(Xe[gۑ)

		// eNjbÑpXs
		for (UINT iPass = 0; iPass < numPass; iPass++)
		{
			V(g_pD3DXEffect->BeginPass(iPass));     // iPassԖڂ̃pX̎sJn
			if (FAILED(hr))
				break;   // pX̎sɎs

			// BeginPasšŁAGtFNgSet`\bhsꍇɕKv
			g_pD3DXEffect->CommitChanges();  // ̃R[hł͕KvȂAƂĎsĂ

			// bV`
			pd3dDevice->DrawIndexedPrimitive(
				D3DPT_TRIANGLELIST,		// v~eBu^ƂāAOp`Xgw
				0,						// ŏ̒_CfbNX܂ł̃ItZbg
				0,						// ŏ̒_CfbNX
				24,						// _̐
				0,						// CfbNXEobt@̒ŁA_̓ǂݎJnʒu
				12);					// `悷v~eBu̐

			g_pD3DXEffect->EndPass();				// pX̎sI
		}

		// eNjbN̏I
		V(g_pD3DXEffect->End());             // eNjbN̏I(ۑXe[g𕜌)

		// _CAO`
		g_DeviceUI.OnRender(fElapsedTime);
		g_StatusUI.OnRender(fElapsedTime);
		g_SampleUI.OnRender(fElapsedTime);

		// V[̕`I
		pd3dDevice->EndScene();
	}
}

// *****************************************
// **** foCX̏֘ÃR[obN֐

// foCX̏(R[obN֐)
void CALLBACK DXUTCallbackDeviceLost(void* pUserContext)
{
	// GUI\[XǗ
	g_DialogResourceManager.OnD3D9LostDevice();
	g_SettingsDlg.OnD3D9LostDevice();

	// GtFNg̏
	if (g_pD3DXEffect)
		g_pD3DXEffect->OnLostDevice();
}

// foCX̃XgA(R[obN֐)
HRESULT CALLBACK DXUTCallbackDeviceReset(
			LPDIRECT3DDEVICE9 pd3dDevice, const D3DSURFACE_DESC *pBackBufferSurfaceDesc, void* pUserContext)
{
	HRESULT hr = S_OK;

	// GUI\[XǗ
	V_RETURN( g_DialogResourceManager.OnD3D9ResetDevice() );
	V_RETURN( g_SettingsDlg.OnD3D9ResetDevice() );

	// r[|[g̐ݒ
	D3DVIEWPORT9 vp;
	vp.X		= 0;
	vp.Y		= 0;
	vp.Width	= pBackBufferSurfaceDesc->Width;
	vp.Height	= pBackBufferSurfaceDesc->Height;
	vp.MinZ		= 0.0f;
	vp.MaxZ		= 1.0f;
	V_RETURN(pd3dDevice->SetViewport(&vp));

	// ʂ̃AXyNg
	g_Aspect = (float)pBackBufferSurfaceDesc->Width / (float)pBackBufferSurfaceDesc->Height;

	// GtFNg̃XgA
	if (g_pD3DXEffect)
		g_pD3DXEffect->OnResetDevice();

	// _CAO̔zu
	g_DeviceUI.SetLocation(pBackBufferSurfaceDesc->Width - 150, 0);     // _CAO̍W(-150, 0)
	g_DeviceUI.SetSize(150, 110);     // _CAȎ傫(150~110)

	g_StatusUI.SetLocation(0, 0);     // _CAO̍W(0, 0)
	g_StatusUI.SetSize(500, 50);      // _CAȎ傫(500~50)

	g_SampleUI.SetLocation(pBackBufferSurfaceDesc->Width  - 150, 
							pBackBufferSurfaceDesc->Height - 100);      // _CAO̍W(-150, -100)
	g_SampleUI.SetSize(150, 100);     // _CAȎ傫(150~100)

	return hr;	// I
}

// *****************************************
// **** foCX폜֘ÃR[obN֐

// foCX폜̏(R[obN֐)
void CALLBACK DXUTCallbackDeviceDestroyed(void* pUserContext)
{
	// GUI\[XǗ
	g_DialogResourceManager.OnD3D9DestroyDevice();
	g_SettingsDlg.OnD3D9DestroyDevice();

	// 擾IuWFNg̊J
	SAFE_RELEASE(g_pVertexDeclaration);
	SAFE_RELEASE(g_pTexture);
	SAFE_RELEASE(g_pD3DIBuffer);
	SAFE_RELEASE(g_pD3DVBuffer);
	SAFE_RELEASE(g_pD3DXEffect);
}

// *****************************************
// WinMain֐ƃAvP[V֘Ȁ

// AvP[V֘Ȁ
void InitApp(void)
{
	// GUI\[XǗ(_CAȌ)
	g_SettingsDlg.Init( &g_DialogResourceManager );
	g_DeviceUI.Init( &g_DialogResourceManager );
	g_StatusUI.Init( &g_DialogResourceManager );
	g_SampleUI.Init( &g_DialogResourceManager );

	// Windows 2000pɓ{tHgݒ(Vista,XPł͕sv)B
	g_DeviceUI.SetFont( 0, L"lr SVbN", 14, FW_NORMAL );
	g_SampleUI.SetFont( 0, L"lr SVbN", 14, FW_NORMAL );

	// GUIRg[̃bZ[W󂯎R[obN֐_CAOɓo^
	g_DeviceUI.SetCallback(DXUTCallbackGUIEvent);
	g_SampleUI.SetCallback(DXUTCallbackGUIEvent);

	// GUIRg[_CAOɓo^
	int iY = 10;
	g_DeviceUI.AddButton(ID_DISPLAYMODE,  L"ʃ[h",   10, iY,       125, 22);
	g_DeviceUI.AddButton(ID_HALREF,       L"foCX",     10, iY += 24, 125, 22);
	g_DeviceUI.AddButton(ID_CHANGEDEVICE, L"foCXݒ", 10, iY += 24, 125, 22);
	g_DeviceUI.AddButton(ID_PAUSE,        L"ꎞ~",     10, iY += 24, 125, 22);

	// GUIRg[_CAOɓo^
	iY = 0;
	g_StatusUI.AddStatic(ID_DEVICESTATUS, L"", 10, iY,       490, 22);
	g_StatusUI.GetStatic(ID_DEVICESTATUS)->GetElement(0)->SetFont(0, D3DCOLOR_ARGB(255,255,0,255), DT_LEFT | DT_VCENTER);
	g_StatusUI.AddStatic(ID_FRAMESTATUS,  L"", 10, iY += 24, 490, 22);
	g_StatusUI.GetStatic(ID_FRAMESTATUS)->GetElement(0)->SetFont(0, D3DCOLOR_ARGB(255,0,255,255), DT_LEFT | DT_VCENTER);

	// GUIRg[_CAOɓo^
	iY = 0;
	g_SampleUI.AddListBox(ID_LISTBOX1, 10, iY, 125, 88);
}

// **** WinMain֐
int WINAPI wWinMain(HINSTANCE, HINSTANCE, LPWSTR, int)
{
	// fobO q[v }l[Wɂ郁蓖Ă̒ǐՕ@ݒ
#if defined(DEBUG) || defined(_DEBUG)
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
#endif

	// ** R[obN֐̓o^ **
	// foCX쐬̏
	DXUTSetCallbackD3D9DeviceCreated(DXUTCallbackDeviceCreated);
	// EChEEbZ[W̏
	DXUTSetCallbackMsgProc(DXUTCallbackMsgProc);
	// V[̍XV
	DXUTSetCallbackFrameMove(DXUTCallbackFrameMove);
	// V[̕`
	DXUTSetCallbackD3D9FrameRender(DXUTCallbackFrameRender);
	// foCX̏
	DXUTSetCallbackD3D9DeviceLost(DXUTCallbackDeviceLost);
	// foCX̃XgA
	DXUTSetCallbackD3D9DeviceReset(DXUTCallbackDeviceReset);
	// foCX폜̏
	DXUTSetCallbackD3D9DeviceDestroyed(DXUTCallbackDeviceDestroyed);

	// p\ȃfoCX̗
	DXUTSetCallbackD3D9DeviceAcceptable(DXUTCallbackIsDeviceAcceptable);
	// 쐬foCXݒ̕ύX
	DXUTSetCallbackDeviceChanging(DXUTCallbackModifyDeviceSettings);

	// tXN[E[hŃ}EXEJ[\\
	DXUTSetCursorSettings(true, true);

	// **  **
	InitApp();				// AvP[V֘Ȁ

	DXUTInit(true, true);                     // TvEt[[N̏
	DXUTSetHotkeyHandling(true);              // zbgEL[̐ݒ
	DXUTCreateWindow(L"Direct3D 9 Sample20"); // EChE̍쐬

	DXUTCreateDevice(true, 640, 480);  // foCX̍쐬(R[obN֐̎s)

	// ** CE[v **
	DXUTMainLoop();    // bZ[WE[vs

	return DXUTGetExitCode();  // I
}
