/*----------------------------------------------------------
	Direct3D9Tv
		EMicrosoft DirectX SDK (June 2010)
		EVisual Studio 2010 Express
		EWindows XP or Windows Vista or Windows 7
		E_/sNZEVF[_2.0
		Ή

	D3D9Sample27.cpp
		u|CgEXvCggTvv
--------------------------------------------------------------*/

#define D3DXFX_LARGEADDRESS_HANDLE	// D3DXHANDLEp[^ɓnȂ
#define DXUT_AUTOLIB		// DXUTŕKvȃCu(dsound.libȊO)IɃN
#include "DXUT.h"			// DXUTg
#include "SDKmisc.h"		// DXUT Optionalg
#include "DXUTgui.h"		// DXUT OptionalGUIg
#include "DXUTSettingsDlg.h"	//DXUT OptionalCD3DSettingsDlgNXg
#include "SDKmesh.h"		// DXUT OptionalCDXUTXFileMeshNXg
#include "resource.h"

// DXUT̃CuN
#if defined(DEBUG) || defined(_DEBUG)
#pragma comment( lib, "..\\Debug\\DXUT.lib" )
#pragma comment( lib, "..\\Debug\\DXUTOpt.lib" )
#else
#pragma comment( lib, "..\\Release\\DXUT.lib" )
#pragma comment( lib, "..\\Release\\DXUTOpt.lib" )
#endif

// *****************************************
// **** O[oϐ

// J
D3DXVECTOR3 g_vEye(0.0f, 2.0f, -2.0f);		// J̍W
D3DXVECTOR3 g_vAt(0.0f, 0.0f, 0.0f);		// _
D3DXVECTOR3 g_vUp(0.0f, 1.0f, 0.0f);		// J̏xNg

D3DXMATRIX g_matWorldViewProj;				// [h~r[~ϊs
float g_Aspect;								// ʂ̃AXyNg
float g_fTime = 0.0f;

// 
D3DXVECTOR3 g_vLight(2.0, 2.0f, -2.0f);		// ̍W
float       g_fLightBrightness = 25.0f;		// ̋Px

D3DXVECTOR4 g_vLightModel;					// ̍W(f)

// GtFNg
LPD3DXEFFECT g_pD3DXEffect = NULL;			// `ɎgGtFNg

D3DXHANDLE g_hFloor_Tech      = NULL;	// ̕`ɎgeNjbN
D3DXHANDLE g_hPointList2_Tech = NULL;	// |CgEXvCg(e)̕`ɎgeNjbN
D3DXHANDLE g_hPointList_Tech  = NULL;	// |CgEXvCg̕`ɎgeNjbN

D3DXHANDLE g_hWorldViewProj   = NULL;	// ϊs
D3DXHANDLE g_hLightPos        = NULL;	// ̈ʒu
D3DXHANDLE g_hLightBrightness = NULL;	// ̋Px
D3DXHANDLE g_hModelScale      = NULL;	// fԂ̃XP[
D3DXHANDLE g_hTexFloor        = NULL;	// GtFNg̃eNX`ϐ
D3DXHANDLE g_hDiffuse         = NULL;	// GtFNg̃fBt[YFϐ
D3DXHANDLE g_hfTime           = NULL;	// oߎԐݒ
D3DXHANDLE g_hTex             = NULL;	// |CgEXvCgŎgeNX`

// _f[^̌``\
struct strVertexBuffer {
	float x, y, z;			// 
	float cycle;			// 
};

// _vf̒`
D3DVERTEXELEMENT9 decl[] =
{
	{ 0,  0, D3DDECLTYPE_FLOAT3,   D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_POSITION,    0 },
	{ 0, 12, D3DDECLTYPE_FLOAT1,   D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_BLENDWEIGHT, 0 },
	D3DDECL_END()
};

// ̃bV
CDXUTXFileMesh *g_pMeshFloor = NULL;			// ̃bV
float			g_fMeshScale = 1.0f;			// bṼXP[

// |CgEXvCg̃f[^
LPDIRECT3DVERTEXBUFFER9      g_pVBuffer = NULL;	// _obt@
LPDIRECT3DVERTEXDECLARATION9 g_pVDecl   = NULL;	// _錾
LPDIRECT3DTEXTURE9           g_pTexture = NULL;	// eNX`

// *****************************************
// **** O[oϐ(GUI@\)

// GUI\[XǗ
CDXUTDialogResourceManager	g_DialogResourceManager; // _CAÕ\[XǗ
CD3DSettingsDlg				g_SettingsDlg;           // foCXݒ_CAO

// foCX֘Aݒ_CAO(E)
enum { ID_DISPLAYMODE = 0, ID_HALREF, ID_CHANGEDEVICE, ID_PAUSE }; // Rg[ID
CDXUTDialog  g_DeviceUI;    // _CAO

// Xe[^X\_CAO()
enum { ID_DEVICESTATUS = 50, ID_FRAMESTATUS }; // Rg[ID
CDXUTDialog  g_StatusUI;    // _CAO

// *****************************************
// **** GUI֘Å֐

// _CAOĂяoR[obN֐
void CALLBACK DXUTCallbackGUIEvent(UINT nEvent, int nControlID, CDXUTControl* pControl, void* pUserContext)
{
	switch (nControlID)
	{
	// foCX֘Aݒ_CAO
	case ID_DISPLAYMODE:	// ʃ[h؂ւ(EChEE[hƃtXN[E[h)
		DXUTToggleFullScreen();
		break;
	case ID_HALREF:			// foCX؂ւ(REFHAL)
		DXUTToggleREF();
		break;
	case ID_CHANGEDEVICE:	// foCXݒʂ̕\
		g_SettingsDlg.SetActive(!g_SettingsDlg.IsActive());
		break;
	case ID_PAUSE:			// ꎞ~
		DXUTPause(!DXUTIsTimePaused(), false);
		break;
	}
}

// *****************************************
// **** foCX쐬֘ÃR[obN֐

// p\ȃfoCX̗(R[obN֐)
bool CALLBACK DXUTCallbackIsDeviceAcceptable(
		D3DCAPS9 *pCaps, D3DFORMAT AdapterFormat, D3DFORMAT BackBufferFormat, bool bWindowed, void* pUserContext)

{
	if (pCaps->MaxPrimitiveCount < 0xFFFF)		// v~eBu
		return false;
	if (pCaps->MaxVertexIndex < 0xFFF0)			// CfbNX
		return false;
	if (pCaps->PixelShaderVersion < D3DPS_VERSION(2, 0))	// sNZEVF[_
		return false;

	return true;	// ̃foCX̎gpe
}

// 쐬foCXݒ̕ύX(R[obN֐)
bool CALLBACK DXUTCallbackModifyDeviceSettings(
		DXUTDeviceSettings *pDeviceSettings, void* pUserContext)
{
	// Direct3D 9foCXg邱ƂmF
	if( pDeviceSettings->ver == DXUT_D3D9_DEVICE )
	{
		// D3D9foCX̔\͂擾
		D3DCAPS9 caps;
		DXUTGetD3D9DeviceCaps( pDeviceSettings, &caps );

		// ŏɃt@X foCXIꂽƂɁAx\
		static bool s_bFirstTime = true;
		if( s_bFirstTime )
		{
			s_bFirstTime = false;
			if( pDeviceSettings->d3d9.DeviceType == D3DDEVTYPE_REF )
				DXUTDisplaySwitchingToREFWarning(pDeviceSettings->ver);
		}

		// o[W2.0̒_VF[_n[hEFAŃT|[gĂȂꍇ́A\tgEFAg
		if ((caps.DevCaps & D3DDEVCAPS_HWTRANSFORMANDLIGHT) == 0 ||
				caps.VertexShaderVersion < D3DVS_VERSION(2, 0))
		{
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_HARDWARE_VERTEXPROCESSING;
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_PUREDEVICE;
			pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_SOFTWARE_VERTEXPROCESSING;	// \tgEFA_
		}
		else
		{
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_SOFTWARE_VERTEXPROCESSING;
			pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_HARDWARE_VERTEXPROCESSING;	//n[hEFA_
		}

		// Avdouble^g(x͒ቺ)
		pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_FPU_PRESERVE;
	}

	return true;
}

// foCX쐬̏(R[obN֐)
HRESULT CALLBACK DXUTCallbackDeviceCreated(
			LPDIRECT3DDEVICE9 pd3dDevice, const D3DSURFACE_DESC *pBackBufferSurfaceDesc, void* pUserContext)
{
	HRESULT hr;

	// GUI\[XǗ
	V_RETURN( g_DialogResourceManager.OnD3D9CreateDevice( pd3dDevice ) );
	V_RETURN( g_SettingsDlg.OnD3D9CreateDevice( pd3dDevice ) );

	// **** GtFNg̍쐬 ****
	// fxt@Č
	WCHAR fxFileName[MAX_PATH];
	DXUTFindDXSDKMediaFileCch(fxFileName, MAX_PATH, L"Shader11.fx");

	// ID3DXEffectC^[tFCX̍쐬
	V_RETURN(D3DXCreateEffectFromFile(
		pd3dDevice,				// GtFNgfoCX
		fxFileName,				// GtFNgEt@C
		NULL,
		NULL,
		0,						// RpCEIvV
		NULL,
		&g_pD3DXEffect,			// GtFNg󂯎ϐ
		NULL));

	// nh̎擾
	g_hFloor_Tech      = g_pD3DXEffect->GetTechniqueByName("Floor_Tech");
	g_hPointList2_Tech = g_pD3DXEffect->GetTechniqueByName("PointList2_Tech");
	g_hPointList_Tech  = g_pD3DXEffect->GetTechniqueByName("PointList_Tech");

	g_hWorldViewProj   = g_pD3DXEffect->GetParameterByName(NULL, "WorldViewProj");
	g_hLightPos        = g_pD3DXEffect->GetParameterByName(NULL, "LightPos");
	g_hLightBrightness = g_pD3DXEffect->GetParameterByName(NULL, "LightBrightness");
	g_hModelScale      = g_pD3DXEffect->GetParameterByName(NULL, "ModelScale");
	g_hTexFloor        = g_pD3DXEffect->GetParameterByName(NULL, "TexFloor");
	g_hDiffuse         = g_pD3DXEffect->GetParameterByName(NULL, "Diffuse");
	g_hfTime           = g_pD3DXEffect->GetParameterByName(NULL, "fTime");
	g_hTex             = g_pD3DXEffect->GetParameterByName(NULL, "Tex");

	// **** _錾IuWFNg̍쐬 ****
	// _錾IuWFNg̍쐬
	V_RETURN(pd3dDevice->CreateVertexDeclaration(decl, &g_pVDecl));

	// **** _obt@̍쐬 ****
	// _obt@̍쐬
	V_RETURN(pd3dDevice->CreateVertexBuffer(
	        sizeof(strVertexBuffer)*100,// obt@ETCY(̂̒_)
	        0,                          // gp@
	        0,                          // FVF_obt@
	        D3DPOOL_MANAGED,            // Direct3DŃǗ
	        &g_pVBuffer,             // _obt@󂯎ϐ
	        NULL));


	// _obt@ւ̏
	strVertexBuffer *pVBuffer;
	V_RETURN(g_pVBuffer->Lock(
	        0, 0,             // ŜbN
	        (LPVOID*)&pVBuffer, 0));

	for (int i=0; i<100; i++)
	{
		pVBuffer[i].x = (float)(rand() - RAND_MAX/2) / (RAND_MAX * 1.5f);
		pVBuffer[i].y = (float)rand() * 2.0f / RAND_MAX;
		pVBuffer[i].z = (float)(rand() - RAND_MAX/2) / (RAND_MAX * 1.5f);
		pVBuffer[i].cycle = (2.0f * pVBuffer[i].y) / 0.98f;
	}

	g_pVBuffer->Unlock(); // AbN

	// **** eNX`̍쐬 ****
	// |CgEXvCgŎgeNX`̓ǂݍ
	WCHAR texFileName[MAX_PATH];
	DXUTFindDXSDKMediaFileCch(texFileName, MAX_PATH, L"Point.dds");
	V_RETURN(D3DXCreateTextureFromFile(pd3dDevice, texFileName, &g_pTexture));

	return hr;
}

// *****************************************
// **** bZ[W֘ÃR[obN֐

// EChEEbZ[W̏(R[obN֐)
LRESULT CALLBACK DXUTCallbackMsgProc(
			HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, bool *pbNoFurtherProcessing, void* pUserContext)
{
	// GUI\[XǗ
	*pbNoFurtherProcessing = g_DialogResourceManager.MsgProc( hWnd, uMsg, wParam, lParam );
	if( *pbNoFurtherProcessing )
		return 0;

	// foCXݒ_CAO
	if( g_SettingsDlg.IsActive() )
	{
		g_SettingsDlg.MsgProc( hWnd, uMsg, wParam, lParam );
		return 0;
	}

	// foCX֘A_CAÕbZ[W
	*pbNoFurtherProcessing = g_DeviceUI.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	// Xe[^X\_CAÕbZ[W
	*pbNoFurtherProcessing = g_StatusUI.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	*pbNoFurtherProcessing = false;  // t[[NŃbZ[W
	return 0;
}

// *****************************************
// **** V[`֘ÃR[obN֐

// V[̍XV(R[obN֐)
void CALLBACK DXUTCallbackFrameMove(
		double fTime, float fElapsedTime, void* pUserContext)
{
	// Xe[^X̕\
	g_StatusUI.GetStatic(ID_DEVICESTATUS)->SetText(DXUTGetDeviceStats());
	g_StatusUI.GetStatic(ID_FRAMESTATUS)->SetText(DXUTGetFrameStats(true));

	// V[̕`pϊs
	D3DXMATRIX matView, matProj;
	D3DXMatrixLookAtLH(&matView, &g_vEye, &g_vAt, &g_vUp);	// r[ϊs

	D3DXMatrixPerspectiveFovLH(&matProj,				// eϊ
				D3DX_PI / 3.0f,							// p60x
				g_Aspect,	// AXyNg
				0.1f,		// Oeʂ܂ł̋
				10.0f);		// eʂ܂ł̋

	g_matWorldViewProj = matView * matProj;

	// fԂł̌̈ʒu(̃Tvł́Afԁ[h)
	g_vLightModel.x = g_vLight.x; g_vLightModel.y = g_vLight.y; g_vLightModel.z = g_vLight.z;
	g_vLightModel.w = 1.0f;

	g_fTime = (float)fTime;
}

// V[̕`(R[obN֐)
void CALLBACK DXUTCallbackFrameRender(
		LPDIRECT3DDEVICE9 pd3dDevice, double fTime, float fElapsedTime, void* pUserContext)
{
	// foCXݒ_CAO
	if( g_SettingsDlg.IsActive() )
	{
		g_SettingsDlg.OnRender( fElapsedTime );
		return;
	}

	// V[̃NA
	pd3dDevice->Clear(0, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER,
						D3DCOLOR_XRGB(0, 0, 255), 1.0f, 0);

	// V[̕`Jn
	if (SUCCEEDED(pd3dDevice->BeginScene()))
	{
		// **** ̕` ****
		// GtFNgŎgeNjbNI
		g_pD3DXEffect->SetTechnique(g_hFloor_Tech);    // eNjbNg

		g_pD3DXEffect->SetMatrix(g_hWorldViewProj, &g_matWorldViewProj);	// ϊs

		// ̈ʒu
		g_pD3DXEffect->SetVector(g_hLightPos, &g_vLightModel);				// ̈ʒu
		g_pD3DXEffect->SetFloat(g_hLightBrightness, g_fLightBrightness);	// ̋Px
		g_pD3DXEffect->SetFloat(g_hModelScale, g_fMeshScale);				// fԂ̃XP[

		// bV`
		g_pMeshFloor->Render(g_pD3DXEffect,
				g_hTexFloor,	// GtFNg̃eNX`ϐ
				g_hDiffuse,		// GtFNg̃fBt[YFϐ
				NULL, NULL, NULL, NULL, true, true);

		// **** |CgEXvCg̕`(e) ****
		// _錾IuWFNg̓o^
		pd3dDevice->SetVertexDeclaration(g_pVDecl);
		// _Xg[̐ݒ
		pd3dDevice->SetStreamSource(0, g_pVBuffer, 0, sizeof(strVertexBuffer)); // Xg[0̐ݒ

		g_pD3DXEffect->SetFloat(g_hfTime, g_fTime);        // oߎԐݒ
		g_pD3DXEffect->SetTexture(g_hTex, g_pTexture);     // |CgEXvCgŎgeNX`

		// GtFNgŎgeNjbNI
		g_pD3DXEffect->SetTechnique(g_hPointList2_Tech);    // eNjbNg

		// eNjbN̎s
		UINT numPass;
		g_pD3DXEffect->Begin(&numPass, 0);                  //eNjbN̊Jn(Xe[gۑ)
		g_pD3DXEffect->BeginPass(0);                        // pX̎sJn
		pd3dDevice->DrawPrimitive(D3DPT_POINTLIST, 0, 100);	// |CgEXvCg̕`
		g_pD3DXEffect->EndPass();				            // pX̎sI
		g_pD3DXEffect->End();                               // eNjbN̏I(ۑXe[g𕜌)

		// **** |CgEXvCg̕`() ****
		// GtFNgŎgeNjbNI
		g_pD3DXEffect->SetTechnique(g_hPointList_Tech);		// eNjbNg

		// eNjbN̊Jn
		g_pD3DXEffect->Begin(&numPass, 0);                  //eNjbN̊Jn(Xe[gۑ)
		g_pD3DXEffect->BeginPass(0);                        // pX̎sJn
		pd3dDevice->DrawPrimitive(D3DPT_POINTLIST, 0, 100);	// |CgEXvCg̕`
		g_pD3DXEffect->EndPass();			                // pX̎sI
		g_pD3DXEffect->End();                               // eNjbN̏I(ۑXe[g𕜌)

		// _CAO`
		g_DeviceUI.OnRender(fElapsedTime);
		g_StatusUI.OnRender(fElapsedTime);

		// V[̕`I
		pd3dDevice->EndScene();
	}
}

// *****************************************
// **** foCX̏֘ÃR[obN֐

// foCX̏(R[obN֐)
void CALLBACK DXUTCallbackDeviceLost(void* pUserContext)
{
	// GUI\[XǗ
	g_DialogResourceManager.OnD3D9LostDevice();
	g_SettingsDlg.OnD3D9LostDevice();

	// bV̏
	if (g_pMeshFloor)
		g_pMeshFloor->InvalidateDeviceObjects();

	// GtFNg̏
	if (g_pD3DXEffect)
		g_pD3DXEffect->OnLostDevice();
}

// foCX̃XgA(R[obN֐)
HRESULT CALLBACK DXUTCallbackDeviceReset(
			LPDIRECT3DDEVICE9 pd3dDevice, const D3DSURFACE_DESC *pBackBufferSurfaceDesc, void* pUserContext)
{
	HRESULT hr = S_OK;

	// GUI\[XǗ
	V_RETURN( g_DialogResourceManager.OnD3D9ResetDevice() );
	V_RETURN( g_SettingsDlg.OnD3D9ResetDevice() );

	// r[|[g̐ݒ
	D3DVIEWPORT9 vp;
	vp.X		= 0;
	vp.Y		= 0;
	vp.Width	= pBackBufferSurfaceDesc->Width;
	vp.Height	= pBackBufferSurfaceDesc->Height;
	vp.MinZ		= 0.0f;
	vp.MaxZ		= 1.0f;
	V_RETURN(pd3dDevice->SetViewport(&vp));

	// ʂ̃AXyNg
	g_Aspect = (float)pBackBufferSurfaceDesc->Width / (float)pBackBufferSurfaceDesc->Height;

	// GtFNg̃XgA
	if (g_pD3DXEffect)
		g_pD3DXEffect->OnResetDevice();

	// _CAO̔zu
	g_DeviceUI.SetLocation(pBackBufferSurfaceDesc->Width - 150, 0);     // _CAO̍W(-150, 0)
	g_DeviceUI.SetSize(150, 110);     // _CAȎ傫(150~110)

	g_StatusUI.SetLocation(0, 0);     // _CAO̍W(0, 0)
	g_StatusUI.SetSize(500, 50);      // _CAȎ傫(500~50)

	// bṼXgA
	if (g_pMeshFloor)
		g_pMeshFloor->RestoreDeviceObjects(pd3dDevice);
	else
	{
		// ̃bVǂݍ܂ĂȂꍇ́Aǂݍ

		// VbV̒_vf
		D3DVERTEXELEMENT9 decl[] = 
		{
			{ 0,  0, D3DDECLTYPE_FLOAT3, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_POSITION, 0 },
			{ 0, 12, D3DDECLTYPE_FLOAT3, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_NORMAL,   0 },
			{ 0, 24, D3DDECLTYPE_FLOAT2, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_TEXCOORD, 0 },
			D3DDECL_END()   // z̏I
		};

		// Xt@C̓ǂݍ
		g_pMeshFloor = new CDXUTXFileMesh();
		hr = g_pMeshFloor->Create(pd3dDevice, L"Floor.x");	// Xt@C
		if (FAILED(hr))
		{
			SAFE_DELETE(g_pMeshFloor);
			return hr;
		}

		// _tH[}bg̐ݒ
		hr = g_pMeshFloor->SetVertexDecl(pd3dDevice, decl);
		if (FAILED(hr))
		{
			SAFE_DELETE(g_pMeshFloor);
			return hr;
		}

		// `pbV̍쐬
		hr = g_pMeshFloor->RestoreDeviceObjects(pd3dDevice);
		if (FAILED(hr)) {
			SAFE_DELETE(g_pMeshFloor);
		    return hr;
		}
	}

	return hr;	// I
}

// *****************************************
// **** foCX폜֘ÃR[obN֐

// foCX폜̏(R[obN֐)
void CALLBACK DXUTCallbackDeviceDestroyed(void* pUserContext)
{
	// GUI\[XǗ
	g_DialogResourceManager.OnD3D9DestroyDevice();
	g_SettingsDlg.OnD3D9DestroyDevice();

	// 擾IuWFNg̊J
	SAFE_DELETE(g_pMeshFloor);

	SAFE_RELEASE(g_pTexture);
	SAFE_RELEASE(g_pVBuffer);
	SAFE_RELEASE(g_pVDecl);
	SAFE_RELEASE(g_pD3DXEffect);
}

// *****************************************
// WinMain֐ƃAvP[V֘Ȁ

// AvP[V֘Ȁ
void InitApp(void)
{
	// GUI\[XǗ(_CAȌ)
	g_SettingsDlg.Init( &g_DialogResourceManager );
	g_DeviceUI.Init( &g_DialogResourceManager );
	g_StatusUI.Init( &g_DialogResourceManager );

	// Windows 2000pɓ{tHgݒ(Vista,XPł͕sv)B
	g_DeviceUI.SetFont( 0, L"lr SVbN", 14, FW_NORMAL );

	// GUIRg[̃bZ[W󂯎R[obN֐_CAOɓo^
	g_DeviceUI.SetCallback(DXUTCallbackGUIEvent);

	// GUIRg[_CAOɓo^
	int iY = 10;
	g_DeviceUI.AddButton(ID_DISPLAYMODE,  L"ʃ[h",   10, iY,       125, 22);
	g_DeviceUI.AddButton(ID_HALREF,       L"foCX",     10, iY += 24, 125, 22);
	g_DeviceUI.AddButton(ID_CHANGEDEVICE, L"foCXݒ", 10, iY += 24, 125, 22);
	g_DeviceUI.AddButton(ID_PAUSE,        L"ꎞ~",     10, iY += 24, 125, 22);

	// GUIRg[_CAOɓo^
	iY = 0;
	g_StatusUI.AddStatic(ID_DEVICESTATUS, L"", 10, iY,       490, 22);
	g_StatusUI.GetStatic(ID_DEVICESTATUS)->GetElement(0)->SetFont(0, D3DCOLOR_ARGB(255,255,0,255), DT_LEFT | DT_VCENTER);
	g_StatusUI.AddStatic(ID_FRAMESTATUS,  L"", 10, iY += 24, 490, 22);
	g_StatusUI.GetStatic(ID_FRAMESTATUS)->GetElement(0)->SetFont(0, D3DCOLOR_ARGB(255,0,255,255), DT_LEFT | DT_VCENTER);
}

// **** WinMain֐
int WINAPI wWinMain(HINSTANCE, HINSTANCE, LPWSTR, int)
{
	// fobO q[v }l[Wɂ郁蓖Ă̒ǐՕ@ݒ
#if defined(DEBUG) || defined(_DEBUG)
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
#endif

	// ** R[obN֐̓o^ **
	// foCX쐬̏
	DXUTSetCallbackD3D9DeviceCreated(DXUTCallbackDeviceCreated);
	// EChEEbZ[W̏
	DXUTSetCallbackMsgProc(DXUTCallbackMsgProc);
	// V[̍XV
	DXUTSetCallbackFrameMove(DXUTCallbackFrameMove);
	// V[̕`
	DXUTSetCallbackD3D9FrameRender(DXUTCallbackFrameRender);
	// foCX̏
	DXUTSetCallbackD3D9DeviceLost(DXUTCallbackDeviceLost);
	// foCX̃XgA
	DXUTSetCallbackD3D9DeviceReset(DXUTCallbackDeviceReset);
	// foCX폜̏
	DXUTSetCallbackD3D9DeviceDestroyed(DXUTCallbackDeviceDestroyed);

	// p\ȃfoCX̗
	DXUTSetCallbackD3D9DeviceAcceptable(DXUTCallbackIsDeviceAcceptable);
	// 쐬foCXݒ̕ύX
	DXUTSetCallbackDeviceChanging(DXUTCallbackModifyDeviceSettings);

	// tXN[E[hŃ}EXEJ[\\
	DXUTSetCursorSettings(true, true);

	// **  **
	InitApp();				// AvP[V֘Ȁ

	DXUTInit(true, true);                     // TvEt[[N̏
	DXUTSetHotkeyHandling(true);              // zbgEL[̐ݒ
	DXUTCreateWindow(L"Direct3D 9 Sample27"); // EChE̍쐬

	DXUTCreateDevice(true, 640, 480);  // foCX̍쐬(R[obN֐̎s)

	// ** CE[v **
	DXUTMainLoop();    // bZ[WE[vs

	return DXUTGetExitCode();  // I
}
