/*----------------------------------------------------------
	DirectInputTv
		EMicrosoft DirectX SDK (February 2007)
		EVisual Studio 2005 Standard
		EWindows XP or Windows Vista
		Ή

	DISample01.cpp
		u}EX́v
--------------------------------------------------------------*/

#define STRICT
#define DIRECTINPUT_VERSION 0x0800

#include <windows.h>
#include <crtdbg.h>

#pragma warning( disable : 4996 ) // xꎞIɖɂ 
#include <strsafe.h>
#pragma warning( default : 4996 ) 

#include <dinput.h>
#include <dxerr.h>

#include "resource.h"

#define SAFE_RELEASE(x)	{if(x){(x)->Release();x=NULL;}}

// KvȃCuN
#pragma comment( lib, "dinput8.lib" )
#pragma comment( lib, "dxerr.lib" )
#pragma comment( lib, "dxguid.lib" )

/*-------------------------------------------
	Oϐ
--------------------------------------------*/
// AvP[V
HINSTANCE hInstApp;								// CX^XEnh
HWND hwndApp;									// EChEEnh
WCHAR szAppName[] = L"DirectInput Sample 1";	// AvP[V
bool g_bActive = true;							// EChẼANeBu

// DirectInput̕ϐ
LPDIRECTINPUT8 g_pDInput = NULL;					// DirectInput
LPDIRECTINPUTDEVICE8 g_pDIDevice = NULL;			// DirectInputfoCX
#define DIDEVICE_BUFFERSIZE	100						// foCXɐݒ肷obt@ETCY

// bZ[W֐̒`
LRESULT CALLBACK MainWndProc(HWND hWnd,UINT msg,UINT wParam,LONG lParam);

/*-------------------------------------------
	AvP[V
--------------------------------------------*/
bool InitApp(HINSTANCE hInst,int nCmdShow)
{
	hInstApp=hInst;

	// EChEENX̓o^
	WNDCLASS wndclass;
	wndclass.hCursor		= LoadCursor(NULL,IDC_ARROW);
	wndclass.hIcon			= LoadIcon(hInst, (LPCTSTR)IDI_ICON1);
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= szAppName;
	wndclass.hbrBackground	= (HBRUSH)(COLOR_WINDOW + 1);
	wndclass.hInstance		= hInst;
	wndclass.style			= CS_BYTEALIGNCLIENT|CS_VREDRAW|CS_HREDRAW;
	wndclass.lpfnWndProc	= (WNDPROC)MainWndProc;
	wndclass.cbClsExtra		= 0;
	wndclass.cbWndExtra		= 0;

	if(!RegisterClass(&wndclass))
		return false;

	// CEEChE
	hwndApp = CreateWindowEx(0,szAppName,szAppName,
							WS_OVERLAPPEDWINDOW,
							CW_USEDEFAULT,CW_USEDEFAULT,640,480,
							(HWND)NULL,(HMENU)NULL,
							hInst,(LPSTR)NULL);
	ShowWindow(hwndApp,nCmdShow);
	UpdateWindow(hwndApp);

	return true;
}

/*-------------------------------------------
	DirectInput 
---------------------------------------------*/
bool InitDInput(void)
{
	HRESULT hr;

	// *****************************************
	// DirectInput̍쐬
	hr = DirectInput8Create(hInstApp, DIRECTINPUT_VERSION, 
							IID_IDirectInput8, (void**)&g_pDInput, NULL); 
	if (FAILED(hr)) 
	{
		DXTRACE_ERR(L"DirectInput8IuWFNg̍쐬Ɏs", hr);
		return false;
	}

	// foCXEIuWFNg쐬
	hr = g_pDInput->CreateDevice(GUID_SysMouse, &g_pDIDevice, NULL); 
	if (FAILED(hr)) {
		DXTRACE_ERR(L"DirectInputDevice8IuWFNg̍쐬Ɏs", hr);
	    return false;
	}

	// f[^`ݒ
	hr = g_pDIDevice->SetDataFormat(&c_dfDIMouse2);
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"c_dfDIMouse2`̐ݒɎs", hr);
		return false;
	}

	//[hݒitHAOEhr[hj
	hr = g_pDIDevice->SetCooperativeLevel(hwndApp, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND);
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"tHAOEhr[h̐ݒɎs", hr);
		return false;
	}

	// [hݒiΒl[hɐݒj
	DIPROPDWORD diprop;
	diprop.diph.dwSize	= sizeof(diprop); 
	diprop.diph.dwHeaderSize	= sizeof(diprop.diph); 
	diprop.diph.dwObj	= 0;
	diprop.diph.dwHow	= DIPH_DEVICE;
	diprop.dwData		= DIPROPAXISMODE_REL;
//	diprop.dwData		= DIPROPAXISMODE_ABS;	// Βl[h̏ꍇ
	hr = g_pDIDevice->SetProperty(DIPROP_AXISMODE, &diprop.diph);
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"[h̐ݒɎs", hr);
		return false;
	}

	// obt@OEf[^擾邽߁Aobt@ETCYݒ
	diprop.dwData = DIDEVICE_BUFFERSIZE;
	hr = g_pDIDevice->SetProperty(DIPROP_BUFFERSIZE, &diprop.diph);
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"obt@ETCY̐ݒɎs", hr);
		return false;
	}

	// ͐Jn
	g_pDIDevice->Acquire();

	return true;
}

/*-------------------------------------------
	DirectInput̉
--------------------------------------------*/
bool ReleaseDInput(void)
{
	// DirectInput̃foCX
	if (g_pDIDevice)
		g_pDIDevice->Unacquire(); 
	SAFE_RELEASE(g_pDIDevice);
	SAFE_RELEASE(g_pDInput);

	return true;
}

/*-------------------------------------------
	Ȉ
--------------------------------------------*/
bool EndApp(void)
{
	return true;
}

/*-------------------------------------------
	L[͏
--------------------------------------------*/
void WM_KeyDown(HWND hWnd, UINT wParam)
{
	switch(wParam){
		// EChE
		case VK_ESCAPE:
			DestroyWindow(hWnd);
			return;
	}
}

/*-------------------------------------------
	^C}[
--------------------------------------------*/
void WM_Timer(HWND hWnd, WPARAM wParam)
{
	// ʍXV
	InvalidateRect(hWnd, NULL, TRUE);
}

/*-------------------------------------------
	EChE̕`揈
--------------------------------------------*/
void WM_Paint(HWND hWnd)
{
	PAINTSTRUCT ps;
	HDC hDC = BeginPaint(hWnd, &ps);

	if (g_pDIDevice!=NULL)
	{
		HRESULT hr;
		WCHAR CData[256];
		int y = 0;

		// foCX̒ڃf[^擾
		DIMOUSESTATE2 dims;
		hr = g_pDIDevice->GetDeviceState(sizeof(DIMOUSESTATE2), &dims);
		if (SUCCEEDED(hr))
		{
			hr = StringCbPrintf(CData, sizeof(CData), L"Βl[h (%d, %d, %d) %s %s %s             ",
							dims.lX, dims.lY, dims.lZ,
							(dims.rgbButtons[0] & 0x80) ? L"" : L"--",
							(dims.rgbButtons[1] & 0x80) ? L"E" : L"--",
							(dims.rgbButtons[2] & 0x80) ? L"" : L"--");
			if (SUCCEEDED(hr))
				TextOut(hDC, 0, y, CData, lstrlen(CData));
		}
		else if (g_bActive && hr==DIERR_INPUTLOST)
			g_pDIDevice->Acquire();
		y += 40;

		// obt@OEf[^擾
		while(g_bActive)
		{
			DIDEVICEOBJECTDATA od;
			DWORD dwItems = 1;
			hr = g_pDIDevice->GetDeviceData(sizeof(DIDEVICEOBJECTDATA),
								&od, &dwItems, 0);
			if (hr==DIERR_INPUTLOST)
				g_pDIDevice->Acquire();
			else if (FAILED(hr) || dwItems == 0)
	            break;	// f[^ǂ߂ȂA݂Ȃ
			else
			{
				switch (od.dwOfs) 
				{
				// }EX̐B
				case DIMOFS_X:
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIMOFS_X = %d", od.dwSequence, od.dwData);
					break;
				// }EX̐B
				case DIMOFS_Y: 
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIMOFS_Y = %d", od.dwSequence, od.dwData);
					break;
				// E{^ꂽA܂͗ꂽB 
				case DIMOFS_BUTTON0:
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIMOFS_BUTTON0 = %s", od.dwSequence, (od.dwData & 0x80) ? L"UP" : L"DOWN");
					break;
				// {^ꂽA܂͗ꂽB
				case DIMOFS_BUTTON1:
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIMOFS_BUTTON1 = %s", od.dwSequence, (od.dwData & 0x80) ? L"UP" : L"DOWN");
					break;
				// {^ꂽA܂͗ꂽB
				case DIMOFS_BUTTON2:
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIMOFS_BUTTON4 = %s", od.dwSequence, (od.dwData & 0x80) ? L"UP" : L"DOWN");
					break;
				// S{^ꂽA܂͗ꂽB
				case DIMOFS_BUTTON3:
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIMOFS_BUTTON3 = %s", od.dwSequence, (od.dwData & 0x80) ? L"UP" : L"DOWN");
					break;
				default:
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] %ld = %d", od.dwSequence, od.dwOfs, od.dwData); break;
				}
				if (SUCCEEDED(hr))
					TextOut(hDC, 0, y, CData, lstrlen(CData));
				y += 20;
			}
		}
	}

	EndPaint(hWnd, &ps);
}

/*-------------------------------------------
	EChE
--------------------------------------------*/
LRESULT CALLBACK MainWndProc(HWND hWnd,UINT msg,UINT wParam,LONG lParam)
{
	switch(msg)
	{
		case WM_ACTIVATE:		// EChẼANeBuԂω
			if(g_pDIDevice == NULL)
				break;
			g_bActive = wParam != WA_INACTIVE;
			if(wParam != WA_INACTIVE)
				g_pDIDevice->Acquire();
			break;
		case WM_KEYDOWN:	// L[ꂽ
			WM_KeyDown(hWnd, wParam);
			break;
		case WM_CREATE:		// EChEꂽ
			SetTimer(hWnd, 1, 100, NULL);
			break;
		case WM_DESTROY:	// EChEj
			KillTimer(hWnd, 1);
			PostQuitMessage(0);
			break;
		case WM_TIMER:		// ^C}[ECxg
			WM_Timer(hWnd, wParam);
			break;
		case WM_PAINT:		// ʕ`
			WM_Paint(hWnd);
			break;
		default:			// ̑̃bZ[W
			return DefWindowProc(hWnd,msg,wParam,lParam);
	}
	return 0L;
}

/*--------------------------------------------
	bZ[WȂƂ̏
---------------------------------------------*/
bool AppIdle()
{
	return true;	// falseԂƃbZ[W܂őҋ@
}

/*--------------------------------------------
	C
---------------------------------------------*/
int WINAPI wWinMain(HINSTANCE hInst,HINSTANCE /*hPrevInst*/,LPWSTR /*lpCmdLine*/,int nCmdShow)
{
	// fobO q[v }l[Wɂ郁蓖Ă̒ǐՕ@ݒ
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );

	bool flag = false;
	// AvP[VɊւ鏉
	if (InitApp(hInst,nCmdShow))
	{
		// DirectInputɊւ鏉
		flag = InitDInput();
	}

	// bZ[WE[v
	MSG msg;
	msg.wParam = -1;
	while (flag)
	{
		while(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{
			if (msg.message == WM_QUIT)
			{
				flag = false;
				break;
			}
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		if (AppIdle()==false)
			PostQuitMessage(0);
	}


	// DirectInput̏I
	ReleaseDInput();

	// AvP[V̏I
	EndApp();

	return (int)msg.wParam;
}
