/*----------------------------------------------------------
	DirectInputTv
		EMicrosoft DirectX SDK (February 2007)
		EVisual Studio 2005 Standard
		EWindows XP or Windows Vista
		Ή

	DISample04.cpp
		utH[XtB[hobNEWCXeBbŃv
--------------------------------------------------------------*/

#define STRICT
#define DIRECTINPUT_VERSION 0x0800

#include <windows.h>
#include <crtdbg.h>

#pragma warning( disable : 4996 ) // xꎞIɖɂ 
#include <strsafe.h>
#pragma warning( default : 4996 ) 

#include <dinput.h>
#include <dxerr.h>

#include "resource.h"

#define SAFE_RELEASE(x)	{if(x){(x)->Release();x=NULL;}}

// KvȃCuN
#pragma comment( lib, "dinput8.lib" )
#pragma comment( lib, "dxerr.lib" )
#pragma comment( lib, "dxguid.lib" )

/*-------------------------------------------
	Oϐ
--------------------------------------------*/
// AvP[V
HINSTANCE hInstApp;								// CX^XEnh
HWND hwndApp;									// EChEEnh
WCHAR szAppName[] = L"DirectInput Sample 4";		// AvP[V
bool g_bActive = true;							// EChẼANeBu

// DirectInput̕ϐ
LPDIRECTINPUT8 g_pDInput = NULL;					// DirectInput
LPDIRECTINPUTDEVICE8 g_pDIDevice = NULL;			// DirectInputfoCX
LPDIRECTINPUTEFFECT g_pDIEffect = NULL;				// GtFNg
DIDEVCAPS g_diDevCaps;								// WCXeBbN̔\
#define DIDEVICE_BUFFERSIZE	100						// foCXɐݒ肷obt@ETCY

// bZ[W֐̒`
LRESULT CALLBACK MainWndProc(HWND hWnd,UINT msg,UINT wParam,LONG lParam);

/*-------------------------------------------
	AvP[V
--------------------------------------------*/
bool InitApp(HINSTANCE hInst,int nCmdShow)
{
	hInstApp=hInst;

	// EChEENX̓o^
	WNDCLASS wndclass;
	wndclass.hCursor		= LoadCursor(NULL,IDC_ARROW);
	wndclass.hIcon			= LoadIcon(hInst, (LPCTSTR)IDI_ICON1);
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= szAppName;
	wndclass.hbrBackground	= (HBRUSH)(COLOR_WINDOW + 1);
	wndclass.hInstance		= hInst;
	wndclass.style			= CS_BYTEALIGNCLIENT|CS_VREDRAW|CS_HREDRAW;
	wndclass.lpfnWndProc	= (WNDPROC)MainWndProc;
	wndclass.cbClsExtra		= 0;
	wndclass.cbWndExtra		= 0;

	if(!RegisterClass(&wndclass))
		return false;

	// CEEChE
	hwndApp = CreateWindowEx(0,szAppName,szAppName,
							WS_OVERLAPPEDWINDOW,
							CW_USEDEFAULT,CW_USEDEFAULT,640,480,
							(HWND)NULL,(HMENU)NULL,
							hInst,(LPSTR)NULL);
	ShowWindow(hwndApp,nCmdShow);
	UpdateWindow(hwndApp);

	return true;
}

/*-------------------------------------------
	DirectInput 
---------------------------------------------*/
BOOL CALLBACK EnumJoysticksCallback(const DIDEVICEINSTANCE* pdidInstance, VOID* pContext);
BOOL CALLBACK EnumAxesCallback(LPCDIDEVICEOBJECTINSTANCE lpddoi, LPVOID pvRef);

bool InitDInput(void)
{
	HRESULT hr;

	// *****************************************
	// DirectInput̍쐬
	hr = DirectInput8Create(hInstApp, DIRECTINPUT_VERSION, 
							IID_IDirectInput8, (void**)&g_pDInput, NULL); 
	if (FAILED(hr)) 
	{
		DXTRACE_ERR(L"DirectInput8IuWFNg̍쐬Ɏs", hr);
		return false;
	}

	// foCX񋓂č쐬
	hr = g_pDInput->EnumDevices(DI8DEVCLASS_GAMECTRL, EnumJoysticksCallback,
							NULL, DIEDFL_FORCEFEEDBACK | DIEDFL_ATTACHEDONLY);
	if (FAILED(hr) || g_pDIDevice==NULL)
	{
		DXTRACE_ERR(L"DirectInputDevice8IuWFNg̍쐬ɎsBtH[XtB[hobÑWCXeBbNtȂ", hr);
		return false;
	}
 
	// f[^`ݒ
	hr = g_pDIDevice->SetDataFormat(&c_dfDIJoystick2);
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"c_dfDIJoystick2`̐ݒɎs", hr);
		return false;
	}

	//[hݒitHAOEhr[hj
	hr = g_pDIDevice->SetCooperativeLevel(hwndApp, DISCL_EXCLUSIVE | DISCL_FOREGROUND);
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"tHAOEhr[h̐ݒɎs", hr);
		return false;
	}

	// Z^O𖳌ɂ
	DIPROPDWORD DIPropAutoCenter;
	DIPropAutoCenter.diph.dwSize       = sizeof(DIPropAutoCenter);
	DIPropAutoCenter.diph.dwHeaderSize = sizeof(DIPROPHEADER);
	DIPropAutoCenter.diph.dwObj        = 0;
	DIPropAutoCenter.diph.dwHow        = DIPH_DEVICE;
	DIPropAutoCenter.dwData            = DIPROPAUTOCENTER_OFF;

	hr = g_pDIDevice->SetProperty(DIPROP_AUTOCENTER, &DIPropAutoCenter.diph);
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"Z^O̐ݒɎs", hr);
		return false;
	}

	// R[obN֐gĊẽ[hݒ
	hr = g_pDIDevice->EnumObjects(EnumAxesCallback, NULL, DIDFT_AXIS);
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"[h̐ݒɎs", hr);
		return false;
	}

	// [hݒiΒl[hɐݒBftHgȂ̂ŕKݒ͕KvȂj
	DIPROPDWORD diprop;
	diprop.diph.dwSize	= sizeof(diprop); 
	diprop.diph.dwHeaderSize	= sizeof(diprop.diph); 
	diprop.diph.dwObj	= 0;
	diprop.diph.dwHow	= DIPH_DEVICE;
	diprop.dwData		= DIPROPAXISMODE_ABS;
//	diprop.dwData		= DIPROPAXISMODE_REL;	// Βl[h̏ꍇ
	hr = g_pDIDevice->SetProperty(DIPROP_AXISMODE, &diprop.diph);
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"[h̐ݒɎs", hr);
		return false;
	}

	// obt@OEf[^擾邽߁Aobt@ETCYݒ
	diprop.dwData = DIDEVICE_BUFFERSIZE;
	hr = g_pDIDevice->SetProperty(DIPROP_BUFFERSIZE, &diprop.diph);
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"obt@ETCY̐ݒɎs", hr);
		return false;
	}

	// ͐Jn
	hr = g_pDIDevice->Acquire();
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"AcquireɎs", hr);
		return false;
	}

	// {^OƎsGtFNgEIuWFNg쐬
    DWORD           rgdwAxes[2]     = { DIJOFS_X, DIJOFS_Y };
    LONG            rglDirection[2] = { 0, 0 };

	DICONSTANTFORCE cf              = { 0 };
	cf.lMagnitude = 10000;

	DIEFFECT eff;
    ZeroMemory( &eff, sizeof(eff) );
    eff.dwSize                  = sizeof(DIEFFECT);
    eff.dwFlags                 = DIEFF_CARTESIAN | DIEFF_OBJECTOFFSETS;	// fJgW
    eff.dwDuration              = DI_SECONDS;								// 1̎Ԃ1b
    eff.dwSamplePeriod          = 0;
    eff.dwGain                  = DI_FFNOMINALMAX;							// QCő
    eff.dwTriggerButton         = DIEB_NOTRIGGER;							// gK[Ȃ
    eff.dwTriggerRepeatInterval = 0;
    eff.cAxes                   = 2;										// 2
    eff.rgdwAxes                = rgdwAxes;
    eff.rglDirection            = rglDirection;
    eff.lpEnvelope              = NULL;
    eff.cbTypeSpecificParams    = sizeof(DICONSTANTFORCE);
    eff.lpvTypeSpecificParams   = &cf;
    eff.dwStartDelay            = 0;

	hr = g_pDIDevice->CreateEffect(
						GUID_ConstantForce,
						&eff,		// GtFNgɂĐݒ肵\
						&g_pDIEffect,	// GtFNgEIuWFNg󂯎|C^̃|C^
						NULL);		// ŴȂ
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"GtFNg𐶐ł܂", hr);
		return false;
	}

	return true;
}

// WCXeBbN񋓂֐
BOOL CALLBACK EnumJoysticksCallback(const DIDEVICEINSTANCE* pdidInstance, VOID* pContext)
{
	HRESULT hr;

	// 񋓂ꂽWCXeBbNւ̃C^[tFCX擾B
	hr = g_pDInput->CreateDevice(pdidInstance->guidInstance, &g_pDIDevice, NULL);
	if (FAILED(hr)) 
		return DIENUM_CONTINUE;

	// WCXeBbN̔\͂𒲂ׂ
	g_diDevCaps.dwSize = sizeof(DIDEVCAPS);
	hr = g_pDIDevice->GetCapabilities(&g_diDevCaps);
	if (FAILED(hr))
	{
		// WCXeBbN\͂̎擾Ɏs
		SAFE_RELEASE(g_pDIDevice);
		return DIENUM_CONTINUE;
	}

	return DIENUM_STOP; // 1t񋓂~߂
}

// WCXeBbN̎񋓂֐
BOOL CALLBACK EnumAxesCallback(LPCDIDEVICEOBJECTINSTANCE lpddoi, LPVOID pvRef)
{
	HRESULT hr;

	// ̒l͈̔͂ݒi-1000`1000j
	DIPROPRANGE diprg;
	ZeroMemory(&diprg, sizeof(diprg));
	diprg.diph.dwSize	= sizeof(diprg); 
	diprg.diph.dwHeaderSize	= sizeof(diprg.diph); 
	diprg.diph.dwObj	= lpddoi->dwType;
	diprg.diph.dwHow	= DIPH_BYID;
	diprg.lMin	= -1000;
	diprg.lMax	= +1000;
	hr = g_pDIDevice->SetProperty(DIPROP_RANGE, &diprg.diph);
	if (FAILED(hr))
		return DIENUM_STOP;

	return DIENUM_CONTINUE;
}

/*-------------------------------------------
	DirectInput̉
--------------------------------------------*/
bool ReleaseDInput(void)
{
	// GtFNgfoCXA[h
	if(g_pDIEffect)
		g_pDIEffect->Unload();

	// DirectInput̃foCX
	SAFE_RELEASE(g_pDIEffect);
	if (g_pDIDevice)
		g_pDIDevice->Unacquire(); 
	SAFE_RELEASE(g_pDIDevice);
	SAFE_RELEASE(g_pDInput);

	return true;
}

/*-------------------------------------------
	Ȉ
--------------------------------------------*/
bool EndApp(void)
{
	return true;
}

/*-------------------------------------------
	L[͏
--------------------------------------------*/
void WM_KeyDown(HWND hWnd, UINT wParam)
{
	switch(wParam){
		// EChE
		case VK_ESCAPE:
			DestroyWindow(hWnd);
			return;
	}
}

/*-------------------------------------------
	^C}[
--------------------------------------------*/
void WM_Timer(HWND hWnd, WPARAM wParam)
{
	// ʍXV
	InvalidateRect(hWnd, NULL, TRUE);
}

/*-------------------------------------------
	EChE̕`揈
--------------------------------------------*/
void WM_Paint(HWND hWnd)
{
	PAINTSTRUCT ps;
	HDC hDC = BeginPaint(hWnd, &ps);

	if (g_pDIDevice!=NULL)
	{
		HRESULT hr;
		WCHAR CData[1024];
		int y = 0;

		// foCX̒ڃf[^擾
		hr = g_pDIDevice->Poll();
		if (FAILED(hr))
		{
			hr = g_pDIDevice->Acquire();
			while (g_bActive && hr==DIERR_INPUTLOST)
				hr = g_pDIDevice->Acquire();
		}

		DIJOYSTATE2 dijs;
		hr = g_pDIDevice->GetDeviceState(sizeof(DIJOYSTATE2), &dijs);
		if (SUCCEEDED(hr))
		{
			// \
			hr = StringCbPrintf(CData, sizeof(CData),
					L"[X=%d Y=%d Z=%d][Rx=%d Ry=%d Rz=%d][Slider1=%d Slider2=%d]",
					dijs.lX,dijs.lY,dijs.lZ,
					dijs.lRx,dijs.lRy,dijs.lRz,
					dijs.rglSlider[0],dijs.rglSlider[1]);
			if (SUCCEEDED(hr))
				TextOut(hDC, 0, y, CData, lstrlen(CData));
			y += 20;

			// {^\
			WCHAR buf[16];
			hr = StringCbCopy(CData, sizeof(CData), L"");
			for(int i=0; i<9 && SUCCEEDED(hr); i++)
			{
				if(dijs.rgbButtons[i] & 0x80)
					hr = StringCbPrintf(buf, sizeof(buf), L"[%d]",i);
				else
					hr = StringCbCopy(buf, sizeof(buf), L"[-]");
				if (SUCCEEDED(hr))
					hr = StringCbCat(CData, sizeof(CData), buf);
			}

			if (SUCCEEDED(hr))
				TextOut(hDC, 0, y, CData, lstrlen(CData));
			y += 20;
		}
		else if (g_bActive && hr==DIERR_INPUTLOST)
			g_pDIDevice->Acquire();
		y += 40;

		// obt@OEf[^擾
		while(g_bActive)
		{
			DIDEVICEOBJECTDATA od;
			DWORD dwItems = 1;
			hr = g_pDIDevice->GetDeviceData(sizeof(DIDEVICEOBJECTDATA),
								&od, &dwItems, 0);
			if (hr==DIERR_INPUTLOST)
				g_pDIDevice->Acquire();
			else if (FAILED(hr) || dwItems == 0)
	            break;	// f[^ǂ߂ȂA݂Ȃ
			else
			{
				switch (od.dwOfs) 
				{
				case DIJOFS_X:
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIJOFS_X = %d", od.dwSequence, od.dwData); break;
				case DIJOFS_Y:
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIJOFS_Y = %d", od.dwSequence, od.dwData); break;
				case DIJOFS_Z:
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIJOFS_Z = %d", od.dwSequence, od.dwData); break;
				case DIJOFS_RX:
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIJOFS_Rx = %d", od.dwSequence, od.dwData); break;
				case DIJOFS_RY:
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIJOFS_Ry = %d", od.dwSequence, od.dwData); break;
				case DIJOFS_RZ:
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIJOFS_Rz = %d", od.dwSequence, od.dwData); break;
				case DIJOFS_BUTTON0:
					if (od.dwData != 0)
					{
						g_pDIEffect->Unload();
						g_pDIEffect->Start(1, 0);
					}
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIJOFS_BUTTON0 = %d", od.dwSequence, od.dwData); break;
				case DIJOFS_BUTTON1:
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIJOFS_BUTTON1 = %d", od.dwSequence, od.dwData); break;
				case DIJOFS_BUTTON2:
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIJOFS_BUTTON2 = %d", od.dwSequence, od.dwData); break;
				case DIJOFS_BUTTON3:
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIJOFS_BUTTON3 = %d", od.dwSequence, od.dwData); break;
				case DIJOFS_BUTTON4:
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIJOFS_BUTTON4 = %d", od.dwSequence, od.dwData); break;
				case DIJOFS_BUTTON5:
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIJOFS_BUTTON5 = %d", od.dwSequence, od.dwData); break;
				case DIJOFS_BUTTON6:
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIJOFS_BUTTON6 = %d", od.dwSequence, od.dwData); break;
				case DIJOFS_BUTTON7:
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIJOFS_BUTTON7 = %d", od.dwSequence, od.dwData); break;
				case DIJOFS_BUTTON8:
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIJOFS_BUTTON8 = %d", od.dwSequence, od.dwData); break;
				case DIJOFS_SLIDER(0):
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIJOFS_SLIDER(0) = %d", od.dwSequence, od.dwData); break;
				case DIJOFS_SLIDER(1):
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] DIJOFS_SLIDER(1) = %d", od.dwSequence, od.dwData); break;
				default: 
					hr = StringCbPrintf(CData, sizeof(CData), L"[%lu] %ld = %d", od.dwSequence, od.dwOfs, od.dwData); break;
				}
				if (SUCCEEDED(hr))
					TextOut(hDC, 0, y, CData, lstrlen(CData));
				y += 20;
			}
		}
	}

	EndPaint(hWnd, &ps);
}

/*-------------------------------------------
	EChE
--------------------------------------------*/
LRESULT CALLBACK MainWndProc(HWND hWnd,UINT msg,UINT wParam,LONG lParam)
{
	switch(msg)
	{
		case WM_ACTIVATE:		// EChẼANeBuԂω
			if(g_pDIDevice == NULL)
				break;
			g_bActive = wParam != WA_INACTIVE;
			if(wParam != WA_INACTIVE)
				g_pDIDevice->Acquire();
			break;
		case WM_LBUTTONDOWN:  // }EXꂽ
			if (g_pDIEffect)
				g_pDIEffect->Start(1, 0);
			break;
		case WM_KEYDOWN:	// L[ꂽ
			WM_KeyDown(hWnd, wParam);
			break;
		case WM_CREATE:		// EChEꂽ
			SetTimer(hWnd, 1, 100, NULL);
			break;
		case WM_DESTROY:	// EChEj
			KillTimer(hWnd, 1);
			PostQuitMessage(0);
			break;
		case WM_TIMER:		// ^C}[ECxg
			WM_Timer(hWnd, wParam);
			break;
		case WM_PAINT:		// ʕ`
			WM_Paint(hWnd);
			break;
		default:			// ̑̃bZ[W
			return DefWindowProc(hWnd,msg,wParam,lParam);
	}
	return 0L;
}

/*--------------------------------------------
	bZ[WȂƂ̏
---------------------------------------------*/
bool AppIdle()
{
	return true;	// falseԂƃbZ[W܂őҋ@
}

/*--------------------------------------------
	C
---------------------------------------------*/
int WINAPI wWinMain(HINSTANCE hInst,HINSTANCE /*hPrevInst*/,LPWSTR /*lpCmdLine*/,int nCmdShow)
{
	// fobO q[v }l[Wɂ郁蓖Ă̒ǐՕ@ݒ
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );

	bool flag = false;
	// AvP[VɊւ鏉
	if (InitApp(hInst,nCmdShow))
	{
		// DirectInputɊւ鏉
		flag = InitDInput();
	}

	// bZ[WE[v
	MSG msg;
	msg.wParam = -1;
	while (flag)
	{
		while(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{
			if (msg.message == WM_QUIT)
			{
				flag = false;
				break;
			}
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		if (AppIdle()==false)
			PostQuitMessage(0);
	}

	// DirectInput̏I
	ReleaseDInput();

	// AvP[V̏I
	EndApp();

	return (int)msg.wParam;
}
