/*----------------------------------------------------------
	DirectInputTv
		EMicrosoft DirectX SDK (February 2007)
		EVisual Studio 2005 Standard
		EWindows XP or Windows Vista
		Ή

	DISample05.cpp
		uANVE}bvǵv
--------------------------------------------------------------*/

#define STRICT
#define DIRECTINPUT_VERSION 0x0800

#include <windows.h>
#include <crtdbg.h>

#pragma warning( disable : 4996 ) // xꎞIɖɂ 
#include <strsafe.h>
#pragma warning( default : 4996 ) 

#include <dinput.h>
#include <dxerr.h>

#include "resource.h"

#define SAFE_RELEASE(x)	{if(x){(x)->Release();x=NULL;}}

// KvȃCuN
#pragma comment( lib, "dinput8.lib" )
#pragma comment( lib, "dxerr.lib" )
#pragma comment( lib, "dxguid.lib" )

/*-------------------------------------------
	Oϐ
--------------------------------------------*/
// AvP[V
HINSTANCE hInstApp;								// CX^XEnh
HWND hwndApp;									// EChEEnh
WCHAR szAppName[] = L"DirectInput Sample 5";		// AvP[V
bool g_bActive = true;							// EChẼANeBu

// {94EFDC1C-8CC7-4423-A6C2-529199930259}
GUID g_AppGuid = { 0x94efdc1c, 0x8cc7, 0x4423, { 0xa6, 0xc2, 0x52, 0x91, 0x99, 0x93, 0x2, 0x59 } };

// DirectInput̕ϐ
#define MAX_DEV	16
LPDIRECTINPUT8 g_pDInput = NULL;					// DirectInput
LPDIRECTINPUTDEVICE8 g_pDIDevice[MAX_DEV];			// DirectInputfoCX
int g_iDIDeviceNum = 0;								// DirectInputfoCX̐
#define DIDEVICE_BUFFERSIZE	100						// foCXɐݒ肷obt@ETCY

// ̃TvɂQ[EANV̒`
#define INPUT_LEFTRIGHT_AXIS	1L
#define INPUT_UPDOWN_AXIS		2L
#define INPUT_TURNLEFT			3L
#define INPUT_TURNRIGHT			4L
#define INPUT_FORWARDTHRUST		5L
#define INPUT_REVERSETHRUST		6L
#define INPUT_FIREWEAPONS		7L
#define INPUT_ENABLESHIELD		8L
#define INPUT_DISPLAYGAMEMENU	9L
#define INPUT_QUITGAME			10L

// Q[EANVANVE}bsO萔Ɋ蓖Ă
DIACTION g_GameAction[] =
{
	// tCgQ[EW̉FTuEWւ̃}bsO
	{INPUT_LEFTRIGHT_AXIS, DIAXIS_SPACESIM_LATERAL,  0, L"Turn",},
	{INPUT_UPDOWN_AXIS,    DIAXIS_SPACESIM_MOVE,     0, L"Move",},
	{INPUT_FIREWEAPONS,    DIBUTTON_SPACESIM_FIRE,   0, L"Shoot",},
	{INPUT_ENABLESHIELD,   DIBUTTON_SPACESIM_GEAR,   0, L"Shield",},
	{INPUT_DISPLAYGAMEMENU,DIBUTTON_SPACESIM_DISPLAY,0, L"Display",},
	{INPUT_QUITGAME,       DIBUTTON_SPACESIM_MENU,   0, L"Quit Game",},

	// L[{[h͂ւ̃}bsOB
	{INPUT_TURNLEFT,       DIKEYBOARD_LEFT, 0, L"Turn left", },
	{INPUT_TURNRIGHT,      DIKEYBOARD_RIGHT,0, L"Turn right", },
	{INPUT_FORWARDTHRUST,  DIKEYBOARD_UP,   0, L"Forward thrust", },
	{INPUT_REVERSETHRUST,  DIKEYBOARD_DOWN, 0, L"Reverse thrust", },
	{INPUT_FIREWEAPONS,    DIKEYBOARD_F,    0, L"Fire weapons", },
	{INPUT_ENABLESHIELD,   DIKEYBOARD_S,    0, L"Enable shields", },
	{INPUT_DISPLAYGAMEMENU,DIKEYBOARD_D,      DIA_APPFIXED, L"Display game menu", },
	{INPUT_QUITGAME,       DIKEYBOARD_ESCAPE, DIA_APPFIXED, L"Quit game", },

	// }EX͂ւ̃}bsOB
	{INPUT_LEFTRIGHT_AXIS, DIMOUSE_XAXIS,   0, L"Turn", },
	{INPUT_UPDOWN_AXIS,    DIMOUSE_YAXIS,   0, L"Move", },
	{INPUT_FIREWEAPONS,    DIMOUSE_BUTTON0, 0, L"Fire weapons", },
	{INPUT_ENABLESHIELD,   DIMOUSE_BUTTON1, 0, L"Enable shields", },
};

// ANVE}bv̒`
DIACTIONFORMAT g_DIActionFormat;

// bZ[W֐̒`
LRESULT CALLBACK MainWndProc(HWND hWnd,UINT msg,UINT wParam,LONG lParam);

/*-------------------------------------------
	AvP[V
--------------------------------------------*/
bool InitApp(HINSTANCE hInst,int nCmdShow)
{
	hInstApp=hInst;

	// EChEENX̓o^
	WNDCLASS wndclass;
	wndclass.hCursor		= LoadCursor(NULL,IDC_ARROW);
	wndclass.hIcon			= LoadIcon(hInst, (LPCTSTR)IDI_ICON1);
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= szAppName;
	wndclass.hbrBackground	= (HBRUSH)(COLOR_WINDOW + 1);
	wndclass.hInstance		= hInst;
	wndclass.style			= CS_BYTEALIGNCLIENT|CS_VREDRAW|CS_HREDRAW;
	wndclass.lpfnWndProc	= (WNDPROC)MainWndProc;
	wndclass.cbClsExtra		= 0;
	wndclass.cbWndExtra		= 0;

	if(!RegisterClass(&wndclass))
		return false;

	// CEEChE
	hwndApp = CreateWindowEx(0,szAppName,szAppName,
							WS_OVERLAPPEDWINDOW,
							CW_USEDEFAULT,CW_USEDEFAULT,640,480,
							(HWND)NULL,(HMENU)NULL,
							hInst,(LPSTR)NULL);
	ShowWindow(hwndApp,nCmdShow);
	UpdateWindow(hwndApp);

	return true;
}

/*-------------------------------------------
	DirectInput 
---------------------------------------------*/
BOOL CALLBACK EnumDevicesBySemanticsCallback(
		LPCDIDEVICEINSTANCE lpddi, LPDIRECTINPUTDEVICE8  lpdid, 
		DWORD  dwFlags, DWORD  dwRemaining, LPVOID pvRef);

bool InitDInput(void)
{
	HRESULT hr;

	// *****************************************
	// DirectInput̍쐬
	hr = DirectInput8Create(hInstApp, DIRECTINPUT_VERSION, 
							IID_IDirectInput8, (void**)&g_pDInput, NULL); 
	if (FAILED(hr)) 
	{
		DXTRACE_ERR(L"DirectInput8IuWFNg̍쐬Ɏs", hr);
		return false;
	}

	// *****************************************
	// ANVE}bv̒`
	int numder_of_actions = sizeof(g_GameAction) / sizeof(g_GameAction[0]);
	g_DIActionFormat.dwSize        = sizeof(DIACTIONFORMAT);
	g_DIActionFormat.dwActionSize  = sizeof(DIACTION);
	g_DIActionFormat.dwDataSize    = numder_of_actions * sizeof(DWORD);
	g_DIActionFormat.dwNumActions  = numder_of_actions;
	g_DIActionFormat.guidActionMap = g_AppGuid;
	g_DIActionFormat.dwGenre       = DIVIRTUAL_SPACESIM;
	g_DIActionFormat.rgoAction     = g_GameAction;
	g_DIActionFormat.dwBufferSize  = 100;
	g_DIActionFormat.lAxisMin      = -1000;
	g_DIActionFormat.lAxisMax      = 1000;
	StringCbCopy(g_DIActionFormat.tszActionMap, sizeof(g_DIActionFormat.tszActionMap), szAppName);

	// foCXւ̃ANṼ}bsO
	hr = g_pDInput->EnumDevicesBySemantics(NULL, &g_DIActionFormat,
				EnumDevicesBySemanticsCallback, NULL, DIEDBSFL_ATTACHEDONLY);
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"foCXւ̃ANṼ}bsOɎs", hr);
		return false;
	}

	//***********************************************************
	// ConfigureDevices\bh́AVistaȍ~OSł͕Ks
	//***********************************************************
	// foCX̃[U[\\(ҏW\)
//	DICONFIGUREDEVICESPARAMS diCDParam;
//	ZeroMemory(&diCDParam, sizeof(DICONFIGUREDEVICESPARAMS));
//	diCDParam.dwSize = sizeof(DICONFIGUREDEVICESPARAMS);
//	diCDParam.dwcFormats = 1;
//	diCDParam.lprgFormats = &g_DIActionFormat;
//	diCDParam.hwnd = hwndApp;
//	hr = g_pDInput->ConfigureDevices(NULL, &diCDParam, DICD_EDIT, NULL);
//	if (FAILED(hr))
//	{
//		DXTRACE_ERR(L"ConfigureDevicess", hr);
//		return false;
//	}

	return true;
}

BOOL CALLBACK EnumDevicesBySemanticsCallback(
		LPCDIDEVICEINSTANCE lpddi, LPDIRECTINPUTDEVICE8  lpdid, 
		DWORD  dwFlags, DWORD  dwRemaining, LPVOID pvRef)
{
	HRESULT hr;

	// ftHgEANV}bv̎擾
	hr = lpdid->BuildActionMap(&g_DIActionFormat, NULL, DIDBAM_DEFAULT);
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"BuildActionMapɎs", hr);
		return DIENUM_CONTINUE;
	}

	// ANVE}bv̓Kp
	hr = lpdid->SetActionMap(&g_DIActionFormat, NULL, DIDSAM_DEFAULT);
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"SetActionMapɎs", hr);
		return DIENUM_CONTINUE;
	}

	// ̃IuWFNgۑ
	lpdid->AddRef();
	g_pDIDevice[g_iDIDeviceNum++] = lpdid;

	if (MAX_DEV <= g_iDIDeviceNum)
		DIENUM_STOP;

	return DIENUM_CONTINUE;
}

/*-------------------------------------------
	DirectInput̉
--------------------------------------------*/
bool ReleaseDInput(void)
{
	// DirectInput̃foCX
	for (int i=0; i < g_iDIDeviceNum; i++)
	{
		if (g_pDIDevice[i])
			g_pDIDevice[i]->Unacquire();
		SAFE_RELEASE(g_pDIDevice[i]);
	}
	SAFE_RELEASE(g_pDInput);

	return true;
}

/*-------------------------------------------
	Ȉ
--------------------------------------------*/
bool EndApp(void)
{
	return true;
}

/*-------------------------------------------
	L[͏
--------------------------------------------*/
void WM_KeyDown(HWND hWnd, UINT wParam)
{
	switch(wParam){
		// EChE
		case VK_ESCAPE:
			DestroyWindow(hWnd);
			return;
	}
}

/*-------------------------------------------
	^C}[
--------------------------------------------*/
void WM_Timer(HWND hWnd, WPARAM wParam)
{
	// ʍXV
	InvalidateRect(hWnd, NULL, TRUE);
}

/*-------------------------------------------
	EChE̕`揈
--------------------------------------------*/
void WM_Paint(HWND hWnd)
{
	HRESULT hr;
	PAINTSTRUCT ps;
	HDC hDC = BeginPaint(hWnd, &ps);

	if (g_bActive)
	{
		WCHAR CData[1024];
		int y = 0;

		for (int i = 0; i < g_iDIDeviceNum; i++)
		{
			DIDEVICEOBJECTDATA od;
			DWORD dwItems = 1;
 
			// f[^̗LfoCXɃ|[OB 
			hr = g_pDIDevice[i]->Poll(); 
			if (FAILED(hr))
			{
				hr = g_pDIDevice[i]->Acquire();
				while (hr==DIERR_INPUTLOST)
					hr = g_pDIDevice[i]->Acquire();
			}

			// f[^擾B
			while (true)
			{
				hr = g_pDIDevice[i]->GetDeviceData(sizeof(DIDEVICEOBJECTDATA), &od, &dwItems, 0);
				if (hr==DIERR_INPUTLOST)
					g_pDIDevice[i]->Acquire();
				else if (FAILED(hr) || dwItems == 0)
		            break;	// f[^ǂ߂ȂA݂Ȃ
				else
				{
					// ANVBǂ̃foCXԂꂽ͖ȂB
					switch(od.uAppData)
					{
					case INPUT_LEFTRIGHT_AXIS:
						hr = StringCbPrintf(CData, sizeof(CData), L"[%d][%lu] INPUT_LEFTRIGHT_AXIS = %d", i, od.dwSequence, od.dwData); break;
					case INPUT_UPDOWN_AXIS:
						hr = StringCbPrintf(CData, sizeof(CData), L"[%d][%lu] INPUT_UPDOWN_AXIS = %d", i, od.dwSequence, od.dwData); break;
					case INPUT_TURNLEFT:
						hr = StringCbPrintf(CData, sizeof(CData), L"[%d][%lu] INPUT_TURNLEFT = %d", i, od.dwSequence, od.dwData); break;
					case INPUT_TURNRIGHT:
						hr = StringCbPrintf(CData, sizeof(CData), L"[%d][%lu] INPUT_TURNRIGHT = %d", i, od.dwSequence, od.dwData); break;
					case INPUT_FORWARDTHRUST:
						hr = StringCbPrintf(CData, sizeof(CData), L"[%d][%lu] INPUT_FORWARDTHRUST = %d", i, od.dwSequence, od.dwData); break;
					case INPUT_REVERSETHRUST:
						hr = StringCbPrintf(CData, sizeof(CData), L"[%d][%lu] INPUT_REVERSETHRUST = %d", i, od.dwSequence, od.dwData); break;
					case INPUT_FIREWEAPONS:
						hr = StringCbPrintf(CData, sizeof(CData), L"[%d][%lu] INPUT_FIREWEAPONS = %d", i, od.dwSequence, od.dwData); break;
					case INPUT_ENABLESHIELD:
						hr = StringCbPrintf(CData, sizeof(CData), L"[%d][%lu] INPUT_ENABLESHIELD = %d", i, od.dwSequence, od.dwData); break;
					case INPUT_DISPLAYGAMEMENU:
						hr = StringCbPrintf(CData, sizeof(CData), L"[%d][%lu] INPUT_DISPLAYGAMEMENU = %d", i, od.dwSequence, od.dwData); break;
					case INPUT_QUITGAME:
						hr = StringCbPrintf(CData, sizeof(CData), L"[%d][%lu] INPUT_QUITGAME = %d", i, od.dwSequence, od.dwData); break;
					default:
						hr = StringCbPrintf(CData, sizeof(CData), L"[%d][%lu] %lu = %d", i, od.dwSequence, od.uAppData, od.dwData); break;
					}
					if (SUCCEEDED(hr))
						TextOut(hDC, 0, y, CData, lstrlen(CData));
					y += 20;
				}
			}
		}
	}

	EndPaint(hWnd, &ps);
}

/*-------------------------------------------
	EChE
--------------------------------------------*/
LRESULT CALLBACK MainWndProc(HWND hWnd,UINT msg,UINT wParam,LONG lParam)
{
	switch(msg)
	{
		case WM_ACTIVATE:		// EChẼANeBuԂω
		{
			if(g_pDIDevice == NULL)
				break;
			g_bActive = wParam != WA_INACTIVE;
			if(wParam != WA_INACTIVE)
				for (int i=0; i<g_iDIDeviceNum; i++)
					g_pDIDevice[i]->Acquire();
			break;
		}
		case WM_KEYDOWN:	// L[ꂽ
			WM_KeyDown(hWnd, wParam);
			break;
		case WM_CREATE:		// EChEꂽ
			SetTimer(hWnd, 1, 100, NULL);
			break;
		case WM_DESTROY:	// EChEj
			KillTimer(hWnd, 1);
			PostQuitMessage(0);
			break;
		case WM_TIMER:		// ^C}[ECxg
			WM_Timer(hWnd, wParam);
			break;
		case WM_PAINT:		// ʕ`
			WM_Paint(hWnd);
			break;
		default:			// ̑̃bZ[W
			return DefWindowProc(hWnd,msg,wParam,lParam);
	}
	return 0L;
}

/*--------------------------------------------
	bZ[WȂƂ̏
---------------------------------------------*/
bool AppIdle()
{
	return true;	// falseԂƃbZ[W܂őҋ@
}

/*--------------------------------------------
	C
---------------------------------------------*/
int WINAPI wWinMain(HINSTANCE hInst,HINSTANCE /*hPrevInst*/,LPWSTR /*lpCmdLine*/,int nCmdShow)
{
	// fobO q[v }l[Wɂ郁蓖Ă̒ǐՕ@ݒ
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );

	bool flag = false;
	// AvP[VɊւ鏉
	if (InitApp(hInst,nCmdShow))
	{
		// DirectInputɊւ鏉
		flag = InitDInput();
	}

	// bZ[WE[v
	MSG msg;
	msg.wParam = -1;
	while (flag)
	{
		while(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{
			if (msg.message == WM_QUIT)
			{
				flag = false;
				break;
			}
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		if (AppIdle()==false)
			PostQuitMessage(0);
	}

	// DirectInput̏I
	ReleaseDInput();

	// AvP[V̏I
	EndApp();

	return (int)msg.wParam;
}
