/*----------------------------------------------------------
	DirectSoundTv
		EMicrosoft DirectX SDK (February 2007)
		EVisual Studio 2005 Standard
		EWindows XP or Windows Vista
		Ή

	DSSample02.cpp
		uXg[~OEobt@ɂĐv
--------------------------------------------------------------*/

// DirectSoundpt@CCN[h
#define STRICT
#include <windows.h>
#include <crtdbg.h>
#include <mmsystem.h>
#include <mmreg.h>
#include <dsound.h>
#include <dxerr.h>

#pragma warning( disable : 4996 ) // disable deprecated warning 
#include <strsafe.h>
#pragma warning( default : 4996 ) 

#define SAFE_RELEASE(p)      { if(p) { (p)->Release(); (p)=NULL; } }

// DirectSoundpCũN
#pragma comment( lib, "dsound.lib" )
#pragma comment( lib, "dxerr.lib" )
#pragma comment( lib, "winmm.lib" )

// DXUT OptionalCWaveFileNXgp
#define DXUT_AUTOLIB    // Direct3DpCũNw
#include "DXUT.h"
#include "SDKwavefile.h"

// DXUT̃CuN
#if defined(DEBUG) || defined(_DEBUG)
#pragma comment( lib, "..\\Debug\\DXUT.lib" )
#pragma comment( lib, "..\\Debug\\DXUTOpt.lib" )
#else
#pragma comment( lib, "..\\Release\\DXUT.lib" )
#pragma comment( lib, "..\\Release\\DXUTOpt.lib" )
#endif

// \[X
#include "resource.h"

/*-------------------------------------------
	Oϐ
--------------------------------------------*/
HINSTANCE hInstApp = NULL;
HWND hwndApp = NULL;

WCHAR szAppName[] = L"DirectSound Sample 2";

LPDIRECTSOUND8 pDSound = NULL;
LPDIRECTSOUNDBUFFER8 pDSData = NULL;
LPDIRECTSOUNDNOTIFY8 pDSNotify = NULL;

bool bWaveOK = false;		// WAVEt@C̏OK
CWaveFile WaveFile;			// ĐWAVEt@C

HANDLE hEvent[2] = { NULL, NULL };	// CxgEnh
HANDLE hThreadHandle = NULL;	// XbhEnh
DWORD dwThreadID = 0;			// XbhID
DWORD dwBlockSize = 0;			// xɍXVubÑTCY
DWORD dwBufferSize = 0;			// Xg[~OEobt@̃TCY(dwBlockSize̐{Ƃ)
DWORD dwNextOffset = 0;			// ɏރubÑItZbg

LRESULT CALLBACK MainWndProc(HWND hWnd,UINT msg,UINT wParam,LONG lParam);

/*-------------------------------------------
	AvP[V
--------------------------------------------*/
bool InitApp(HINSTANCE hInst,int nCmdShow)
{
	hInstApp=hInst;

	// ĐWAVEt@CI
	WCHAR strFilter[] = L"Wave File(*.wav)\0*.wav\0";
	WCHAR waveFileName[260] = L"";
	OPENFILENAME ofn;
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.lpstrFilter = strFilter;
	ofn.lpstrFile = waveFileName;
	ofn.nMaxFile = (DWORD)sizeof(waveFileName);
	ofn.Flags =  OFN_PATHMUSTEXIST | OFN_NONETWORKBUTTON | OFN_EXPLORER;
	if (GetOpenFileName(&ofn)==0)
		return false;

	/*EBhENX̓o^*/
	WNDCLASS wndclass;
	wndclass.hCursor		= LoadCursor(NULL,IDC_ARROW);
	wndclass.hIcon			= LoadIcon(hInst, (LPCTSTR)IDI_ICON1);
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= szAppName;
	wndclass.hbrBackground	= (HBRUSH)GetStockObject(BLACK_BRUSH);
	wndclass.hInstance		= hInst;
	wndclass.style			= CS_BYTEALIGNCLIENT|CS_VREDRAW|CS_HREDRAW;
	wndclass.lpfnWndProc	= (WNDPROC)MainWndProc;
	wndclass.cbClsExtra		= 0;
	wndclass.cbWndExtra		= 0;

	if(!RegisterClass(&wndclass))
		return false;

	/*CEBhE*/
	hwndApp = CreateWindowEx(0, szAppName, szAppName,
							WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION,
							CW_USEDEFAULT,CW_USEDEFAULT,640,480,
							(HWND)NULL,(HMENU)NULL,
							hInst,(LPSTR)NULL);
	ShowWindow(hwndApp,nCmdShow);
	UpdateWindow(hwndApp);

	// WAVEt@CJ
	HRESULT hr;
	hr = WaveFile.Open(waveFileName, NULL, WAVEFILE_READ);
	if (FAILED(hr))
	{
	    DXTRACE_ERR(L"WAVEt@CĴɎs", hr);
		return false;
	}

	return true;
}

/*-------------------------------------------
	DirectSound 
--------------------------------------------*/
bool InitDSound(void)
{
	HRESULT hr;

	// IDirectSound8C^[tFCX̎擾
	hr = DirectSoundCreate8(NULL, &pDSound, NULL);
	if (FAILED(hr))
	{
	    DXTRACE_ERR(L"IDirectSound8C^[tFCX̎擾Ɏs", hr);
		return false;
	}

	//ŋxݒ
	hr = pDSound->SetCooperativeLevel(hwndApp, DSSCL_PRIORITY);
	if (FAILED(hr))
	{
	    // x̐ݒɎs
		DXTRACE_ERR(L"x̐ݒɎs", hr);
		return false;
	}

	return true;
}

/*-------------------------------------------
	TEhobt@Ƀf[^Rs[֐
--------------------------------------------*/
void Block_Copy(void)
{
	HRESULT hr;

	// obt@bN
	LPBYTE lpBlockAdd1, lpBlockAdd2;
	DWORD blockSize1, blockSize2;
	hr = pDSData->Lock(dwNextOffset, dwBlockSize,
			(LPVOID*)&lpBlockAdd1, &blockSize1,
			(LPVOID*)&lpBlockAdd2, &blockSize2, 0);
	if (FAILED(hr))
		return;    // obt@̃bNɎs

	// Xg[~OEobt@̃TCY̓ubNETCY̐{̃nYȂ̂ŁA
	// ÕubNl
	if (lpBlockAdd2 != NULL) {
		// obt@AbN
		pDSData->Unlock(lpBlockAdd1, blockSize1, lpBlockAdd2, blockSize2);
		return;   // G[Bobt@ETCYzO
	}

	// Wavet@CubNETCYꍇz肵A
	// obt@ςɂȂ܂ŏ
	DWORD rsize, asize;
	for (asize = 0; asize < blockSize1; asize += rsize)
	{
		WaveFile.Read(lpBlockAdd1 + asize, blockSize1 - asize, &rsize);
		if (blockSize1 - asize != rsize)
			WaveFile.ResetFile();    // t@C߂
	}

	// obt@AbN
	pDSData->Unlock(lpBlockAdd1, blockSize1, lpBlockAdd2, blockSize2);

	// ɏރubNʒuXV
	dwNextOffset += dwBlockSize;
	if (dwNextOffset >= dwBufferSize)
		dwNextOffset = 0;
}

/*-------------------------------------------
	Xbhs֐
--------------------------------------------*/
DWORD WINAPI MyThreadFunc(LPVOID /*param*/)
{
	// obt@(ubN2)ɏł
	WaveFile.ResetFile();
	dwNextOffset = 0;
	Block_Copy( );
	Block_Copy( );

	// Xg[~OĐJn
	pDSData->Play(0, 0, DSBPLAY_LOOPING);

	// f[^ޖ[vɓ
	while(true)
	{
		// DirectSound̃Cxg҂
		DWORD i = WaitForMultipleObjects(2, hEvent, FALSE, INFINITE);

		// CxgAꂩĐubN̎̃ubNɏ
		switch(i)
		{
		case WAIT_OBJECT_0:
			// ̃ubNɏ
			Block_Copy( );
			break;
		case WAIT_OBJECT_0 + 1:
		default:
			// ĐIɁAXbhI
			ExitThread(TRUE);
		}

		// ʍXV
		InvalidateRect(hwndApp, NULL, TRUE);
	}
}

/*-------------------------------------------
	TEhEobt@
--------------------------------------------*/
bool InitSoundBuffer(void)
{
	HRESULT hr;

	// CxgEIuWFNg̍쐬
	hEvent[0] = CreateEvent(NULL, FALSE, FALSE, NULL);
	hEvent[1] = CreateEvent(NULL, FALSE, FALSE, NULL);

	// Xg[~OĐp̃ZJ_Eobt@iQbj쐬
	dwBlockSize = WaveFile.GetFormat()->nAvgBytesPerSec;	// 1ōXVubNETCY1bƂ
	dwBufferSize = dwBlockSize * 2;							// TEhEobt@̓ubN2(2b)
	// DSBUFFERDESC\̂ݒ
	DSBUFFERDESC dsbdesc; 
	ZeroMemory(&dsbdesc, sizeof(DSBUFFERDESC));
	dsbdesc.dwSize = sizeof(DSBUFFERDESC); 
	dsbdesc.dwFlags = DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_GLOBALFOCUS | DSBCAPS_LOCDEFER | DSBCAPS_CTRLPOSITIONNOTIFY;
	dsbdesc.lpwfxFormat = WaveFile.GetFormat();
	dsbdesc.dwBufferBytes = dwBufferSize;

	// obt@
	LPDIRECTSOUNDBUFFER pDSB;
	hr = pDSound->CreateSoundBuffer(&dsbdesc, &pDSB, NULL); 
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"obt@̍쐬Ɏs", hr);
		return false;
	} 
	hr = pDSB->QueryInterface(IID_IDirectSoundBuffer8, (LPVOID*)&pDSData);
	SAFE_RELEASE(pDSB);
	if (FAILED(hr))
	{
	    DXTRACE_ERR(L"IDirectSoundBuffer8C^[tFCX̎擾Ɏs", hr);
		return false;
	}

	// IDirectSoundNotify8C^[tFCX̎擾
	hr = pDSData->QueryInterface(IID_IDirectSoundNotify8, (LPVOID*)&pDSNotify);
	if (FAILED(hr))
	{
	    DXTRACE_ERR(L"IDirectSoundNotify8C^[tFCX̎擾Ɏs", hr);
		return false;
	}

	// DirectSoundNotify8ݒ肷
	// \̂
	DSBPOSITIONNOTIFY  pn[3];
	pn[0].dwOffset = 1 * dwBlockSize - 1;	// 1bڂ̒O
	pn[0].hEventNotify = hEvent[0];
	pn[1].dwOffset = 2 * dwBlockSize - 1;	// 2bڂ̒O
	pn[1].hEventNotify = hEvent[0];
	pn[2].dwOffset = DSBPN_OFFSETSTOP;	// Đ~
	pn[2].hEventNotify = hEvent[1];	// Qڂ̃CxgEnh~̃nhƂĎg

	// ~ʒuݒ
	hr = pDSNotify->SetNotificationPositions(3, pn);
	if(hr != DS_OK)
	{
		DXTRACE_ERR(L"~ʒuݒɎs", hr);
		return false;
	}

	// XbhR[h
	hThreadHandle = CreateThread(NULL, 0, MyThreadFunc, NULL, 0, &dwThreadID);
	if(hThreadHandle == NULL)
	{
		DXTRACE_ERR(L"Xbh̐Ɏs", hr);
		return false;
	}

	return true;
}

/*-------------------------------------------
	TEhEobt@̊J
--------------------------------------------*/
bool ReleaseSoundBuffer(void)
{
	// Đ~(ĐXbh̏I)
	if(pDSData)	pDSData->Stop();
	WaitForSingleObject(hThreadHandle, INFINITE);
	CloseHandle(hThreadHandle);

	// TEhEobt@J
	SAFE_RELEASE(pDSNotify);
	SAFE_RELEASE(pDSData);

	// CxgEnhJ
	if (hEvent[1])	{ CloseHandle(hEvent[1]); hEvent[1]=NULL; }
	if (hEvent[0])	{ CloseHandle(hEvent[0]); hEvent[0]=NULL; }

	return true;
}

/*-------------------------------------------
	DirectSound̊J
--------------------------------------------*/
bool ReleaseDSound(void)
{
	// DirectSound̃IuWFNgJ
	SAFE_RELEASE(pDSound);

	return true;
}

/*-------------------------------------------
	AvP[V̏I
--------------------------------------------*/
bool EndApp(void)
{
	// WAVEt@C
	WaveFile.Close();

	return true;
}


/*-------------------------------------------
	EBhE
--------------------------------------------*/
LRESULT CALLBACK MainWndProc(HWND hWnd,UINT msg,UINT wParam,LONG lParam)
{
	HRESULT hr;

	switch(msg){
		case WM_KEYDOWN:
			switch(wParam){
				case VK_ESCAPE:
					DestroyWindow(hWnd);
					break;
			}
			break;

		case WM_DESTROY:
			PostQuitMessage(0);
			break;

		case WM_PAINT:
			{
				PAINTSTRUCT ps;
				HDC hDC = BeginPaint(hWnd, &ps);

				WCHAR CData[200];
				hr = StringCbPrintf(CData, sizeof(CData), L"WAVEt@CXg[~OĐ [%d]", dwNextOffset);
				if (SUCCEEDED(hr))
					TextOut(hDC, 0, 0, CData, lstrlen(CData));
			
				EndPaint(hWnd, &ps);
			}

		default:
			return DefWindowProc(hWnd,msg,wParam,lParam);
	}

	return 0L;
}


/*--------------------------------------------
	ACh̏
--------------------------------------------*/
bool AppIdle(void)
{
	return true;
}

/*--------------------------------------------
	C
---------------------------------------------*/
int WINAPI WinMain(HINSTANCE hInst,HINSTANCE /*hPrevInst*/,LPSTR /*lpCmdLine*/,int nCmdShow)
{
	// fobO q[v }l[Wɂ郁蓖Ă̒ǐՕ@ݒ
#if defined(DEBUG) || defined(_DEBUG)
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
#endif

	// AvP[VɊւ鏉
	bool flag = InitApp(hInst,nCmdShow);

	// DirectSoundɊւ鏉
	if (flag) flag = InitDSound();

	// TEhEobt@Ɋւ鏉
	if (flag) flag = InitSoundBuffer();

	MSG msg;
	msg.wParam = 0;
	while(flag){
		if(PeekMessage(&msg,0,0,0,PM_REMOVE)){
			if(msg.message == WM_QUIT)
				break;

			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else{
			// AChiʕ`j
			if (!AppIdle())
				// G[ꍇCAvP[VI
				PostQuitMessage(0);
		}
	}

	// TEhEobt@J
	ReleaseSoundBuffer();

	// DirectSound̏I
	ReleaseDSound();

	// AvP[V̏I
	EndApp();

	return (int)msg.wParam;
}



