/*----------------------------------------------------------
	DirectSoundTv
		EMicrosoft DirectX SDK (February 2007)
		EVisual Studio 2005 Standard
		EWindows XP or Windows Vista
		Ή

	DSSample03.cpp
		u3DTEhv
--------------------------------------------------------------*/

// DirectSoundpt@CCN[h
#define STRICT
#include <windows.h>
#include <crtdbg.h>
#include <mmsystem.h>
#include <mmreg.h>
#include <dsound.h>
#include <dxerr.h>

#pragma warning( disable : 4996 ) // disable deprecated warning 
#include <strsafe.h>
#pragma warning( default : 4996 ) 

#define SAFE_RELEASE(p)      { if(p) { (p)->Release(); (p)=NULL; } }

// DirectSoundpCũN
#pragma comment( lib, "dsound.lib" )
#pragma comment( lib, "dxerr.lib" )
#pragma comment( lib, "winmm.lib" )

// DXUT OptionalCWaveFileNXgp
#define DXUT_AUTOLIB    // Direct3DpCũNw
#include "DXUT.h"
#include "SDKwavefile.h"

// DXUT̃CuN
#if defined(DEBUG) || defined(_DEBUG)
#pragma comment( lib, "..\\Debug\\DXUT.lib" )
#pragma comment( lib, "..\\Debug\\DXUTOpt.lib" )
#else
#pragma comment( lib, "..\\Release\\DXUT.lib" )
#pragma comment( lib, "..\\Release\\DXUTOpt.lib" )
#endif

// \[X
#include "resource.h"

#define WAVEFILENAME	L"..\\..\\Media\\Drum.wav"

/*-------------------------------------------
	Oϐ
--------------------------------------------*/
HINSTANCE hInstApp;
HWND hwndApp;

WCHAR szAppName[] = L"DirectSound Sample 3";

LPDIRECTSOUND8           pDSound = NULL;
LPDIRECTSOUNDBUFFER      pDSPrimary = NULL;
LPDIRECTSOUND3DLISTENER8 pDSListener = NULL;
LPDIRECTSOUNDBUFFER8     pDSData = NULL;
LPDIRECTSOUND3DBUFFER8   pDS3DData = NULL;

CWaveFile waveFile;

D3DVALUE Sound_X = 0;
D3DVALUE Sound_P = 10;
D3DVALUE Sound_V = -0.1f;

LRESULT CALLBACK MainWndProc(HWND hWnd,UINT msg,UINT wParam,LONG lParam);

/*-------------------------------------------
	AvP[V
--------------------------------------------*/
bool InitApp(HINSTANCE hInst,int nCmdShow)
{
	hInstApp=hInst;

	/*EBhENX̓o^*/
	WNDCLASS wndclass;
	wndclass.hCursor		= LoadCursor(NULL,IDC_ARROW);
	wndclass.hIcon			= LoadIcon(hInst, (LPCTSTR)IDI_ICON1);
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= szAppName;
	wndclass.hbrBackground	= (HBRUSH)GetStockObject(BLACK_BRUSH);
	wndclass.hInstance		= hInst;
	wndclass.style			= CS_BYTEALIGNCLIENT|CS_VREDRAW|CS_HREDRAW;
	wndclass.lpfnWndProc	= (WNDPROC)MainWndProc;
	wndclass.cbClsExtra		= 0;
	wndclass.cbWndExtra		= 0;

	if(!RegisterClass(&wndclass))
		return FALSE;

	/*CEBhE*/
	hwndApp = CreateWindowEx(0, szAppName, szAppName,
							WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION,
							CW_USEDEFAULT,CW_USEDEFAULT,640,480,
							(HWND)NULL,(HMENU)NULL,
							hInst,(LPSTR)NULL);
	ShowWindow(hwndApp,nCmdShow);
	UpdateWindow(hwndApp);

	return TRUE;
}

/*-------------------------------------------
	WAVEt@CɃZJ_Eobt@
--------------------------------------------*/
bool CreateSoundData(LPTSTR pName, LPDIRECTSOUNDBUFFER8 &pDSData, LPDIRECTSOUND3DBUFFER8 &pDS3DData)
{
	HRESULT hr;

	// WAVEt@CJ
	hr = waveFile.Open(pName, NULL, WAVEFILE_READ);
	if (FAILED(hr))
	{
	    DXTRACE_ERR(L"WAVEt@C̃I[vɎs", hr);
		return false;
	}

	// ZJ_Eobt@쐬
	// DSBUFFERDESC\̂ݒ
	DSBUFFERDESC dsbdesc; 
	ZeroMemory(&dsbdesc, sizeof(DSBUFFERDESC));
	dsbdesc.dwSize = sizeof(DSBUFFERDESC); 
	dsbdesc.dwFlags = DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_GLOBALFOCUS | DSBCAPS_LOCDEFER | DSBCAPS_CTRL3D;
	dsbdesc.dwBufferBytes = waveFile.GetSize();
	dsbdesc.lpwfxFormat = waveFile.GetFormat();
	dsbdesc.guid3DAlgorithm = DS3DALG_HRTF_FULL;	// Ƃ肠̃ASYvĂ

	// obt@
	LPDIRECTSOUNDBUFFER pDSB;
	hr = pDSound->CreateSoundBuffer(&dsbdesc, &pDSB, NULL); 
	if (FAILED(hr))
	{ 
	    DXTRACE_ERR(L"obt@̍쐬Ɏs", hr);
		return false;
	} 
	hr = pDSB->QueryInterface(IID_IDirectSoundBuffer8, (LPVOID*)&pDSData);
	SAFE_RELEASE(pDSB);
	if (FAILED(hr))
	{
	    DXTRACE_ERR(L"IDirectSoundBuffer8C^[tFCX̎擾Ɏs", hr);
		return false;
	}
	hr = pDSData->QueryInterface(IID_IDirectSound3DBuffer8, (void**)&pDS3DData);
	if (FAILED(hr))
	{ 
	    DXTRACE_ERR(L"3Dobt@̍쐬Ɏs", hr);
		return false;
	} 

	// ZJ_Eobt@Wavef[^
	LPVOID lpvPtr1; 	// ŏ̃ubÑ|C^
	DWORD dwBytes1; 	// ŏ̃ubÑTCY
	LPVOID lpvPtr2; 	// QԖڂ̃ubÑ|C^
	DWORD dwBytes2; 	// QԖڂ̃ubÑTCY

	hr = pDSData->Lock(0, waveFile.GetSize(), &lpvPtr1, &dwBytes1, &lpvPtr2, &dwBytes2, 0); 

	// DSERR_BUFFERLOSTԂꂽꍇCRestore\bhgăobt@𕜌
	if(DSERR_BUFFERLOST == hr)
	{
		pDSData->Restore();
		hr = pDSData->Lock(0, waveFile.GetSize(), &lpvPtr1, &dwBytes1, &lpvPtr2, &dwBytes2, 0);
	} 
	if (SUCCEEDED(hr))
	{
	    // bN

	    // ŁCobt@ɏ
		// obt@Ƀf[^Rs[
		DWORD rsize;
		waveFile.Read((LPBYTE)lpvPtr1, dwBytes1, &rsize);
		if ( 0 != dwBytes2 )
			waveFile.Read((LPBYTE)lpvPtr2, dwBytes2, &rsize);

	   // ݂I炷UnlockD
	    hr = pDSData->Unlock(lpvPtr1, dwBytes1, lpvPtr2, dwBytes2); 
	}

	return true;
}

/*-------------------------------------------
	DirectSound 
--------------------------------------------*/
bool InitDSound(void)
{
	HRESULT hr;

	// IDirectSound8C^[tFCX̎擾
	hr = DirectSoundCreate8(NULL, &pDSound, NULL);
	if (FAILED(hr))
	{
	    DXTRACE_ERR(L"IDirectSound8C^[tFCX̎擾Ɏs", hr);
		return false;
	}

	//ŋxݒ
	hr = pDSound->SetCooperativeLevel(hwndApp, DSSCL_PRIORITY);
	if (FAILED(hr))
	{
	    // x̐ݒɎs
		SAFE_RELEASE(pDSound);
		DXTRACE_ERR(L"x̐ݒɎs", hr);
		return false;
	}

	// vC}Eobt@̍쐬
	// DSBUFFERDESC\̂ݒ
	DSBUFFERDESC dsbdesc; 
	ZeroMemory(&dsbdesc, sizeof(DSBUFFERDESC));
	dsbdesc.dwSize = sizeof(DSBUFFERDESC); 
	// vC}Eobt@w
	dsbdesc.dwFlags = DSBCAPS_CTRL3D | DSBCAPS_PRIMARYBUFFER;
	dsbdesc.dwBufferBytes = 0;
	dsbdesc.lpwfxFormat = NULL;

	// obt@
	hr = pDSound->CreateSoundBuffer(&dsbdesc, &pDSPrimary, NULL); 
	if (FAILED(hr))
	{
	    // obt@̍쐬Ɏs
		DXTRACE_ERR(L"vC}Eobt@̍쐬Ɏs", hr);
		return false;
	}

	// Xi[̍쐬
	hr = pDSPrimary->QueryInterface(IID_IDirectSound3DListener8, (LPVOID*)&pDSListener);
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"Xi[̍쐬Ɏs", hr);
		return false;
	}

	// Xi[̃p[^ݒ
	pDSListener->SetPosition(0, 0, 0, DS3D_IMMEDIATE);	// ʒu(0,0,0)
	pDSListener->SetVelocity(0, 0, 0, DS3D_IMMEDIATE);	// x(0,0,0)
	pDSListener->SetOrientation(0, 0, 1.0f, 0, 1.0f, 0, DS3D_IMMEDIATE);	// O(0,0,1)(0,1,0)
	pDSListener->SetRolloffFactor(1.0f, DS3D_IMMEDIATE);	// [ItW
	pDSListener->SetDopplerFactor(DS3D_MAXDOPPLERFACTOR, DS3D_IMMEDIATE);	// hbv[ʍő

	return true;
}

/*-------------------------------------------
	TEhEobt@
--------------------------------------------*/
bool InitSoundBuffer(void)
{
	// WAVEt@CɃZJ_Eobt@쐬
	bool  f = CreateSoundData(WAVEFILENAME, pDSData, pDS3DData);
	if(!f)
	{
	    DXTRACE_MSG(L"ZJ_Eobt@̍쐬Ɏs");
		return false;
	}

	// ̃p[^ݒ
	pDS3DData->SetMinDistance(1.0f, DS3D_IMMEDIATE);	// ŒZ 1m
	pDS3DData->SetMaxDistance(10.0f, DS3D_IMMEDIATE);	// Œ 10m
	pDS3DData->SetPosition(Sound_X, 0, Sound_P, DS3D_IMMEDIATE);	// ʒu(Sound_X, 0, Sound_P)
	pDS3DData->SetVelocity(0, 0, Sound_V, DS3D_IMMEDIATE);	// x(Sound_V, 0, 0)

	// ĐJn
	pDSData->Play(0, 0, DSBPLAY_LOOPING);

	return true;
}

/*-------------------------------------------
	TEhEobt@̊J
--------------------------------------------*/
bool ReleaseSoundBuffer(void)
{
	// Đ~
	if(pDSData)	pDSData->Stop();

	// TEhEobt@J
	SAFE_RELEASE(pDS3DData);
	SAFE_RELEASE(pDSData);

	return true;
}

/*-------------------------------------------
	DirectSound̊J
--------------------------------------------*/
bool ReleaseDSound(void)
{
	// DirectSound̃IuWFNgJ
	SAFE_RELEASE(pDSListener);
	SAFE_RELEASE(pDSPrimary);
	SAFE_RELEASE(pDSound);

	return true;
}

/*-------------------------------------------
	AvP[V̏I
--------------------------------------------*/
bool EndApp(void)
{
	// WAVEt@C
	waveFile.Close();

	return true;
}


/*-------------------------------------------
	EBhE
--------------------------------------------*/
LRESULT CALLBACK MainWndProc(HWND hWnd,UINT msg,UINT wParam,LONG lParam)
{
	HRESULT hr;

	switch(msg){
		case WM_KEYDOWN:
			switch(wParam){
				case VK_ESCAPE:
					DestroyWindow(hWnd);
					break;
			}
			break;

		case WM_DESTROY:
			PostQuitMessage(0);
			break;

		case WM_PAINT:
			{
				PAINTSTRUCT ps;
				HDC hDC = BeginPaint(hWnd, &ps);

				WCHAR CData[200];
				hr = StringCbPrintf(CData, sizeof(CData), L"3D Sound Position[%f, 0.0, %f]", Sound_X, Sound_P);
				if (SUCCEEDED(hr))
					TextOut(hDC, 0, 0, CData, lstrlen(CData));

				EndPaint(hWnd, &ps);
			}

		default:
			return DefWindowProc(hWnd,msg,wParam,lParam);
	}

	return 0L;
}


/*--------------------------------------------
	ACh̏
--------------------------------------------*/
bool AppIdle(void)
{
	if(!pDSound)
		return TRUE;

	//̈ړ
	Sound_P += Sound_V;
	if(Sound_P < 1)	{ Sound_P = 1; Sound_V *= -1; }
	else if(10 < Sound_P)	{ Sound_P = 10; Sound_V *= -1; }

	if(GetAsyncKeyState(VK_LEFT) < 0 && Sound_X > -2) Sound_X -= 0.1f;
	if(GetAsyncKeyState(VK_RIGHT) < 0 && Sound_X <  2) Sound_X += 0.1f;

	pDS3DData->SetPosition(Sound_X, 0, Sound_P, DS3D_IMMEDIATE);	// ʒu(Sound_X, 0, Sound_P)
	pDS3DData->SetVelocity(0, 0, Sound_V, DS3D_IMMEDIATE);	// x(Sound_V, 0, 0)

	Sleep(50);
	InvalidateRect(hwndApp, NULL, TRUE);

	return true;
}

/*--------------------------------------------
	C
---------------------------------------------*/
int WINAPI WinMain(HINSTANCE hInst,HINSTANCE /*hPrevInst*/,LPSTR /*lpCmdLine*/,int nCmdShow)
{
	// fobO q[v }l[Wɂ郁蓖Ă̒ǐՕ@ݒ
#if defined(DEBUG) || defined(_DEBUG)
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
#endif

	// AvP[VɊւ鏉
	bool flag = InitApp(hInst,nCmdShow);

	// DirectSoundɊւ鏉
	if (flag) flag = InitDSound();

	// TEhEobt@Ɋւ鏉
	if (flag) flag = InitSoundBuffer();

	MSG msg;
	msg.wParam = 0;
	while(flag){
		if(PeekMessage(&msg,0,0,0,PM_REMOVE)){
			if(msg.message == WM_QUIT)
				break;

			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else{
			// AChiʕ`j
			if (!AppIdle())
				// G[ꍇCAvP[VI
				PostQuitMessage(0);
		}
	}

	// TEhEobt@J
	ReleaseSoundBuffer();

	// DirectSound̏I
	ReleaseDSound();

	// AvP[V̏I
	EndApp();

	return (int)msg.wParam;
}



