/*----------------------------------------------------------
	DirectSoundTv
		EMicrosoft DirectX SDK (February 2007)
		EVisual Studio 2005 Standard
		EWindows XP or Windows Vista
		Ή

	DSSample06.cpp
		uDXUTDirectSoundT|[gNXgp(2)@Xg[~OEobt@v
--------------------------------------------------------------*/

// DirectSoundpt@CCN[h
#define STRICT
#include <windows.h>
#include <crtdbg.h>
#include <mmsystem.h>
#include <mmreg.h>
#include <dsound.h>
#include <dxerr.h>

#pragma warning( disable : 4996 ) // disable deprecated warning 
#include <strsafe.h>
#pragma warning( default : 4996 ) 

#define SAFE_RELEASE(p)      { if(p) { (p)->Release(); (p)=NULL; } }

// DirectSoundpCũN
#pragma comment( lib, "dsound.lib" )
#pragma comment( lib, "dxerr.lib" )
#pragma comment( lib, "winmm.lib" )

// DXUT OptionalCSoundNXCWaveFileNXgp
#define DXUT_AUTOLIB    // Direct3DpCũNw
#include "DXUT.h"
#include "SDKsound.h"
#include "SDKwavefile.h"

// DXUT̃CuN
#if defined(DEBUG) || defined(_DEBUG)
#pragma comment( lib, "..\\Debug\\DXUT.lib" )
#pragma comment( lib, "..\\Debug\\DXUTOpt.lib" )
#else
#pragma comment( lib, "..\\Release\\DXUT.lib" )
#pragma comment( lib, "..\\Release\\DXUTOpt.lib" )
#endif

// \[X
#include "resource.h"

/*-------------------------------------------
	Oϐ
--------------------------------------------*/
HINSTANCE hInstApp;
HWND hwndApp;

WCHAR szAppName[] = L"DirectSound Sample 6";

// DXUTDirectSoundT|[gNX
CSoundManager *pSoundManager = NULL;
CStreamingSound *pSound = NULL;
HANDLE hEvent[2] = { NULL, NULL };

HANDLE hThreadHandle = NULL;	// Xbh nh
DWORD dwThreadID = 0;			// XbhID

LRESULT CALLBACK MainWndProc(HWND hWnd,UINT msg,UINT wParam,LONG lParam);

/*-------------------------------------------
	AvP[V
--------------------------------------------*/
bool InitApp(HINSTANCE hInst,int nCmdShow)
{
	WNDCLASS wndclass;

	hInstApp=hInst;

	/*EBhENX̓o^*/
	wndclass.hCursor		= LoadCursor(NULL,IDC_ARROW);
	wndclass.hIcon			= LoadIcon(hInst, (LPCTSTR)IDI_ICON1);
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= szAppName;
	wndclass.hbrBackground	= (HBRUSH)GetStockObject(BLACK_BRUSH);
	wndclass.hInstance		= hInst;
	wndclass.style			= CS_BYTEALIGNCLIENT|CS_VREDRAW|CS_HREDRAW;
	wndclass.lpfnWndProc	= (WNDPROC)MainWndProc;
	wndclass.cbClsExtra		= 0;
	wndclass.cbWndExtra		= 0;

	if(!RegisterClass(&wndclass))
		return FALSE;

	/*CEBhE*/
	hwndApp = CreateWindowEx(0, szAppName, szAppName,
							WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION,
							CW_USEDEFAULT,CW_USEDEFAULT,640,480,
							(HWND)NULL,(HMENU)NULL,
							hInst,(LPSTR)NULL);
	ShowWindow(hwndApp,nCmdShow);
	UpdateWindow(hwndApp);

	return TRUE;
}

/*-------------------------------------------
	DirectSound 
--------------------------------------------*/
bool InitDSound(void)
{
	HRESULT hr;

	// CSoundManageȑ
	pSoundManager = new CSoundManager();
	hr = pSoundManager->Initialize(hwndApp, DSSCL_PRIORITY);
	if (FAILED(hr)) {
		DXTRACE_ERR(L"CSoundManageȑɎs", hr);
		return false;
	}

	// vC}Eobt@̃tH[}bgݒ
	hr = pSoundManager->SetPrimaryBufferFormat(2, 44100, 16);
	if (FAILED(hr)) {
		DXTRACE_ERR(L"vC}Eobt@̃tH[}bgݒɎs", hr);
		return false;
	}

	return true;
}

/*-------------------------------------------
	Xbhs֐
--------------------------------------------*/
DWORD WINAPI MyThreadFunc(LPVOID /*param*/)
{
	// f[^ޖ[vɓ
	while(true)
	{
		// DirectSound̃Cxg҂
		DWORD i = WaitForMultipleObjects(2, hEvent, FALSE, INFINITE);

		// CxgAubNɏ
		switch(i)
		{
		case WAIT_OBJECT_0:
			// ̃ubNɏ
			if (pSound != NULL)
				pSound->HandleWaveStreamNotification(TRUE);
			break;

		case WAIT_OBJECT_0 + 1:
		default:
			// XbhI
			ExitThread(TRUE);
		}

		// ʍXV
		InvalidateRect(hwndApp, NULL, TRUE);
	}
}

/*-------------------------------------------
	TEhEobt@
--------------------------------------------*/
bool InitSoundBuffer(void)
{
	HRESULT hr;

	// Xg[~OĐp̃CxgEnh쐬
	hEvent[0] = CreateEvent(NULL, FALSE, FALSE, NULL);
	hEvent[1] = CreateEvent(NULL, FALSE, FALSE, NULL);

	// Xg[~OĐp̃Xbh쐬
	hThreadHandle = CreateThread(NULL, 0, MyThreadFunc, NULL, 0, &dwThreadID);
	if(hThreadHandle == NULL)
	{
		DXTRACE_MSG(L"Xbh̐Ɏs");
		return false;
	}

	// ĐWAVEt@CI
	WCHAR strFilter[] = L"Wave File(*.wav)\0*.wav\0";
	WCHAR waveFileName[260] = L"";
	OPENFILENAME ofn;
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.lpstrFilter = strFilter;
	ofn.lpstrFile = waveFileName;
	ofn.nMaxFile = (DWORD)sizeof(waveFileName);
	ofn.Flags =  OFN_PATHMUSTEXIST | OFN_NONETWORKBUTTON | OFN_EXPLORER;
	if (GetOpenFileName(&ofn)==0)
		return false;

	// IWavet@CǂݍŁAXg[~OEobt@쐬
	hr = pSoundManager->CreateStreaming(&pSound, waveFileName, DSBCAPS_LOCDEFER, GUID_NULL, 2, 1024, hEvent[0]);
	if (FAILED(hr)) {
		DXTRACE_ERR(L"Xg[~OEobt@̍쐬Ɏs", hr);
		return false;
	}

	// ĐJn
	DXUT_PlaySoundLooping(pSound);

	return true;
}

/*-------------------------------------------
	TEhEobt@̉
--------------------------------------------*/
bool ReleaseSoundBuffer(void)
{
	// Đ~
	DXUT_StopSound(pSound);

	// Xbh֐̏I
	SetEvent(hEvent[1]);
	WaitForSingleObject(hThreadHandle, INFINITE);
	CloseHandle(hThreadHandle);

	// CStreamingSound̉
	SAFE_DELETE(pSound);

	// CxgEnhJ
	if (hEvent[0])	{ CloseHandle(hEvent[0]); hEvent[0]=NULL; }
	if (hEvent[1])	{ CloseHandle(hEvent[1]); hEvent[1]=NULL; }

	return true;
}

/*-------------------------------------------
	DirectSound̉
--------------------------------------------*/
bool ReleaseDSound(void)
{
	//CSoundManager̉
	SAFE_DELETE(pSoundManager);

	return true;
}

/*-------------------------------------------
	AvP[V̏I
--------------------------------------------*/
bool EndApp(void)
{
	return true;
}


/*-------------------------------------------
	EBhE
--------------------------------------------*/
LRESULT CALLBACK MainWndProc(HWND hWnd,UINT msg,UINT wParam,LONG lParam)
{
	switch(msg){
		case WM_KEYDOWN:
			switch(wParam){
				case VK_ESCAPE:
					DestroyWindow(hWnd);
					break;

				// Xg[~OEobt@̃[vĐJn
				case '1':
					DXUT_PlaySoundLooping(pSound);
					break;

				// Đ~
				case '2':
					DXUT_StopSound(pSound);
					break;

				default:
					break;
			}
			break;

		case WM_DESTROY:
			PostQuitMessage(0);
			break;

		case WM_PAINT:
			{
				PAINTSTRUCT ps;
				HDC hDC = BeginPaint(hWnd, &ps);

				EndPaint(hWnd, &ps);
			}

		default:
			return DefWindowProc(hWnd,msg,wParam,lParam);
	}

	return 0L;
}

/*--------------------------------------------
	ACh̏
--------------------------------------------*/
bool AppIdle(void)
{
	return true;
}

/*--------------------------------------------
	C
---------------------------------------------*/
int WINAPI WinMain(HINSTANCE hInst,HINSTANCE /*hPrevInst*/,LPSTR /*lpCmdLine*/,int nCmdShow)
{
	// fobO q[v }l[Wɂ郁蓖Ă̒ǐՕ@ݒ
#if defined(DEBUG) || defined(_DEBUG)
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
#endif

	// AvP[VɊւ鏉
	bool flag = InitApp(hInst,nCmdShow);

	// DirectSoundɊւ鏉
	if (flag) flag = InitDSound();

	// TEhEobt@Ɋւ鏉
	if (flag) flag = InitSoundBuffer();

	MSG msg;
	msg.wParam = 0;
	while(flag){
		if(PeekMessage(&msg,0,0,0,PM_REMOVE)){
			if(msg.message == WM_QUIT)
				break;

			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else{
			// AChiʕ`j
			if (!AppIdle())
				// G[ꍇCAvP[VI
				PostQuitMessage(0);
		}
	}

	// TEhEobt@
	ReleaseSoundBuffer();

	// DirectSound̏I
	ReleaseDSound();

	// AvP[V̏I
	EndApp();

	return (int)msg.wParam;
}
