float4x4 WorldViewProj;        // [h~r[~ˉeϊs
float4   LightPos;             // ̈ʒu(f)
float    LightBrightness;      // ̋Px
float    ModelScale;           // fԂ̃XP[

// _VF[_(_)
void TVertexShader(
    in  float4 inPos      : POSITION,    // [] W(f)
    in  float4 inNormal   : NORMAL0,     // [] @xNg

    out float4 outPos     : POSITION,    // [o] W(ˉe)
    out float4 outDiff    : COLOR0)      // [o] F
{
    // _r[Ԃɕϊ
    outPos  = mul(inPos, WorldViewProj);

    // fBt[YFvZ(_)
    float4 vL = LightPos - inPos;              // xNg
    float  lengL = length(vL) * ModelScale;    // xNg̒(ւ̋)
    float4 normL = normalize(vL);              // xNg(PʃxNg)
    float4 normN = normalize(inNormal);        // @xNg(PʃxNg)
    float  L = LightBrightness * dot(normN, normL) / (lengL * lengL);  // ̋
    outDiff = max(0, L);                       // fBt[YF
}

// sNZEVF[_
void TPixelShader(
    in  float4 inDiff     : COLOR0,        // [] F
    out float4 outDiff    : COLOR0)        // [o] F
{
    outDiff = inDiff;
}

// eNjbN̒`
technique MatStack_Tech        // eNjbN(f𕁒ʂɕ`悷)
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        ZWriteEnable = TRUE;          // Zobt@֏
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        // VF[_ݒ
        VertexShader = compile vs_2_0 TVertexShader();  // _VF[_̐ݒ
        PixelShader  = compile ps_2_0 TPixelShader();   // sNZEVF[_̐ݒ
    }
}
