// ********** VhEE}bvp **********
float4x4 WorldViewProjShadow;  // [h~r[~ˉeϊs(VhEE}bvp)

// _VF[_
void TVertexShader_Shadow(
    in  float4 inPos      : POSITION,    // [] W(f)

    out float4 outPos     : POSITION,    // [o] W(ˉe)
    out float4 outTexture : TEXCOORD0)   // [o] eNX`W
{
    // _𓧎Ԃɕϊ
    outPos  = mul(inPos, WorldViewProjShadow);

    // eNX`WƂāA_Wo
    outTexture = outPos;
}

// sNZEVF[_
void TPixelShader_Shadow(
    in  float4 inTexture  : TEXCOORD0,     // [] eNX`W
    out float4 outDiff    : COLOR0)        // [o] F
{
    outDiff = inTexture.z / inTexture.w;
}

// ********** V[`p **********
float4x4 WorldViewProj;        // [h~r[~ˉeϊs
float4   LightPos;             // ̈ʒu(f)
float    LightBrightness;      // ̋Px
float    ModelScale;           // fԂ̃XP[
float4   Diffuse;              // fBt[YF

// _VF[_(_)
void TVertexShader(
    in  float4 inPos      : POSITION,    // [] W(f)
    in  float4 inNormal   : NORMAL0,     // [] @xNg
    in  float2 inTexture  : TEXCOORD0,   // [] eNX`W

    out float4 outPos      : POSITION,    // [o] W(ˉe)
    out float4 outDiff     : COLOR0,      // [o] F
    out float2 outTexture0 : TEXCOORD0,   // [o] eNX`W
    out float4 outTexture1 : TEXCOORD1)   // [o] eNX`W
{
    // _𓧎Ԃɕϊ
    outPos = mul(inPos, WorldViewProj); 

    // fBt[YFvZ(_)
    float4 vL = LightPos - inPos;                // xNg
    float  lengL = length(vL) * ModelScale;      // xNg̒(ւ̋)
    float4 normL = normalize(vL);                // xNg(PʃxNg)
    float4 normN = normalize(inNormal);          // @xNg(PʃxNg)
    float  L = LightBrightness * dot(normN, normL) / (lengL * lengL);  // ̋
    outDiff = Diffuse * max(0, L);               // fBt[YF

    // eNX`W͂̂܂
    outTexture0 = inTexture;
    
    // VhEE}bsOp̍WvZ
    outTexture1 = mul(inPos, WorldViewProjShadow);
}

texture Tex;              // sNZVF[_ŎgeNX`
sampler TexSampler = sampler_state      // eNX`ETv
{
    Texture   = (Tex);
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

texture TexShadow;              // sNZEVF[_ŎgeNX`
sampler TexShadowSampler = sampler_state      // eNX`ETv
{
    Texture   = (TexShadow);
    MipFilter = NONE;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = CLAMP;
    AddressV = CLAMP;
//	AddressU = BORDER;
//	AddressV = BORDER;
//	BorderColor = 0xffffffff;
};

// sNZEVF[_(e)
void TPixelShader(
    in  float4 inDiff     : COLOR0,        // [] F
    in  float2 inTexture0 : TEXCOORD0,     // [] eNX`W
    in  float4 inTexture1 : TEXCOORD1,     // [] eNX`W
    out float4 outDiff    : COLOR0)        // [o] F
{
	float3 texp = inTexture1.xyz / inTexture1.w;
	float2 tp = float2((texp.x + 1.0f) / 2.0f, (1.0f - texp.y) / 2.0f);
	float z = tex2D(TexShadowSampler, tp);
	float4 c = inDiff * tex2D(TexSampler, inTexture0);  // eNX`ǂݍ
	outDiff = c * (step(texp.z, z) * 0.75 + 0.25);
}

// sNZEVF[_(eȂ)
void TPixelShader_NoShadow(
    in  float4 inDiff     : COLOR0,        // [] F
    in  float2 inTexture0 : TEXCOORD0,     // [] eNX`W
    out float4 outDiff    : COLOR0)        // [o] F
{
	outDiff = inDiff * tex2D(TexSampler, inTexture0);  // eNX`ǂݍ
}

// ********** eNjbN̒` **********
// VhE}bv`p
technique ShadowMap_Tech            // eNjbN
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;                // Zobt@̐ݒ
        MultiSampleAntialias = FALSE;  // }`ETvO̐ݒ
        CullMode = CW;                 // wʃJO
        ShadeMode = FLAT;              // O[[EVF[fBOɐݒ
        AlphaBlendEnable = FALSE;      // At@EufBO𖳌ɂ

        // VF[_ݒ
       VertexShader = compile vs_2_0 TVertexShader_Shadow();  // _VF[_̐ݒ
       PixelShader  = compile ps_2_0 TPixelShader_Shadow();   // sNZEVF[_̐ݒ
    }
}

// V[`p(e)
technique Normal_Tech            // eNjbN
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ
        AlphaBlendEnable = FALSE;      // At@EufBO𖳌ɂ

        // VF[_ݒ
       VertexShader = compile vs_2_0 TVertexShader();  // _VF[_̐ݒ
       PixelShader  = compile ps_2_0 TPixelShader();   // sNZEVF[_̐ݒ
    }
}

// V[`p(eȂ)
technique NoShadow_Tech            // eNjbN
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ
        AlphaBlendEnable = FALSE;      // At@EufBO𖳌ɂ

        // VF[_ݒ
       VertexShader = compile vs_2_0 TVertexShader();  // _VF[_̐ݒ
       PixelShader  = compile ps_2_0 TPixelShader_NoShadow();   // sNZEVF[_̐ݒ
    }
}
