// ********** _OpVF[_ **********
float4x4 WorldViewProj;        // [h~r[~ˉeϊs
float4   Light1Pos;            // s̕(f)
float    Light1Brightness;     // s̖邳

// _VF[_(nʗp)
void VertexShader_RenderGround(
    in  float4 inPos      : POSITION,    // [] W(f)
    in  float4 inNormal   : NORMAL0,     // [] @xNg
    in  float4 inTexture  : TEXCOORD0,   // [] eNX`W

    out float4 outPos     : POSITION,    // [o] W(ˉe)
    out float4 outTexture : TEXCOORD0,   // [o] eNX`W
    out float4 outDiff    : TEXCOORD1)   // [o] fBt[YF
    // [] COLORWX^́A0`+1͈̔͂8rbgxۏႳĂȂB
    //        ̂߁AeNX`WƂăfBt[YFo͂ĂB
{
    // _r[Ԃɕϊ
    outPos  = mul(inPos, WorldViewProj);

    // fBt[YFvZ(s)
    float4 normN = normalize(inNormal);  // @xNg(PʃxNg)
    outDiff = Light1Brightness * max(0, dot(normN, Light1Pos));

    // eNX`W͂̂܂
    outTexture  = inTexture;
}

float4   Light2Pos[5];         // _̕(f)
float    Light2Brightness;     // _̖邳

// _VF[_(glp)
void VertexShader_RenderTunnel(
    in  float4 inPos      : POSITION,    // [] W(f)
    in  float4 inNormal   : NORMAL0,     // [] @xNg
    in  float4 inTexture  : TEXCOORD0,   // [] eNX`W

    out float4 outPos     : POSITION,    // [o] W(ˉe)
    out float4 outTexture : TEXCOORD0,   // [o] eNX`W
    out float4 outDiff    : TEXCOORD1)   // [o] fBt[YF
    // [] COLORWX^́A0`+1͈̔͂8rbgxۏႳĂȂB
    //        ̂߁AeNX`WƂăfBt[YFo͂ĂB
{
    // _r[Ԃɕϊ
    outPos  = mul(inPos, WorldViewProj);

    // fBt[YFvZ(_)
    outDiff = 0.0f;
    for (int i=0; i<5; i++)
    {
        float4 vL = Light2Pos[i] - inPos;            // xNg
        float  lengL = length(vL);                   // xNg̒(ւ̋)
        float4 normL = normalize(vL);                // xNg(PʃxNg)
        float4 normN = normalize(inNormal);          // @xNg(PʃxNg)
        float  L = Light2Brightness * dot(normN, normL) / (lengL * lengL);  // ̋
        outDiff += max(0, L);               // fBt[YF
    }

    // eNX`W͂̂܂
    outTexture  = inTexture;
}

texture MeshTexture;                    // sNZVF[_ŎgeNX`
sampler MeshTexSampler = sampler_state  // eNX`ETv
{
    Texture   = (MeshTexture);
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

// sNZEVF[_(nʃglp)
void PixelShader_Render(
    in  float2 inTexture  : TEXCOORD0,     // [] eNX`W
    in  float4 inDiff     : TEXCOORD1,     // [] fBt[YF
    out float4 outDiff    : COLOR0)        // [o] F1
{
	float4 tex = tex2D(MeshTexSampler, inTexture);  // eNX`ǂݍ
    outDiff = tex * inDiff;
}

// ********** kpVF[_ **********
// _VF[_
void VertexShader_Minimize(
    in  float4 inPos      : POSITION,    // [] W(f)
    in  float4 inTexture  : TEXCOORD0,   // [] eNX`W

    out float4 outPos     : POSITION,    // [o] W(ˉe)
    out float4 outTexture : TEXCOORD0)   // [o] eNX`W
{
    outPos      = inPos;
    outTexture  = inTexture;
}

texture ToneTexture;                    // sNZVF[_ŎgeNX`
sampler ToneTexSampler = sampler_state  // eNX`ETv
{
    Texture   = (ToneTexture);
    MipFilter = NONE;
    MinFilter = POINT;
    MagFilter = POINT;
};

// sNZEVF[_
void PixelShader_Minimize(
    in  float2 inTexture  : TEXCOORD0,     // [] eNX`W
    out float4 outDiff    : COLOR0)        // [o] F
{
    float4 p = tex2D(ToneTexSampler, inTexture);  // eNX`ǂݍ
    outDiff = (p.r * 2.0f + p.g * 3.0f + p.b) / 6.0f;
}

// ********** g[E}bsOpVF[_ **********
// _VF[_
void VertexShader_ToneMapping(
    in  float4 inPos      : POSITION,    // [] W(f)
    in  float4 inTexture  : TEXCOORD0,   // [] eNX`W

    out float4 outPos     : POSITION,    // [o] W(ˉe)
    out float4 outTexture : TEXCOORD0)   // [o] eNX`W
{
    outPos      = inPos;
    outTexture  = inTexture;
}

float    BackLightBrightnessMax;  // wiPx(ől)
float    BackLightBrightnessMin;  // wiPx(ŏl)

// sNZEVF[_
void PixelShader_ToneMapping(
    in  float2 inTexture  : TEXCOORD0,     // [] eNX`W
    out float4 outDiff    : COLOR0)        // [o] F
{
    float4 tex = tex2D(ToneTexSampler, inTexture);  // eNX`ǂݍ
    outDiff = smoothstep(BackLightBrightnessMin, BackLightBrightnessMax, tex);
}

// ********** eNjbN̒` **********
technique RenderGround_Tech            // nʕ`peNjbN
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        // VF[_ݒ
       VertexShader = compile vs_2_0 VertexShader_RenderGround();  // _VF[_̐ݒ
       PixelShader  = compile ps_2_0 PixelShader_Render();   // sNZEVF[_̐ݒ
    }
}

technique RenderTunnel_Tech            // gl`peNjbN
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        // VF[_ݒ
       VertexShader = compile vs_2_0 VertexShader_RenderTunnel();  // _VF[_̐ݒ
       PixelShader  = compile ps_2_0 PixelShader_Render();   // sNZEVF[_̐ݒ
    }
}

technique Minimize_Tech            // kpeNjbN
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = FALSE;              // Zobt@̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        // VF[_ݒ
       VertexShader = compile vs_2_0 VertexShader_Minimize();  // _VF[_̐ݒ
       PixelShader  = compile ps_2_0 PixelShader_Minimize();   // sNZEVF[_̐ݒ
    }
}

technique ToneMapping_Tech            // g[E}bsOpeNjbN
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = FALSE;              // Zobt@̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        // VF[_ݒ
       VertexShader = compile vs_2_0 VertexShader_ToneMapping();  // _VF[_̐ݒ
       PixelShader  = compile ps_2_0 PixelShader_ToneMapping();   // sNZEVF[_̐ݒ
    }
}
