float4x4 WorldViewProj;        // [h~r[~ˉeϊs

// _VF[_
void TVertexShader(
    in  float4 inPos      : POSITION,    // [] W(f)
    in  float4 inTexture  : TEXCOORD0,   // [] eNX`W

    out float4 outPos     : POSITION,    // [o] W(ˉe)
    out float4 outTexture : TEXCOORD0)   // [o] eNX`W
{
    // _r[Ԃɕϊ
    outPos  = mul(inPos, WorldViewProj);

    // eNX`W͂̂܂
    outTexture  = inTexture;
}

texture Tex;              // sNZVF[_ŎgeNX`
sampler WRAPSampler = sampler_state      // eNX`ETv(bv)
{
    Texture   = (Tex);
    AddressU = WRAP;
    AddressV = WRAP;
};

sampler MIRRORSampler = sampler_state      // eNX`ETv(~[)
{
    Texture   = (Tex);
    AddressU = MIRROR;
    AddressV = MIRROR;
};

sampler CLAMPSampler = sampler_state      // eNX`ETv(Nv)
{
    Texture   = (Tex);
    AddressU = CLAMP;
    AddressV = CLAMP;
};

sampler BORDERSampler = sampler_state      // eNX`ETv(EF)
{
    Texture   = (Tex);
    AddressU = BORDER;
    AddressV = BORDER;
    BorderColor = 0xffff0000;    // EFD3DCOLOR_XRGB(255, 0, 0)
};

sampler MIRRORONCESampler = sampler_state      // eNX`ETv(~[X)
{
    Texture   = (Tex);
    AddressU = MIRRORONCE;
    AddressV = MIRRORONCE;
};

// sNZEVF[_(bv)
void TPixelShaderWRAP(
    in  float2 inTexture  : TEXCOORD0,     // [] eNX`W
    out float4 outDiff    : COLOR0)        // [o] F
{
    outDiff = tex2D(WRAPSampler, inTexture);  // eNX`ǂݍ
}

// sNZEVF[_(~[)
void TPixelShaderMIRROR(
    in  float2 inTexture  : TEXCOORD0,     // [] eNX`W
    out float4 outDiff    : COLOR0)        // [o] F
{
    outDiff = tex2D(MIRRORSampler, inTexture);  // eNX`ǂݍ
}

// sNZEVF[_(Nv)
void TPixelShaderCLAMP(
    in  float2 inTexture  : TEXCOORD0,     // [] eNX`W
    out float4 outDiff    : COLOR0)        // [o] F
{
    outDiff = tex2D(CLAMPSampler, inTexture);  // eNX`ǂݍ
}

// sNZEVF[_(EF)
void TPixelShaderBORDER(
    in  float2 inTexture  : TEXCOORD0,     // [] eNX`W
    out float4 outDiff    : COLOR0)        // [o] F
{
    outDiff = tex2D(BORDERSampler, inTexture);  // eNX`ǂݍ
}

// sNZEVF[_(~[X)
void TPixelShaderMIRRORONCE(
    in  float2 inTexture  : TEXCOORD0,     // [] eNX`W
    out float4 outDiff    : COLOR0)        // [o] F
{
    outDiff = tex2D(MIRRORONCESampler, inTexture);  // eNX`ǂݍ
}

// eNjbN̒`
technique WRAP_Tech            // eNjbN(bv)
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        // VF[_ݒ
        VertexShader = compile vs_2_0 TVertexShader();  // _VF[_̐ݒ
        PixelShader  = compile ps_2_0 TPixelShaderWRAP();   // sNZEVF[_̐ݒ
    }
}

technique MIRROR_Tech            // eNjbN(~[)
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        // VF[_ݒ
        VertexShader = compile vs_2_0 TVertexShader();  // _VF[_̐ݒ
        PixelShader  = compile ps_2_0 TPixelShaderMIRROR();   // sNZEVF[_̐ݒ
    }
}

technique CLAMP_Tech            // eNjbN(Nv)
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        // VF[_ݒ
        VertexShader = compile vs_2_0 TVertexShader();  // _VF[_̐ݒ
        PixelShader  = compile ps_2_0 TPixelShaderCLAMP();   // sNZEVF[_̐ݒ
    }
}

technique BORDER_Tech            // eNjbN(EF)
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        // VF[_ݒ
        VertexShader = compile vs_2_0 TVertexShader();  // _VF[_̐ݒ
        PixelShader  = compile ps_2_0 TPixelShaderBORDER();   // sNZEVF[_̐ݒ
    }
}

technique MIRRORONCE_Tech            // eNjbN(~[X)
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        // VF[_ݒ
        VertexShader = compile vs_2_0 TVertexShader();  // _VF[_̐ݒ
        PixelShader  = compile ps_2_0 TPixelShaderMIRRORONCE();   // sNZEVF[_̐ݒ
    }
}
