float4x4 WorldViewProj;        // [h~r[~ˉeϊs
float4   LightPos;             // ̈ʒu(f)
float    LightBrightness;      // ̋Px
float    ModelScale;           // fԂ̃XP[
float4   Diffuse;              // fBt[YF

// _VF[_(_)
void TVertexShader(
    in  float4 inPos      : POSITION,    // [] W(f)
    in  float4 inNormal   : NORMAL0,     // [] @xNg
    in  float4 inTexture  : TEXCOORD0,   // [] eNX`W

    out float4 outPos     : POSITION,    // [o] W(ˉe)
    out float4 outDiff    : COLOR0,      // [o] F
    out float4 outTexture : TEXCOORD0)   // [o] eNX`W
{
    // _r[Ԃɕϊ
    outPos  = mul(inPos, WorldViewProj);

    // fBt[YFvZ(_)
    float4 vL = LightPos - inPos;             // xNg
    float  lengL = length(vL) * ModelScale;   // xNg̒(ւ̋)
    float4 normL = normalize(vL);             // xNg(PʃxNg)
    float4 normN = normalize(inNormal);       // @xNg(PʃxNg)
    float  L = LightBrightness * dot(normN, normL) / (lengL * lengL);  // ̋
    outDiff = Diffuse * max(0, L);            // fBt[YF

    // eNX`W͂̂܂
    outTexture  = inTexture;
}

texture Tex;              // sNZVF[_ŎgeNX`
sampler TexSampler = sampler_state      // eNX`ETv
{
    Texture   = (Tex);
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

// sNZEVF[_
void TPixelShader(
    in  float4 inDiff     : COLOR0,        // [] F
    in  float2 inTexture  : TEXCOORD0,     // [] eNX`W
    out float4 outDiff    : COLOR0)        // [o] F
{
    outDiff = inDiff * tex2D(TexSampler, inTexture);  // eNX`ǂݍ
}

// sNZEVF[_(XeVEobt@ݗp)
void TPixelShader_Black(
    out float4 outDiff    : COLOR0)        // [o] F
{
    outDiff = float4(0,0,0,0); // 
}

// eNjbN̒`
technique Model        // eNjbN(f𕁒ʂɕ`悷)
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        ZWriteEnable = TRUE;          // Zobt@֏
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        StencilEnable = FALSE;     // XeV𖳌ɂ

        AlphaBlendEnable = FALSE;      // At@EufBO𖳌ɂ

        // VF[_ݒ
        VertexShader = compile vs_2_0 TVertexShader();  // _VF[_̐ݒ
        PixelShader  = compile ps_2_0 TPixelShader();   // sNZEVF[_̐ݒ
    }
}

technique MirrorStencil        // eNjbN(̕`BXeVlXV)
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        ZWriteEnable = FALSE;         // Zobt@ւ͏܂Ȃ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        StencilEnable = TRUE;     // XeVLɂ
        StencilFunc = ALWAYS;     // XeVeXg͏ɐ
        StencilZFail = KEEP;      // ZeXgśAȂ
        StencilPass = INCRSAT;    // ZeXǵAXeVl{P
        
        AlphaBlendEnable = FALSE;      // At@EufBO𖳌ɂ
        
        // VF[_ݒ
        VertexShader = compile vs_2_0 TVertexShader();  // _VF[_̐ݒ
        PixelShader  = compile ps_2_0 TPixelShader_Black();   // sNZEVF[_̐ݒ
    }
}

technique MirrorModel      // eNjbN(XeVlQƂăf`)
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        ZWriteEnable = TRUE;          // Zobt@֏
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CW;                // wʃJO(])
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        StencilEnable = TRUE;     // XeVLɂ
        StencilRef = 0;           // XeVQƒl = 0
        StencilFunc = LESS;       // XeVl0傫ƂAXeVeXgɐ
        StencilZFail = KEEP;      // ZeXgśAȂ
        StencilPass  = KEEP;      // ZeXǵAȂ

        AlphaBlendEnable = FALSE;      // At@EufBO𖳌ɂ

        // VF[_ݒ
        VertexShader = compile vs_2_0 TVertexShader();  // _VF[_̐ݒ
        PixelShader  = compile ps_2_0 TPixelShader();   // sNZEVF[_̐ݒ
    }
}

technique Mirror      // eNjbN(`)
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = FALSE;               // Zobt@̐ݒ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        StencilEnable = TRUE;     // XeVLɂ
        StencilRef = 0;           // XeVQƒl = 0
        StencilFunc = LESS;       // XeVl0傫ƂAXeVeXgɐ

        AlphaBlendEnable = TRUE;      // At@EufBOLɂ
        SrcBlend = ONE;          // `挳(|S)At@EufBO̐ݒ
        DestBlend = ONE;      // `(t[obt@)At@EufBOݒ

        // VF[_ݒ
        VertexShader = compile vs_2_0 TVertexShader();  // _VF[_̐ݒ
        PixelShader  = compile ps_2_0 TPixelShader();   // sNZEVF[_̐ݒ
    }
}
