#include "directX11render2D.h"
#include "directX11Device.h"
#include "myWindows.h"
#include "ManageMemory.h"

#include <Shlwapi.h>
#include <tchar.h>	
#include "debug.h"
				   
/////////////////////////////////////////////////
/// @param obt@쐬
/// @brief desc : \
/// @brief data : _Ȃ f[^ VO|C^
/// @brief buffer : obt@
/////////////////////////////////////////////
template <class T>
void CreateBuffer(D3D11_BUFFER_DESC* desc, T data, ID3D11Buffer** buffer)
{
	HRESULT hr;
    D3D11_SUBRESOURCE_DATA vertexData;
    ZeroMemory(&vertexData, sizeof(vertexData));
    //vertexData.pSysMem = reinterpret_cast<void*>(data);
    vertexData.pSysMem = (data);

	hr = GetDevice()->CreateBuffer(desc, &vertexData, buffer);
	ASSERT_HR("obt@쐬s", hr );

}					
/////////////////////////////
/// VF[_̃RpC
//////////////////////////
HRESULT CompileShaderFromFile( 
	const TCHAR* filename, 
	const char* entryPoint,
	const char* shaderModel,
	ID3DBlob** ppBlobOut )
{
	HRESULT hr = S_OK;

	DWORD dwShaderFlags = D3D10_SHADER_ENABLE_STRICTNESS;
#if defined( DEBUG ) || defined( _DEBUG )
	dwShaderFlags |= D3D10_SHADER_DEBUG;
#endif

	ID3DBlob* pErrorBlob;
	do{ // RpC܂œǂݍ
		hr = D3DX11CompileFromFile(
			filename,		// t@C
			NULL,			// }N
			NULL,			// CN[ht@C
			entryPoint,		// Gg|Cg֐
			shaderModel,	// VF[_f
			dwShaderFlags,	// VF[_RpCtO
			0,				// GtFNgRpCtO
			NULL,			// Xbh|vC^[tF[Xւ̃|C^
			ppBlobOut, 
			&pErrorBlob, 
			NULL );
		/////////////////////////////////////////////////
		// ǂݍ݃G[
		if( FAILED(hr) )
		{
			if( pErrorBlob != NULL )
			{
				ASSERT((char*)pErrorBlob->GetBufferPointer());
			}
			else
			{
				ASSERT_HR("G[", hr);
			}
		}
		if (pErrorBlob)
		{
			SAFE_RELEASE(pErrorBlob);
		}
	} while ( FAILED(hr) );

	return hr;
}


///---------------------------------
/// 2Dpɕϊ
///---------------------------------
XMVECTOR Trans2D(float x, float y)
{
	return XMVectorSet( 
		static_cast<float>((x-Windows::GetScreenHalfWidth())/Windows::GetScreenHalfWidth()),
		static_cast<float>((y-Windows::GetScreenHalfHeight())/-Windows::GetScreenHalfHeight()),
		0.0f,
		1.0f
		);
}
///---------------------------------
/// 2Dpɕϊ
///---------------------------------
XMVECTOR Trans2D(int x, int y)
{
	return XMVectorSet( 
		static_cast<float>((x-Windows::GetScreenHalfWidth())/Windows::GetScreenHalfWidthF()),
		static_cast<float>((y-Windows::GetScreenHalfHeight())/-Windows::GetScreenHalfHeightF()),
		0.0f,
		1.0f
		);
}

///---------------------------------
/// 2Dpɕϊ
///---------------------------------
XMVECTOR Trans2D(XMVECTOR vec)
{
	return XMVectorSet( 
		static_cast<float>((XMVectorGetX(vec)-Windows::GetScreenHalfWidth())/Windows::GetScreenHalfWidth()),
		static_cast<float>((XMVectorGetY(vec)-Windows::GetScreenHalfHeight())/-Windows::GetScreenHalfHeight()),
		0.0f,
		1.0f
		);
}


XMVECTOR Trans2D(float x, float y);	/// 2Dpɕϊ
XMVECTOR Trans2D(int x, int y);	/// 2Dpɕϊ
XMVECTOR Trans2D(XMVECTOR vec);	/// 2Dpɕϊ

XMVECTOR SetXY(float x, float y); ///< xŷݕύX

Render2D::Render2D() : 
	vertexBuffer(NULL),
	indexBuffer(NULL),
	constantBuffer(NULL),
	inputLayout(NULL),
	vertexShader(NULL),
	pixelShader(NULL)
{
}
Render2D::~Render2D()
{
}
void Render2D::Init()
{
	CreateVertexBuffer();
	CreateIndexBuffer();
	CreateConstantBuffer();

	CreateShader();
}
//////////////////////////////////////////////
/// VF[_̍쐬
////////////////////////////////////
void Render2D::CreateShader()
{
	HRESULT hr;
	// vertex shader
	ID3DBlob* vblob = NULL;
	hr = CompileShaderFromFile(TEXT("2d.fx"), "vsMain", "vs_4_0_level_9_1", &vblob);
	ASSERT_HR( "VF[_RpCs", hr);
	hr = GetDevice()->CreateVertexShader( vblob->GetBufferPointer(), vblob->GetBufferSize(), NULL, &vertexShader);
	ASSERT_HR( "o[ebNXVF[_쐬s", hr);
	// Create InputLayout VŜ݂ɕKv@ǂ̂悤ȗvf
	hr = GetDevice()->CreateInputLayout(
		vbElement_Pos_Col_Tex, 
		sizeof(vbElement_Pos_Col_Tex)/sizeof(D3D11_INPUT_ELEMENT_DESC),	// ̓f[^
		vblob->GetBufferPointer(),
		vblob->GetBufferSize(),
		&inputLayout);
	ASSERT_HR( "CvbgCAEg쐬s", hr);

	// pixel shader
	ID3DBlob* pblob = NULL;
	hr = CompileShaderFromFile(TEXT("2d.fx"), "psMain", "ps_4_0_level_9_1", &pblob);
	ASSERT_HR( "VF[_RpCs", hr);
	hr = GetDevice()->CreatePixelShader( pblob->GetBufferPointer(), pblob->GetBufferSize(), NULL, &pixelShader);
	ASSERT_HR( "sNZVF[_쐬s", hr);


	nowVertexShader = vertexShader;
	nowPixelShader = pixelShader;
	
}
//////////////////////////////////////////////
/// o[ebNXobt@̍쐬
////////////////////////////////////////////
void Render2D::CreateVertexBuffer()
{
	// Create VB
	vertices[0].uv = XMVectorSet( 0.0f, 0.0f, 0.0f, 0.0f);
	vertices[1].uv = XMVectorSet( 1.0f, 0.0f, 0.0f, 0.0f);
	vertices[2].uv = XMVectorSet( 1.0f, 1.0f, 0.0f, 0.0f);
	vertices[3].uv = XMVectorSet( 0.0f, 1.0f, 0.0f, 0.0f);

	vertices[0].color = XMVectorSet( 0.0f, 0.0f, 0.0f, 1.0f);
	vertices[1].color = XMVectorSet( 1.0f, 0.0f, 0.0f, 1.0f);
	vertices[2].color = XMVectorSet( 1.0f, 1.0f, 0.0f, 1.0f);
	vertices[3].color = XMVectorSet( 0.0f, 1.0f, 0.0f, 1.0f);

	unsigned int vsize = sizeof(vertices);

	D3D11_BUFFER_DESC vdesc;
	ZeroMemory(&vdesc, sizeof(vdesc));
	vdesc.ByteWidth      = vsize;
	vdesc.Usage          = D3D11_USAGE_DEFAULT;
	vdesc.BindFlags      = D3D11_BIND_VERTEX_BUFFER;
	vdesc.CPUAccessFlags = 0;


	CreateBuffer(&vdesc, &vertices, &vertexBuffer);

}

//////////////////////////////////////////////
/// CfbNXobt@̍쐬
////////////////////////////////////////////
void Render2D::CreateIndexBuffer()
{
	// Create IB
	unsigned int pIndices[] = 
	{
		1,2,0,3
	};
	unsigned int isize = sizeof(pIndices);
	
	D3D11_BUFFER_DESC idesc;
	ZeroMemory(&idesc, sizeof(idesc));
	idesc.ByteWidth      = isize;
	idesc.Usage          = D3D11_USAGE_DYNAMIC;
	idesc.BindFlags      = D3D11_BIND_INDEX_BUFFER;
	idesc.CPUAccessFlags = D3D11_CPU_ACCESS_WRITE;
	CreateBuffer(&idesc, &pIndices, &indexBuffer);
	

}
//////////////////////////////////////////////
///		萔obt@̍쐬
////////////////////////////////////////////
void Render2D::CreateConstantBuffer()
{
	
	XMMATRIX offset;
	
	offset = XMMatrixTranslation( 0.0f, 0.0, 0);

	//////////////////////////////////////////////////////
	// 萔obt@쐬
	//////////////////////////////////////////////////////
	unsigned int nSize = sizeof(offset);
	
	D3D11_BUFFER_DESC hBufferDesc;
	hBufferDesc.Usage = D3D11_USAGE_DEFAULT;
	hBufferDesc.BindFlags = D3D11_BIND_CONSTANT_BUFFER;
	hBufferDesc.CPUAccessFlags = 0;
	hBufferDesc.MiscFlags = 0;
	hBufferDesc.StructureByteStride = 0;
	hBufferDesc.ByteWidth = nSize;
	CreateBuffer( &hBufferDesc, &offset, &constantBuffer );


}
///////////////////////////////////
/// 摜
///////////////////////////////
void Render2D::Render(
		float x1, float y1, 
		float x2, float y2,
		TextureData* texture )
{
	vertices[0].uv = XMVectorSet( 0.0f, 0.0f, 0.0f, 0.0f);
	vertices[1].uv = XMVectorSet( 1.0f, 0.0f, 0.0f, 0.0f);
	vertices[2].uv = XMVectorSet( 1.0f, 1.0f, 0.0f, 0.0f);
	vertices[3].uv = XMVectorSet( 0.0f, 1.0f, 0.0f, 0.0f);
	vertices[0].pos = Trans2D(x1, y1);
	vertices[1].pos = Trans2D(x2, y1);
	vertices[2].pos = Trans2D(x2, y2);
	vertices[3].pos = Trans2D(x1, y2);

	GetDeviceContext()->UpdateSubresource( vertexBuffer, 0, NULL, vertices, 0, 0 );

	nowPixelShader = pixelShader;

	
	// VB̃Zbg
	ID3D11Buffer* pBufferTbl[] = { vertexBuffer };
	UINT SizeTbl[] = { sizeof(Vertex_Pos_Col_Tex) };
	UINT OffsetTbl[] = { 0 };
	GetDeviceContext()->IASetVertexBuffers(0, 1, pBufferTbl, SizeTbl, OffsetTbl);
	// IB̃Zbg
	GetDeviceContext()->IASetIndexBuffer(indexBuffer, DXGI_FORMAT_R32_UINT, 0);

	// IL̃Zbg
	GetDeviceContext()->IASetInputLayout(inputLayout);
	// v~eBu^CṽZbg
	SetPrimitiveType(D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);

	// Shader̃ZbgAbv
	GetDeviceContext()->VSSetShader(nowVertexShader, NULL, 0);
	GetDeviceContext()->VSSetConstantBuffers( 0, 1, &constantBuffer );
	GetDeviceContext()->PSSetShader(nowPixelShader, NULL, 0);
	
	// _Oݒ
	DirectX11Device::GetInstance()->SetRenderTarget();

	// eNX`ݒ
	GetDeviceContext()->PSSetShaderResources( 0, 1, texture->GetResourceView() );
	GetDeviceContext()->PSSetSamplers( 0, 1, texture->GetSamplerState() );

	// `
	GetDeviceContext()->DrawIndexed(4, 0, 0);
}