#include "directX11Device.h"
#include "ManageMemory.h"
#include "myWindows.h"
#include "debug.h"
#include <d3d11.h>

#pragma comment(lib,"d3d11.lib")
#ifdef _DEBUG
#pragma comment(lib,"d3dx11.lib")
#else
#pragma comment(lib,"d3dx11.lib")
#endif

#pragma comment ( lib, "dxerr.lib" )
#pragma comment( lib, "dxgi.lib" )
#pragma comment( lib, "dxguid.lib" )

//////////////////////////////////////
/// l
//////////////////////////////////
DirectX11Device::DirectX11Device() :
	device(NULL),
	deviceContext(NULL),
	swapChain(NULL),
	depthBuffer(NULL),
	depthStencilView(NULL),
	renderTargetView(NULL)
{
}
//////////////////////////////////
/// J
/// tXN[߂
///////////////////////////////////
DirectX11Device::~DirectX11Device()
{
	if( swapChain )
	{
		swapChain->SetFullscreenState( FALSE, 0 );
	}
	SAFE_RELEASE(device);
	SAFE_RELEASE(swapChain);
	SAFE_RELEASE(deviceContext);
	SAFE_RELEASE(depthBuffer);
	SAFE_RELEASE(depthStencilView);
	SAFE_RELEASE(renderTargetView);
}
////////////////////////////////////////////////////
/// ֐
/// foCXƃXbv`F[̍쐬
/// T|[g͈͂̐ݒ
/// fvXeNX`쐬
/// r[|[g쐬
////////////////////////////////////////////////
void DirectX11Device::Init(HWND hWnd)
{
	HRESULT hr;

	// foCXƃXbv`F[̍쐬
	DXGI_SWAP_CHAIN_DESC sd;
	ZeroMemory( &sd, sizeof(sd) );
	sd.BufferCount = 1;									//obNobt@̐
	sd.BufferDesc.Width = Windows::GetScreenWidth();					//obt@̕
	sd.BufferDesc.Height = Windows::GetScreenHeight();				//obt@̍
	sd.BufferDesc.Format = DXGI_FORMAT_R8G8B8A8_UNORM;	//obt@̃tH[}bg
	sd.BufferDesc.RefreshRate.Numerator = 60;			//tbV[g
	sd.BufferDesc.RefreshRate.Denominator = 1;
	sd.BufferUsage = DXGI_USAGE_RENDER_TARGET_OUTPUT;
	sd.OutputWindow = hWnd;
	sd.SampleDesc.Count = 1;
	sd.SampleDesc.Quality = 0;
	sd.Windowed = TRUE;

	TCHAR* isWindowMode = GetCommandLine();
	isWindowMode = 0;

#ifdef _DEBUG
    DWORD dwCreateDeviceFlag = 0;
	// Windows8ƃG[
    //DWORD dwCreateDeviceFlag = D3D11_CREATE_DEVICE_DEBUG;
#else
    DWORD dwCreateDeviceFlag = 0;
#endif

	// vOn[hEFÃT|[g͈͂ǂ܂łɂ邩߂
	static const DWORD dwFeatureLevelListNum = 6;
	D3D_FEATURE_LEVEL hFeatureLevelList[dwFeatureLevelListNum] = 
	{
		D3D_FEATURE_LEVEL_11_0, 
		D3D_FEATURE_LEVEL_10_1,
		D3D_FEATURE_LEVEL_10_0,
		D3D_FEATURE_LEVEL_9_3,
		D3D_FEATURE_LEVEL_9_2,
		D3D_FEATURE_LEVEL_9_1
	};
	//IDXGIAdapter* adapter;
	//IDXGIFactory::EnumAdapters( 0, &adapter );

	D3D_FEATURE_LEVEL featureLevel;
	hr =D3D11CreateDeviceAndSwapChain( 
			NULL,						// foCX̍쐬ɎgprfI A_v^[ւ̃|C^[
			D3D_DRIVER_TYPE_HARDWARE,	// 쐬foCX̎
			NULL,
			dwCreateDeviceFlag,
			hFeatureLevelList,
			dwFeatureLevelListNum,     
			D3D11_SDK_VERSION, 
			&sd, 
			&swapChain,
			&device ,
			&featureLevel,
			&deviceContext
		);
	if( FAILED(hr) )
	{
		hr =D3D11CreateDeviceAndSwapChain(
			NULL,						// foCX̍쐬ɎgprfI A_v^[ւ̃|C^[
			D3D_DRIVER_TYPE_WARP,	// 쐬foCX̎
			NULL,
			dwCreateDeviceFlag,
			hFeatureLevelList,
			dwFeatureLevelListNum,     
			D3D11_SDK_VERSION, 
			&sd, 
			&swapChain,
			&device ,
			&featureLevel,
			&deviceContext
		);
		ASSERT("foCX쐬WRAP[h");
	}

	ASSERT_HR("foCX쐬̎s", hr);
	switch( featureLevel )
	{
	case D3D_FEATURE_LEVEL_9_1:
		DebugPrintf("9_1T|[g܂\n");
		break;
	case D3D_FEATURE_LEVEL_9_2:
		DebugPrintf("9_2܂ŃT|[g܂\n");
		break;
	case D3D_FEATURE_LEVEL_9_3:
		DebugPrintf("9_3܂ŃT|[g܂\n");
		break;
	case D3D_FEATURE_LEVEL_10_0:
		DebugPrintf("10_0܂ŃT|[g܂\n");
		break;
	case D3D_FEATURE_LEVEL_10_1:
		DebugPrintf("10_1܂ŃT|[g܂\n");
		break;
	case D3D_FEATURE_LEVEL_11_0:
		DebugPrintf("11_0܂ŃT|[g܂\n");
		break;
	}
	//_[^[Qbgr[̍쐬
	ID3D11Texture2D *BackBuffer;
	hr =swapChain->GetBuffer( 0, __uuidof( ID3D11Texture2D ),(LPVOID*)&BackBuffer);   
	ASSERT_HR("obt@擾s", hr);
	hr = device->CreateRenderTargetView( BackBuffer, NULL, &renderTargetView );
	ASSERT_HR("_[^[Qbg쐬s", hr);
	BackBuffer->Release();

	// fvXeNX`̍쐬
	D3D11_TEXTURE2D_DESC depthDesc;
	ZeroMemory( &depthDesc, sizeof(depthDesc) );
	depthDesc.Width              = Windows::GetScreenWidth();
	depthDesc.Height             = Windows::GetScreenHeight();
	depthDesc.MipLevels          = 1;
	depthDesc.ArraySize          = 1;
	depthDesc.Format             = DXGI_FORMAT_D24_UNORM_S8_UINT;
	depthDesc.SampleDesc.Count   = 1;
	depthDesc.SampleDesc.Quality = 0;
	depthDesc.Usage              = D3D11_USAGE_DEFAULT;
	depthDesc.BindFlags          = D3D11_BIND_DEPTH_STENCIL;
	depthDesc.CPUAccessFlags     = 0;
	depthDesc.MiscFlags          = 0;
	hr = device->CreateTexture2D( &depthDesc, NULL, &depthBuffer );
	ASSERT_HR("fvXeNX`쐬s", hr);
	
	// DepthStencilView̍쐬
	D3D11_DEPTH_STENCIL_VIEW_DESC dsvDesc;
	ZeroMemory( &dsvDesc, sizeof(dsvDesc) );	
	dsvDesc.Format = depthDesc.Format;
	dsvDesc.ViewDimension = D3D11_DSV_DIMENSION_TEXTURE2DMS;
	dsvDesc.Texture2D.MipSlice = 0;
	hr = device->CreateDepthStencilView(depthBuffer, &dsvDesc, &depthStencilView);
	ASSERT_HR("fvXXeVr[쐬s", hr);

	// _O^[Qbgݒ肷

	SetRenderTarget();

	//r[|[g̐ݒ
	D3D11_VIEWPORT vp;
	vp.Width = static_cast<float>(Windows::GetScreenWidth());
	vp.Height = static_cast<float>(Windows::GetScreenHeight());
	vp.MinDepth = 0.0f;
	vp.MaxDepth = 1.0f;
	vp.TopLeftX = 0;
	vp.TopLeftY = 0;
	deviceContext->RSSetViewports( 1, &vp );

}
///////////////////////////////////////////////////////
/// ʂhԂ
//////////////////////////////////////////////////////
void DirectX11Device::ClearRender()
{
	float ClearColor[4] = {0,0,0,0.5f }; // NAF쐬@RGBȀ

	deviceContext->ClearRenderTargetView( renderTargetView, ClearColor );//ʃNA  
	deviceContext->ClearDepthStencilView( depthStencilView,
	    D3D11_CLEAR_DEPTH | D3D11_CLEAR_STENCIL, 1.0f, 0 );

}
//////////////////////////////////////////////////////////
///  ʂhԂ i_Owj
/////////////////////////////////////////////////////////
void DirectX11Device::ClearRender(ID3D11RenderTargetView* renderTargetView)
{
	float ClearColor[4] = {0,0,0,0 }; // NAF쐬@RGBȀ

	deviceContext->ClearRenderTargetView( renderTargetView, ClearColor );//ʃNA  
	deviceContext->ClearDepthStencilView( depthStencilView,
	    D3D11_CLEAR_DEPTH | D3D11_CLEAR_STENCIL, 1.0f, 0 );

}
//////////////////////////////////////////
/// [xlNA
///////////////////////////////////////
void DirectX11Device::ClearDepth()
{
	deviceContext->ClearDepthStencilView( depthStencilView,
	    D3D11_CLEAR_DEPTH | D3D11_CLEAR_STENCIL, 1.0f, 0 );
}
///////////////////////////////////////////////////////
/// ʓւ
//////////////////////////////////////////////////////
void DirectX11Device::Present()
{
	swapChain->Present( 0, 0 );//ʍXViobNobt@tgobt@Ɂj 
}
///////////////////////////////////////////////////////
/// tXN|ɐ؂ւ Alt+Enterł
//////////////////////////////////////////////////////
void DirectX11Device::SetFullScreen()
{
	swapChain->SetFullscreenState( TRUE, 0 );
}
//////////////////////////////////////////////
/// _OύX
/////////////////////////////////////////////
void DirectX11Device::SetRenderTarget(ID3D11RenderTargetView* renderTargetView)
{
	if( renderTargetView == NULL )
	{
		renderTargetView = this->renderTargetView;
	}
	deviceContext->OMSetRenderTargets(1, &renderTargetView,depthStencilView);
}
//////////////////////////////////////////
/// wp
/////////////////////////////////
// foCX擾
ID3D11Device* GetDevice()
{
	return DirectX11Device::GetInstance()->GetDevice();
}
// foCXReLXg擾
ID3D11DeviceContext* GetDeviceContext()
{
	return DirectX11Device::GetInstance()->GetDeviceContext();
}
// v~eBu^Cv̐ݒ
void SetPrimitiveType(D3D_PRIMITIVE_TOPOLOGY type)
{
	GetDeviceContext()->IASetPrimitiveTopology(type);
}