
#include <Shlwapi.h>

#include "fontTexture.h"
#include "debug.h"
#include "directX11Device.h"
#include "ManageMemory.h"


///////////////////////////////////////
/// l
////////////////////////////////////////
FontTexture::FontTexture() :
textureData(0)
{
	DESIGNVECTOR design;
	AddFontResourceEx(
		TEXT("APJapanesefontF.ttf"),
		FR_PRIVATE,
		&design
		);

	  
	textureData = NEW TextureData();
}
///////////////////////////////////////
/// J
///////////////////////////////////////
FontTexture::~FontTexture()
{
	DESIGNVECTOR design;
	RemoveFontResourceEx( 
		TEXT("resources/APJapanesefontF.ttf"),
		FR_PRIVATE,
		&design
	);

	// eNX`f[^̍폜
	SAFE_DELETE(textureData);
}


/////////////////////////////////////////////////
/// tHgeNX`쐬
///////////////////////////////////////////////
TextureData* FontTexture::Create( TCHAR* c, int fontsize )
{
	HRESULT hr;
   // tHg̐
	LOGFONT lf = { 
		fontsize,
		0,
		0, 
		0, 
		0, 
		0,
		0,
		0, 
		SHIFTJIS_CHARSET,
		OUT_TT_ONLY_PRECIS,
		CLIP_DEFAULT_PRECIS, 
		PROOF_QUALITY,
		FIXED_PITCH | FF_MODERN,
		TEXT("񂸂X")
	};

	HFONT hFont = CreateFontIndirect( &lf );
	if( !( hFont ) )
	{
		ASSERT2("tHg쐬s");
	}

	// foCXReLXg擾
	// foCXɃtHgȂGetGlyphOutline֐̓G[ƂȂ
	HDC hdc = GetDC( NULL );
	HFONT oldFont = (HFONT)SelectObject( hdc, hFont );

	// R[h擾
	UINT code = 0;
	#if _UNICODE
	// unicodȅꍇAR[h͒PɃChUINTϊł
		code = (UINT)*c;
	#else
	// }`oCg̏ꍇA
	// 1oCg̃R[h1oCgڂUINTϊA
	// 2oCg̃R[h[擱R[h]*256 + [R[h]ł
	if(IsDBCSLeadByte(*c))
		code = (BYTE)c[0]<<8 | (BYTE)c[1];
	else
		code = c[0];
	#endif

	// tHgrbg}bv擾
	TEXTMETRIC TM;
	GetTextMetrics( hdc, &TM );
	GLYPHMETRICS GM;
	CONST MAT2 Mat = { {0,1}, {0,0}, {0,0}, {0,1} };
	DWORD size = GetGlyphOutline( hdc, code, GGO_GRAY4_BITMAP, &GM, 0, NULL, &Mat );
	BYTE* ptr = new BYTE[ size ];
	GetGlyphOutline( hdc, code, GGO_GRAY4_BITMAP, &GM, size, ptr, &Mat );

	// foCXReLXgƃtHgnh̊J
	SelectObject( hdc, oldFont );
	DeleteObject( hFont );
	ReleaseDC( NULL, hdc );


	//--------------------------------
	// ݉\eNX`쐬
	//--------------------------------

	// CPUŏ݂łeNX`쐬

	// eNX`쐬
	D3D11_TEXTURE2D_DESC desc;
	memset( &desc, 0, sizeof( desc ) );
	desc.Width			= GM.gmCellIncX;
	desc.Height			= TM.tmHeight;
	desc.MipLevels		= 1;
	desc.ArraySize		= 1;
	desc.Format			= DXGI_FORMAT_R8G8B8A8_UNORM;	// RGBA(255,255,255,255)^Cv
	desc.SampleDesc.Count= 1;
	desc.Usage			= D3D11_USAGE_DYNAMIC;			// Ii݂邽߂̕K{j
	desc.BindFlags		= D3D11_BIND_SHADER_RESOURCE;	// VF[_\[XƂĎg
	desc.CPUAccessFlags	= D3D11_CPU_ACCESS_WRITE;	// CPUANZXďOK

	ID3D11Texture2D* tex2D;					///< 2ceNX`
	hr = GetDevice()->CreateTexture2D( &desc, 0, &tex2D );

	ASSERT_HR("tHgFeNX`쐬s", hr );

	
	D3D11_MAPPED_SUBRESOURCE hMappedResource;
	hr = GetDeviceContext()->Map( 
		tex2D,
		0,
		D3D11_MAP_WRITE_DISCARD,
		0,
		&hMappedResource );
	ASSERT_HR("eNX`}bvs", hr );
	// ŏ
	BYTE* pBits = (BYTE*)hMappedResource.pData;

	// tHg̏
	// iOfs_x, iOfs_y : oʒu()
	// iBmp_w, iBmp_h : tHgrbg}bv̕
	// Level : l̒iK (GGO_GRAY4_BITMAPȂ̂17iK)
	int iOfs_x = GM.gmptGlyphOrigin.x;
	int iOfs_y = TM.tmAscent - GM.gmptGlyphOrigin.y;
	int iBmp_w = GM.gmBlackBoxX + ( 4 - ( GM.gmBlackBoxX % 4 ) ) % 4 ;
	int iBmp_h = GM.gmBlackBoxY;
	int Level = 17;
	int x, y;
	DWORD Alpha, Color;
	memset( pBits, 0, hMappedResource.RowPitch * TM.tmHeight );
	for( y = iOfs_y; y < iOfs_y + iBmp_h; y++ )
	{
		for( x = iOfs_x; x < iOfs_x + iBmp_w; x++)
		{
			Alpha = ( 255 * ptr[ x - iOfs_x + iBmp_w * ( y - iOfs_y ) ] ) / ( Level - 1 );
			Color = 0x00ffffff | ( Alpha << 24 );
			
			memcpy( (BYTE*)pBits + hMappedResource.RowPitch * y + 4 * x, &Color, sizeof(DWORD) );
		}
	}

	GetDeviceContext()->Unmap( tex2D, 0 );

		
	textureData->SetData( c, tex2D);


	delete[] ptr;

	return textureData;

}
/////////////////////////////////////////////////
/// eNX`f[^擾
////////////////////////////////////////////////
TextureData* FontTexture::GetTexture()
{
	return textureData;
}