#include <Windows.h>
#include <crtdbg.h>

#include "myWindows.h"

#include "directX11Device.h"
#include "directX11Render2D.h"
#include "fontTexture.h"


//C֐
INT WINAPI WinMain( HINSTANCE hInst,HINSTANCE hPrevInst,LPSTR szStr, INT iCmdShow)
{			  
	_CrtSetDbgFlag( _CRTDBG_CHECK_ALWAYS_DF | _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF);

	// Windows
	Windows windows = Windows();
	MSG msg;

	// foCX
	DirectX11Device* device = DirectX11Device::GetInstance();
	device->Init(Windows::GetHWND());

	// X^CU̐ݒ
	ID3D11RasterizerState* rasterizerState;
	HRESULT hr;
	D3D11_RASTERIZER_DESC rsDesc;
	ZeroMemory( &rsDesc, sizeof( D3D11_RASTERIZER_DESC ) );
	rsDesc.CullMode = D3D11_CULL_BACK;		// JO[h
	rsDesc.FillMode = D3D11_FILL_SOLID;		// tB[h
	rsDesc.DepthClipEnable = TRUE;			// ɊÂNbsỎ
	hr = GetDevice()->CreateRasterizerState( &rsDesc, &rasterizerState );
	
	// fvXXeV̐ݒ
	ID3D11DepthStencilState* depthStencilState;	
	/// [xeXĝ݂s
	D3D11_DEPTH_STENCIL_DESC dsDesc;
	ZeroMemory( &dsDesc, sizeof( D3D11_DEPTH_STENCIL_DESC ) );
	dsDesc.DepthEnable		= TRUE;								// [xeXggp
	dsDesc.DepthWriteMask	= D3D11_DEPTH_WRITE_MASK_ALL;
	dsDesc.DepthFunc		= D3D11_COMPARISON_LESS;
	dsDesc.StencilEnable	= FALSE;							// XeVeXggp
	hr = GetDevice()->CreateDepthStencilState( &dsDesc, &depthStencilState );

	//uh`̐ݒ	   
	ID3D11BlendState* blendState;
	D3D11_BLEND_DESC BlendDesc;
	ZeroMemory( &BlendDesc, sizeof( D3D11_BLEND_DESC ) );
	BlendDesc.AlphaToCoverageEnable = FALSE;
	BlendDesc.IndependentBlendEnable = FALSE;
	BlendDesc.RenderTarget[0].BlendEnable = TRUE;
	BlendDesc.RenderTarget[0].SrcBlend = D3D11_BLEND_SRC_ALPHA;
	BlendDesc.RenderTarget[0].DestBlend = D3D11_BLEND_INV_SRC_ALPHA;
	BlendDesc.RenderTarget[0].BlendOp = D3D11_BLEND_OP_ADD;
	BlendDesc.RenderTarget[0].SrcBlendAlpha = D3D11_BLEND_ONE;
	BlendDesc.RenderTarget[0].DestBlendAlpha = D3D11_BLEND_ZERO;
	BlendDesc.RenderTarget[0].BlendOpAlpha = D3D11_BLEND_OP_ADD;
	BlendDesc.RenderTarget[0].RenderTargetWriteMask = D3D11_COLOR_WRITE_ENABLE_ALL;
	
	hr = GetDevice()->CreateBlendState( &BlendDesc, &blendState );

	FontTexture font;
	font.Create(TEXT(""), 256);

	Render2D* render2D = Render2D::GetInstance(); 
	render2D->Init();


	//EChE\
	ShowWindow(Windows::GetHWND(),SW_SHOW);
	UpdateWindow(Windows::GetHWND());
	do
	{
		if( PeekMessage(&msg,NULL,0,0,PM_REMOVE))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else
		{
			// ͏

			// XV
			


			// `揈	/////////////////////////////////////////////	  
			device->ClearRender();

			// uh
			GetDeviceContext()->OMSetBlendState( blendState, 0, 0xffffffff );
			// fvXXeV
			GetDeviceContext()->OMSetDepthStencilState( depthStencilState, 0 );  
			// X^CUݒ
			GetDeviceContext()->RSSetState( rasterizerState );

			render2D->Render( 0, 0, 256, 256, font.GetTexture() );

			device->Present();
		}
	} while(msg.message!=WM_QUIT && !((GetAsyncKeyState( VK_ESCAPE ) & 0x8000)));

	return 0;
}