/* <!-- copyright */
/*
 * aria2 - The high speed download utility
 *
 * Copyright (C) 2006 Tatsuhiro Tsujikawa
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */
/* copyright --> */
#ifndef _D_DHT_MESSAGE_TRACKER_H_
#define _D_DHT_MESSAGE_TRACKER_H_

#include "common.h"

#include <utility>
#include <deque>

#include "SharedHandle.h"
#include "a2time.h"

namespace aria2 {

class DHTMessage;
class DHTMessageCallback;
class DHTRoutingTable;
class DHTMessageFactory;
class DHTMessageTrackerEntry;
class Logger;
namespace bencode {
class BDE;
} // namespace bencode

class DHTMessageTracker {
private:
  std::deque<SharedHandle<DHTMessageTrackerEntry> > _entries;
  
  SharedHandle<DHTRoutingTable> _routingTable;

  SharedHandle<DHTMessageFactory> _factory;

  Logger* _logger;
public:
  DHTMessageTracker();

  ~DHTMessageTracker();

  void addMessage(const SharedHandle<DHTMessage>& message,
		  time_t timeout,
		  const SharedHandle<DHTMessageCallback>& callback =
		  SharedHandle<DHTMessageCallback>());

  void addMessage(const SharedHandle<DHTMessage>& message,
		  const SharedHandle<DHTMessageCallback>& callback =
		  SharedHandle<DHTMessageCallback>());

  std::pair<SharedHandle<DHTMessage>, SharedHandle<DHTMessageCallback> >
  messageArrived(const bencode::BDE& dict,
		 const std::string& ipaddr, uint16_t port);

  void handleTimeout();

  SharedHandle<DHTMessageTrackerEntry> getEntryFor(const SharedHandle<DHTMessage>& message) const;

  size_t countEntry() const;

  void setRoutingTable(const SharedHandle<DHTRoutingTable>& routingTable);

  void setMessageFactory(const SharedHandle<DHTMessageFactory>& factory);
};

} // namespace aria2

#endif // _D_DHT_MESSAGE_TRACKER_H_
