/* <!-- copyright */
/*
 * aria2 - The high speed download utility
 *
 * Copyright (C) 2006 Tatsuhiro Tsujikawa
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */
/* copyright --> */
#ifndef _D_DNS_CACHE_H_
#define _D_DNS_CACHE_H_

#include "common.h"

#include <string>
#include <map>

#include "A2STR.h"

namespace aria2 {

class DNSCache {
public:
  virtual ~DNSCache() {}

  virtual const std::string& find(const std::string& hostname) const = 0;

  virtual void put(const std::string& hostname, const std::string& ipaddr) = 0;
};

class SimpleDNSCache : public DNSCache {
private:
  std::map<std::string, std::string> _table;
public:
  SimpleDNSCache() {}

  virtual ~SimpleDNSCache() {}

  virtual const std::string& find(const std::string& hostname) const
  {
    std::map<std::string, std::string>::const_iterator i =
      _table.find(hostname);
    if(i == _table.end()) {
      return A2STR::NIL;
    } else {
      return (*i).second;
    }
  }

  virtual void put(const std::string& hostname, const std::string& ipaddr)
  {
    _table[hostname] = ipaddr;
  }
  
};

class NullDNSCache : public DNSCache {
public:
  virtual ~NullDNSCache() {}

  virtual const std::string& find(const std::string& hostname)
  {
    return A2STR::NIL;
  }

  virtual void put(const std::string& hostname, const std::string& ipaddr) {}
};

} // namespace aria2

#endif // _D_DNS_CACHE_H_
