/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.lzh;

import java.io.IOException;
import java.io.InputStream;
import jp.sourceforge.armadillo.io.ArchiveInputStream;
import jp.sourceforge.armadillo.lzh.LzhEntry;
import jp.sourceforge.armadillo.lzh.LzhHeader;
import jp.sourceforge.armadillo.lzh.LzhHuffmanDecoder;
import jp.sourceforge.armadillo.lzh.LzhMethod;
import jp.sourceforge.armadillo.lzh.LzssInputStream;

public final class LzhInputStream
extends ArchiveInputStream {
    private LzhHeader header = new LzhHeader();
    static final /* synthetic */ boolean $assertionsDisabled;

    public LzhInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public LzhEntry getNextEntry() throws IOException {
        LzhEntry lzhEntry;
        this.ensureOpen();
        if (this.remaining > 0L) {
            this.closeEntry();
        }
        if ((lzhEntry = this.header.read(this.in)) == null) {
            return null;
        }
        LzhMethod lzhMethod = new LzhMethod(lzhEntry.getMethod());
        if (lzhMethod.isCompressing()) {
            this.frontStream = new LzssInputStream(new LzhHuffmanDecoder(this.in), lzhMethod.getDictionarySize(), lzhMethod.getMatchSize(), lzhMethod.getThreshold());
            this.remaining = lzhEntry.getCompressedSize();
        } else {
            this.frontStream = this.in;
            this.remaining = lzhEntry.getSize();
        }
        return lzhEntry;
    }

    public void closeEntry() throws IOException {
        this.ensureOpen();
        while (this.remaining > 0L) {
            long l;
            if (this.frontStream == this.in) {
                l = this.skip(this.remaining);
            } else {
                l = this.in.skip(this.remaining);
                this.remaining -= l;
            }
            if (l >= 0L) continue;
            break;
        }
        if (!$assertionsDisabled && this.remaining != 0L) {
            throw new AssertionError((Object)("rest=" + this.remaining));
        }
        this.frontStream = this.in;
    }

    public void close() throws IOException {
        this.header = null;
        super.close();
    }

    static {
        $assertionsDisabled = !LzhInputStream.class.desiredAssertionStatus();
    }
}

