/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.lzh;

import java.io.FilterInputStream;
import java.io.IOException;
import jp.sourceforge.armadillo.lzh.LzhException;
import jp.sourceforge.armadillo.lzh.LzssDecoderReadable;

public final class LzssInputStream
extends FilterInputStream {
    private final int dictionarySize;
    private final int matchSize;
    private final int threshold;
    private boolean closed;
    private LzssDecoderReadable input;
    private byte[] buffer;
    private int index;
    private int limit;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LzssInputStream(LzssDecoderReadable lzssDecoderReadable, int n, int n2, int n3) {
        super(null);
        this.input = lzssDecoderReadable;
        this.dictionarySize = n;
        this.matchSize = n2;
        this.threshold = n3;
        this.buffer = new byte[n];
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("stream already closed");
        }
    }

    private void fill() throws IOException {
        int n;
        int n2;
        if (this.index > 0) {
            if (this.index == this.limit) {
                this.index = 0;
                this.limit = 0;
            } else {
                n2 = this.limit - this.index;
                System.arraycopy(this.buffer, this.index, this.buffer, 0, n2);
                this.index = 0;
                this.limit = n2;
            }
        }
        n2 = this.dictionarySize - this.limit;
        while (n2 > 0 && (n = this.input.readSymbol()) != -1) {
            if (n >= 256) {
                int n3 = (n & 0xFF) + this.threshold;
                int n4 = this.input.readOffset();
                if (!$assertionsDisabled && n3 > this.matchSize) {
                    throw new AssertionError();
                }
                int n5 = this.limit - n4 - 1;
                if (n5 < 0) {
                    n5 += this.dictionarySize;
                }
                int n6 = this.limit;
                for (int i = 0; i < n3; ++i) {
                    this.buffer[n6++] = this.buffer[n5++];
                    if (n5 == this.dictionarySize) {
                        n5 = 0;
                    }
                    if (n6 != this.dictionarySize) continue;
                    n6 = 0;
                }
                this.limit += n3;
                n2 -= n3;
                continue;
            }
            this.buffer[this.limit++] = (byte)(n & 0xFF);
            --n2;
        }
    }

    public int read() throws IOException {
        this.ensureOpen();
        try {
            if (this.limit - this.index < 1) {
                this.fill();
            }
            if (this.limit - this.index < 1) {
                return -1;
            }
            return this.buffer[++this.index] & 0xFF;
        }
        catch (RuntimeException runtimeException) {
            throw new LzhException("decode error", runtimeException);
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        try {
            int n3 = n;
            int n4 = n2;
            while (n4 > 0) {
                int n5;
                if (n4 > this.limit - this.index) {
                    this.fill();
                }
                int n6 = n4 <= (n5 = this.limit - this.index) ? n4 : n5;
                System.arraycopy(this.buffer, this.index, byArray, n3, n6);
                n3 += n6;
                n4 -= n6;
                this.index += n6;
            }
            return n2 - n4;
        }
        catch (RuntimeException runtimeException) {
            throw new LzhException("decode error", runtimeException);
        }
    }

    public long skip(long l) throws IOException {
        long l2;
        int n;
        byte[] byArray = new byte[8192];
        for (l2 = l; l2 > 0L; l2 -= (long)this.read(byArray, 0, n)) {
            n = Math.min(byArray.length, (int)l2);
        }
        return l - l2;
    }

    public void close() throws IOException {
        this.ensureOpen();
        this.input.close();
    }

    static {
        $assertionsDisabled = !LzssInputStream.class.desiredAssertionStatus();
    }
}

