package jp.sourceforge.armadillo;

import java.io.*;

import jp.sourceforge.armadillo.io.*;
import jp.sourceforge.armadillo.tar.*;

/**
 * TarA[JCoB
 */
public final class TarArchiver implements Archiver {

    private TarOutputStream tos;
    private boolean includesDirectory;

    /**
     * TarArchiver̐B
     * @param os OutputStream
     */
    public TarArchiver(OutputStream os) {
        this.tos = new TarOutputStream(os);
        this.includesDirectory = true;
    }

    /**
     * includesDirectory̐ݒB
     * @param includesDirectory includesDirectory
     */
    public void setIncludesDirectory(boolean includesDirectory) {
        this.includesDirectory = includesDirectory;
    }

    /* (overridden)
     * @see jp.sourceforge.armadillo.Archiver#addEntry(jp.sourceforge.armadillo.ArchiveEntry, java.io.File)
     */
    public void addEntry(ArchiveEntry ae, File file) throws IOException {
        if (file.isDirectory()) {
            if (!includesDirectory) {
                return;
            }
            addDirectoryEntry(ae);
        } else {
            InputStream is = new FileInputStream(file);
            try {
                ae.setSize(file.length());
                addFileEntry(ae, is);
            } finally {
                is.close();
            }
        }
        ae.setAdded(true);
    }

    /* (overridden)
     * @see jp.sourceforge.armadillo.Archiver#addEntry(jp.sourceforge.armadillo.ArchiveEntry, java.io.InputStream, long)
     */
    public void addEntry(ArchiveEntry ae, InputStream is, long length) throws IOException {
        if (ae.isDirectory()) {
            if (!includesDirectory) {
                return;
            }
            addDirectoryEntry(ae);
        } else {
            ae.setSize(length);
            addFileEntry(ae, is);
        }
        ae.setAdded(true);
    }

    /**
     * fBNgGg̒ǉB
     * @param ae ArchiveEntry
     * @throws IOException o̓G[ꍇ
     */
    private void addDirectoryEntry(ArchiveEntry ae) throws IOException {
        TarEntry entry = new TarEntry(ae.getName());
        entry.setMode(TarEntry.DEFAULT_DIR_MODE);
        entry.setLastModified(ae.getLastModified());
        tos.putNextEntry(entry);
        tos.closeEntry();
        ae.setCrc(0L);
        ae.setSize(0L);
        ae.setCompressedSize(0L);
    }

    /**
     * t@CGg̒ǉB
     * @param ae ArchiveEntry
     * @param is InputStream
     * @throws IOException o̓G[ꍇ
     */
    private void addFileEntry(ArchiveEntry ae, InputStream is) throws IOException {
        TarEntry entry = new TarEntry(ae.getName());
        entry.setLastModified(ae.getLastModified());
        entry.setSize(ae.getSize());
        tos.putNextEntry(entry);
        long size = IOUtilities.transferAll(is, tos);
        entry.setSize(size);
        tos.closeEntry();
        assert size == ae.getSize() : "file size";
        assert entry.getSize() == ae.getSize() : "file size";
        ae.setCrc(0L);
        ae.setSize(size);
        ae.setCompressedSize(size);
    }

    /* (overridden)
     * @see java.io.Closeable#close()
     */
    public void close() throws IOException {
        tos.close();
    }

}
