package jp.sourceforge.armadillo.lzh;

import java.io.*;
import java.nio.*;
import java.nio.channels.*;
import java.nio.charset.*;

import jp.sourceforge.armadillo.*;

/**
 * LZH`A[JCũwb_B
 * 
 * <p>̃Cu̓dlƂāAŏIXV̓~b`Ƒ݂ɕϊB
 * GgIuWFNgɊi[ĂԂł́A~b`ƂB</p>
 * <p>GR[fBÓAftHgłJavãftHgGR[fBOKpB
 * Zbgw肳ꂽꍇ́A̕ZbgœǂݏB</p>
 * 
 * <h3>wb_̎dlɂ</h3>
 * <p>ɋLڂẮAȎdlł͂ȂƂɒӁB</p>
 * <ul>
 * <li>wb_3(xOCPCQjAf[^̒OɒuB</li>
 * <li>l2oCg܂4oCggGfBAŊi[B</li>
 * <li>ŏIXV́ADOS`Ŋi[B</li>
 * </ul>
 */
public final class LzhHeader {

    private static final int BUFFER_SIZE = 1024;
    private static final int LEVEL_OFFSET = 20;
    private static final String ISO_8859_1 = "iso-8859-1";
    private static final String ERROR_PREFIX = "invalid header: ";

    private ByteBuffer buffer;
    private String charsetName;
    private boolean charsetEnables;

    /**
     * LzhHeader̐B
     */
    public LzhHeader() {
        this(null);
    }

    /**
     * LzhHeader̐B
     * @param charsetName Zbg
     *                    ftHgZbggpꍇ <code>null</code> w肷
     */
    public LzhHeader(String charsetName) {
        this.buffer = ByteBuffer.allocate(BUFFER_SIZE).order(ByteOrder.LITTLE_ENDIAN);
        this.charsetName = charsetName;
        this.charsetEnables = charsetName != null && Charset.isSupported(charsetName);
    }

    /**
     * wb_ǂݍށB
     * @param is InputStream
     * @return LzhEntry
     * @throws IOException o̓G[ꍇ
     */
    public LzhEntry read(InputStream is) throws IOException {
        buffer.clear();
        buffer.limit(LEVEL_OFFSET + 1);
        Channels.newChannel(is).read(buffer);
        int readLength = buffer.position();
        if (readLength == 0 || readLength == 1 && buffer.get(0) == 0x00) {
            return null;
        }
        if (readLength != LEVEL_OFFSET + 1) {
            throw new LzhException(ERROR_PREFIX + "header count = " + readLength);
        }
        int level = buffer.get(LEVEL_OFFSET);
        buffer.rewind();
        int headerLength;
        switch (level) {
            case 0:
            case 1:
                headerLength = buffer.get() + 2;
                break;
            case 2:
                headerLength = buffer.getShort();
                break;
            default:
                throw new LzhException("unsupported header level: " + level);
        }
        if (headerLength == 0) {
            return null;
        }
        assert headerLength >= 0 && headerLength < BUFFER_SIZE : "header length = " + headerLength;
        buffer.limit(headerLength);
        buffer.position(LEVEL_OFFSET + 1);
        Channels.newChannel(is).read(buffer);
        if (buffer.position() != headerLength) {
            throw new LzhException(ERROR_PREFIX + "header length = " + headerLength);
        }
        LzhEntry entry;
        switch (level) {
            case 0:
                entry = readLevel0();
                break;
            case 1:
                entry = readLevel1(is);
                break;
            case 2:
                entry = readLevel2();
                break;
            default:
                throw new IllegalStateException("unexpected state");
        }
        if (!entry.directory) {
            if (entry.name.endsWith("/") || entry.getMethod().equals("-lhd-")) {
                entry.directory = true;
            }
        }
        return entry;
    }

    /**
     * xOwb_ǂݍށB
     * @return LzhEntry
     * @throws LzhException `FbNTs̏ꍇ
     */
    private LzhEntry readLevel0() throws LzhException {
        buffer.position(1);
        LzhEntry entry = new LzhEntry();
        int checksum = buffer.get() & 0xFF;
        if (calculateChecksum(2, buffer.limit()) != checksum) {
            throw new LzhException(ERROR_PREFIX + "checksum error");
        }
        entry.method = nextString(5);
        entry.compressedSize = buffer.getInt();
        entry.size = buffer.getInt();
        entry.lastModified = Utilities.DosTime.toMilliSeconds(buffer.getInt());
        entry.type = buffer.get();
        entry.headerLevel = buffer.get();
        int nameLength = buffer.get();
        entry.name = nextString(nameLength);
        entry.crc = buffer.getShort();
        // extra
        return entry;
    }

    /**
     * xPwb_ǂݍށB
     * @param is InputStream
     * @return LzhEntry
     * @throws IOException o̓G[ꍇ 
     */
    private LzhEntry readLevel1(InputStream is) throws IOException {
        buffer.position(1);
        LzhEntry entry = new LzhEntry();
        int checksum = buffer.get() & 0xFF;
        if (calculateChecksum(2, buffer.limit()) != checksum) {
            throw new LzhException(ERROR_PREFIX + "checksum error");
        }
        entry.method = nextString(5);
        entry.compressedSize = buffer.getInt();
        entry.size = buffer.getInt();
        entry.lastModified = buffer.getInt() * 1000L;
        int fixed = buffer.get();
        assert fixed == 0x20;
        entry.headerLevel = buffer.get();
        int nameLength = buffer.get();
        entry.name = nextString(nameLength);
        entry.crc = buffer.getShort();
        entry.type = buffer.get();
        short nextSize = buffer.getShort(buffer.limit() - 2);
        while (true) {
            if (nextSize == 0) {
                break;
            }
            assert nextSize > 0;
            byte[] bytes = new byte[nextSize];
            if (is.read(bytes) != nextSize) {
                throw new LzhException(ERROR_PREFIX + "invalid extend header");
            }
            nextSize = 0;
            nextSize |= bytes[bytes.length - 1] << 8;
            nextSize |= bytes[bytes.length - 2];
        }
        return entry;
    }

    /**
     * xQwb_ǂݍށB
     * @return LzhEntry
     * @throws LzhException wb_s̏ꍇ 
     */
    private LzhEntry readLevel2() throws LzhException {
        buffer.position(2);
        LzhEntry entry = new LzhEntry();
        entry.method = nextString(5);
        entry.compressedSize = buffer.getInt();
        entry.size = buffer.getInt();
        entry.lastModified = buffer.getInt() * 1000L;
        byte reserved = buffer.get();
        assert reserved == 0x20;
        entry.headerLevel = buffer.get();
        entry.crc = buffer.getShort();
        entry.osIdentifier = (char)buffer.get();
        int warningCount = 0;
        short nextHeaderLength = 0;
        while ((nextHeaderLength = buffer.getShort()) > 0) {
            int length = nextHeaderLength - 3;
            byte identifier = buffer.get();
            buffer.mark();
            switch (identifier) {
                case 0x00: // common
                    short crc16 = buffer.getShort();
                    if (crc16 != entry.crc) {
                        throw new LzhException(ERROR_PREFIX + "bad CRC");
                    }
                    break;
                case 0x01: // file name
                case 0x02: // dir name
                    String name = nextPathString(length, '/');
                    if (identifier == 0x01 && name.length() == 0) {
                        entry.directory = true;
                    }
                    entry.name += name;
                    break;
                case 0x39: // plural disk
                    ++warningCount;
                    break;
                case 0x41: // MS Windows timestamp
                    buffer.getLong(); // ctime
                    entry.lastModified = Utilities.WindowsTime.toMilliSeconds(buffer.getLong());
                    buffer.getLong(); // atime
                    break;
                case 0x42: // MS filesize
                    entry.compressedSize = buffer.getLong();
                    entry.size = buffer.getLong();
                    break;
                case 0x54: // UNIX time_t
                    entry.lastModified = buffer.get() * 1000L;
                    break;
                case 0x3F: // comment
                case 0x40: // MS attribute
                case 0x50: // UNIX permission
                case 0x51: // UNIX uid gid
                case 0x52: // UNIX group
                case 0x53: // UNIX user
                case 0x7D: // capsule
                case 0x7E: // extended attribute
                default:
                    // ignore
            }
            buffer.reset();
            buffer.position(buffer.position() + length);
        }
        assert warningCount == 0;
        return entry;
    }

    /**
     * wb_ށB
     * @param os OutputStream
     * @param entry LzhEntry
     * @throws IOException o̓G[ꍇ
     * @throws LzhException GgesK؂ȏꍇ
     */
    public void write(OutputStream os, LzhEntry entry) throws IOException {
        if (!entry.method.matches("-l[hz][a-z0-9]-")) {
            throw new LzhException("invalid compression type: " + entry.method);
        }
        if (entry.compressedSize > Integer.MAX_VALUE) {
            throw new LzhException("too large compressed size: " + entry.compressedSize);
        }
        if (entry.size > Integer.MAX_VALUE) {
            throw new LzhException("too large size: " + entry.size);
        }
        buffer.clear();
        switch (entry.headerLevel) {
            case 0:
                writeLevel0(entry);
                break;
            case 1:
                writeLevel1(entry);
                break;
            case 2:
                writeLevel2(entry);
                break;
            default:
                throw new IllegalArgumentException(ERROR_PREFIX
                                                   + "header-level="
                                                   + entry.headerLevel);
        }
        buffer.flip();
        Channels.newChannel(os).write(buffer);
    }

    /**
     * xOwb_ށB
     * @param entry LzhEntry
     * @throws IOException o̓G[ꍇ
     */
    private void writeLevel0(LzhEntry entry) throws IOException {
        byte[] nameBytes;
        if (charsetEnables) {
            nameBytes = entry.name.getBytes(charsetName);
        } else {
            nameBytes = entry.name.getBytes();
        }
        int nameLength = nameBytes.length;
        assert nameLength > 0 && nameLength < 256;

        buffer.position(2);
        buffer.put(entry.method.getBytes(ISO_8859_1));
        buffer.putInt((int)entry.compressedSize);
        buffer.putInt((int)entry.size);
        buffer.putInt(Utilities.DosTime.getValue(entry.lastModified));
        buffer.put((byte)0x20); // type
        buffer.put((byte)0); // header level
        buffer.put((byte)nameLength);
        buffer.put(nameBytes);
        buffer.putShort(entry.crc);

        int end = buffer.position();
        int size = end - 2;
        assert size > 0 && size < 256;
        int checksum = calculateChecksum(2, end);
        buffer.put(0, (byte)size);
        buffer.put(1, (byte)checksum);
    }

    /**
     * xPwb_ށB
     * @param entry LzhEntry
     * @throws IOException o̓G[ꍇ
     */
    private void writeLevel1(LzhEntry entry) throws IOException {
        byte[] nameBytes;
        if (charsetEnables) {
            nameBytes = entry.name.getBytes(charsetName);
        } else {
            nameBytes = entry.name.getBytes();
        }
        int nameLength = nameBytes.length;
        assert nameLength > 0 && nameLength < 256;

        buffer.position(2);
        buffer.put(entry.method.getBytes(ISO_8859_1));
        buffer.putInt((int)entry.compressedSize);
        buffer.putInt((int)entry.size);
        buffer.putInt(Utilities.DosTime.getValue(entry.lastModified));
        buffer.put((byte)0x20); // type
        buffer.put((byte)1); // header level
        buffer.put((byte)nameLength);
        buffer.put(nameBytes);
        buffer.putShort(entry.crc);
        buffer.putChar('J'); // platform
        buffer.putShort((short)0); // next extend header size

        int end = buffer.position();
        int size = end - 2;
        assert size > 0 && size < 256;
        int checksum = calculateChecksum(2, end);
        buffer.put(0, (byte)size);
        buffer.put(1, (byte)checksum);
    }

    /**
     * xQwb_ށB
     * @param entry LzhEntry
     * @throws IOException o̓G[ꍇ 
     */
    private void writeLevel2(LzhEntry entry) throws IOException {
        buffer.position(2);
        buffer.put(entry.method.getBytes(ISO_8859_1));
        buffer.putInt((int)entry.compressedSize);
        buffer.putInt((int)entry.size);
        buffer.putInt((int)(entry.lastModified / 1000));
        buffer.put((byte)0x20); // type
        buffer.put((byte)2); // header level
        buffer.putShort(entry.crc);
        buffer.put((byte)'J'); // platform
        // 0x00
        buffer.putShort((short)5);
        buffer.put((byte)0x00);
        buffer.putShort((short)0);
        // header CRC
        CRC16 crc = CRC16.newInstanceForHeader();
        crc.reset();
        crc.update(buffer.array(), 0, buffer.position() + 1);
        // 0x01 0x02
        byte[] nameBytes;
        if (charsetEnables) {
            nameBytes = entry.name.getBytes(charsetName);
        } else {
            nameBytes = entry.name.getBytes();
        }
        int offset = 0;
        for (int i = 0; i < nameBytes.length; i++) {
            byte b = nameBytes[i];
            if (b == '/' || b == '\\') {
                nameBytes[i] = (byte)0xFF;
                int length = i - offset + 1;
                buffer.putShort((short)(length + 3));
                buffer.put((byte)0x02);
                buffer.put(nameBytes, offset, length);
                offset = i + 1;
            }
        }
        if (offset < nameBytes.length) {
            int length = nameBytes.length - offset;
            buffer.putShort((short)(length + 3));
            buffer.put((byte)0x01);
            buffer.put(nameBytes, offset, length);
        }
        buffer.putShort((short)0);
        // header size
        int size = buffer.position();
        if (size % 256 == 0) {
            buffer.put((byte)0x00);
            ++size;
        }
        buffer.putShort(0, (short)size);
    }

    /**
     * checksumZoB
     * @param start vZΏۂ̊Jnʒu
     * @param end vZΏۂ̏Iʒu
     * @return checksum
     */
    private int calculateChecksum(int start, int end) {
        int sum = 0;
        for (int i = start; i < end; i++) {
            sum += (buffer.get(i) & 0xFF);
        }
        return sum & 0xFF;
    }

    /**
     * ̎擾B
     * @param length ̒
     * @return 
     */
    private String nextString(int length) {
        byte[] bytes = buffer.array();
        int position = buffer.position();
        buffer.position(position + length);
        return new String(bytes, position, length);
    }

    /**
     * pX̎擾B
     * @param length ̒
     * @param delimiter f~^
     * @return pX
     */
    private String nextPathString(int length, char delimiter) {
        byte[] bytes = buffer.array();
        int position = buffer.position();
        for (int i = 0; i < length; i++) {
            if ((bytes[position + i] & 0xFF) == 0xFF) {
                bytes[position + i] = (byte)delimiter;
            }
        }
        buffer.position(position + length);
        if (charsetEnables) {
            try {
                return new String(bytes, position, length, charsetName);
            } catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            return new String(bytes, position, length);
        }
    }

}
