package jp.sourceforge.armadillo.lzh;

import java.util.*;

/**
 * LZH`̈kɎgpnt}e[uB
 */
public final class LzhHuffmanTable {

    /**
     * LZHŎgp镄̍őlB
     */
    private static final int MAX_CODE_LENGTH = 16;

    /**
     * e[uB
     */
    final int[] codeTable;

    /**
     * e[uB
     */
    final int[] codeLengthTable;

    /**
     * Huffman̐B
     * @param frequencyTable px\
     */
    private LzhHuffmanTable(int[] frequencyTable) {
        final int tableSize = frequencyTable.length;
        int[] ct = new int[tableSize];
        int[] lt = new int[tableSize];
        build(frequencyTable, ct, lt);
        this.codeTable = ct;
        this.codeLengthTable = lt;
    }

    /**
     * e[u\zB
     * @param frequencyTable px\
     * @return e[u
     */
    public static LzhHuffmanTable build(int[] frequencyTable) {
        return new LzhHuffmanTable(frequencyTable);
    }

    /**
     * e[u\zB
     * @param frequencyTable px\
     * @param tableSize e[uTCY
     * @param ct e[u
     * @param lt e[u
     */
    private void build(int[] frequencyTable, int[] ct, int[] lt) {
        int tableSize = ct.length;
        // m[hXg̐
        List q = new LinkedList();
        for (int i = 0; i < tableSize; i++) {
            int frequency = frequencyTable[i];
            if (frequency > 0) {
                q.add(new Node(i, frequency));
            }
        }
        if (q.size() <= 1) { // vf0܂1̏ꍇ
            if (q.size() == 1) {
                ct[tableSize - 1] = 1;
            }
            return;
        }
        // ؂̍\z
        int number = tableSize;
        while (q.size() > 1) {
            Collections.sort(q);
            Node node1 = (Node)q.remove(0);
            Node node2 = (Node)q.remove(0);
            q.add(new Node(number++, node1, node2));
        }
        Node root = (Node)q.get(0);
        // e[u
        createCodeLengthTable(root, tableSize, 0, lt);
        createCodeTable(ct, lt);
    }

    /**
     * e[u𐶐B
     * nt}؂ċAIɂǂĐB
     * @param node nt}؂̃m[h
     * @param size e[uTCY
     * @param codeLength 
     * @param lt e[u()
     */
    private static void createCodeLengthTable(Node node, int size, int codeLength, int[] lt) {
        int number = node.number;
        if (number < size) {
            lt[number] = codeLength;
        } else {
            createCodeLengthTable(node.left, size, codeLength + 1, lt);
            createCodeLengthTable(node.right, size, codeLength + 1, lt);
        }
    }

    /**
     * e[u畄e[u𐶐B
     * @param lt e[u
     * @return e[u
     */
    static int[] createCodeTable(int[] lt) {
        int[] ct = new int[lt.length];
        createCodeTable(ct, lt);
        return ct;
    }

    /**
     * e[u畄e[u𐶐B
     * @param ct e[u()
     * @param lt e[u
     */
    static void createCodeTable(int[] ct, int[] lt) {
        final int workSize = MAX_CODE_LENGTH + 1;
        int[] counts = new int[workSize];
        for (int i = 0; i < lt.length; i++) {
            ++counts[lt[i]];
        }
        int[] baseCodes = new int[workSize];
        for (int i = 0; i < workSize - 1; i++) {
            baseCodes[i + 1] = baseCodes[i] + counts[i + 1] << 1;
        }
        assert baseCodes[workSize - 1] == 1 << workSize : baseCodes[workSize - 1];
        for (int i = 0; i < ct.length; i++) {
            int codeLength = lt[i];
            if (codeLength > 0) {
                ct[i] = baseCodes[codeLength - 1]++;
            }
        }
    }

    /**
     * m[hB
     */
    private static final class Node implements Comparable {

        final int number;
        final int weight;

        Node left;
        Node right;

        /**
         * Node̐B
         * @param number m[hԍ
         * @param weight d
         */
        public Node(int number, int weight) {
            this.number = number;
            this.weight = weight;
            this.left = null;
            this.right = null;
        }

        /**
         * Node̐B
         * @param number m[hԍ
         * @param node1 qm[h1
         * @param node2 qm[h2
         */
        public Node(int number, Node node1, Node node2) {
            this.number = number;
            this.weight = node1.weight + node2.weight;
            this.left = node1;
            this.right = node2;
        }

        /* (overridden)
         * @see java.lang.Comparable#compareTo(java.lang.Object)
         */
        public int compareTo(Object o) {
            return compareTo((Node)o);
        }

        /**
         * rB
         * @param anotherNode rΏۃm[h
         * @return r
         */
        private int compareTo(Node anotherNode) {
            int tn;
            int an;
            if (anotherNode.weight == this.weight) {
                tn = anotherNode.number;
                an = this.number;
            } else {
                tn = this.weight;
                an = anotherNode.weight;
            }
            return tn < an ? -1 : (tn == an ? 0 : 1);
        }

        /* (overridden)
         * @see java.lang.Object#equals(java.lang.Object)
         */
        public boolean equals(Object obj) {
            return compareTo(obj) == 0;
        }

        /* (overridden)
         * @see java.lang.Object#hashCode()
         */
        public int hashCode() {
            return toString().hashCode();
        }

        /* (overridden)
         * @see java.lang.Object#toString()
         */
        public String toString() {
            return "Node:" + number + " (" + weight + ")";
        }

    }

}
