package jp.sourceforge.armadillo.lzh;

import java.io.*;

/**
 * LZSS(XCfBO)k̓̓Xg[B
 */
public final class LzssInputStream extends FilterInputStream {

    private final int dictionarySize;
    private final int matchSize;
    private final int threshold;

    private boolean closed;
    private LzssDecoderReadable input;
    private byte[] buffer;
    private int index;
    private int limit;

    /**
     * LzssInputStream̐B
     * @param input LzssDecoderReadable
     * @param dictionarySize TCY
     * @param matchSize őv
     * @param threshold 臒l
     */
    public LzssInputStream(LzssDecoderReadable input,
                           int dictionarySize,
                           int matchSize,
                           int threshold) {
        super(null);
        this.input = input;
        this.dictionarySize = dictionarySize;
        this.matchSize = matchSize;
        this.threshold = threshold;
        this.buffer = new byte[dictionarySize];
    }

    /**
     * Xg[JĂ邱ƂmFB
     * @throws IOException Xg[ɕĂꍇ
     */
    private void ensureOpen() throws IOException {
        if (closed) {
            throw new IOException("stream already closed");
        }
    }

    /**
     * obt@𖄂߂B
     * @throws IOException o̓G[ꍇ
     */
    private void fill() throws IOException {
        if (index > 0) {
            if (index == limit) {
                index = 0;
                limit = 0;
            } else {
                int length = limit - index;
                System.arraycopy(buffer, index, buffer, 0, length);
                index = 0;
                limit = length;
            }
        }
        int remaining = dictionarySize - limit;
        while (remaining > 0) {
            int code = input.readSymbol();
            if (code == -1) {
                break;
            }
            if (code >= 0x100) {
                int length = (code & 0xFF) + threshold;
                int offset = input.readOffset();
                assert length <= matchSize;
                int srcIndex = limit - offset - 1;
                if (srcIndex < 0) {
                    srcIndex += dictionarySize;
                }
                int dstIndex = limit;
                for (int i = 0; i < length; i++) {
                    buffer[dstIndex++] = buffer[srcIndex++];
                    if (srcIndex == dictionarySize) {
                        srcIndex = 0;
                    }
                    if (dstIndex == dictionarySize) {
                        dstIndex = 0;
                    }
                }
                limit += length;
                remaining -= length;
            } else {
                buffer[limit++] = (byte)(code & 0xFF);
                --remaining;
            }
        }
    }

    /* (overridden)
     * @see java.io.FilterInputStream#read()
     */
    public int read() throws IOException {
        ensureOpen();
        try {
            if (limit - index < 1) {
                fill();
            }
            if (limit - index < 1) {
                return -1;
            }
            return buffer[++index] & 0xFF;
        } catch (RuntimeException ex) {
            throw new LzhException("decode error", ex);
        }
    }

    /* (overridden)
     * @see java.io.FilterInputStream#read(byte[], int, int)
     */
    public int read(byte[] b, int off, int len) throws IOException {
        ensureOpen();
        try {
            int offset = off;
            int remaining = len;
            while (remaining > 0) {
                if (remaining > limit - index) {
                    fill();
                }
                int bufferedLength = limit - index;
                int length = (remaining <= bufferedLength) ? remaining : bufferedLength;
                java.lang.System.arraycopy(buffer, index, b, offset, length);
                offset += length;
                remaining -= length;
                index += length;
            }
            return len - remaining;
        } catch (RuntimeException ex) {
            throw new LzhException("decode error", ex);
        }
    }

    /* (overridden)
     * @see java.io.FilterInputStream#skip(long)
     */
    public long skip(long n) throws IOException {
        long remaining = n;
        byte[] bytes = new byte[8192];
        while (remaining > 0) {
            int length = Math.min(bytes.length, (int)remaining);
            remaining -= read(bytes, 0, length);
        }
        return n - remaining;
    }

    /* (overridden)
     * @see java.io.FilterInputStream#close()
     */
    public void close() throws IOException {
        ensureOpen();
        input.close();
    }

}
