#define ASCRIPT_DLL_MODULE
//-----------------------------------------------------------------------------
// AScript xml module
//-----------------------------------------------------------------------------
#include "AScript.h"
#include "Expr.h"
#include "expat.h"

AScript_BeginModule(xml)

AScript_DeclarePrivSymbol(StartElement);
AScript_DeclarePrivSymbol(EndElement);
AScript_DeclarePrivSymbol(CharacterData);
AScript_DeclarePrivSymbol(ProcessingInstruction);
AScript_DeclarePrivSymbol(Comment);
AScript_DeclarePrivSymbol(StartCdataSection);
AScript_DeclarePrivSymbol(EndCdataSection);
AScript_DeclarePrivSymbol(Default);
AScript_DeclarePrivSymbol(DefaultExpand);
AScript_DeclarePrivSymbol(ExternalEntityRef);
AScript_DeclarePrivSymbol(SkippedEntity);
//AScript_DeclarePrivSymbol(UnknownEncoding);
AScript_DeclarePrivSymbol(StartNamespaceDecl);
AScript_DeclarePrivSymbol(EndNamespaceDecl);
AScript_DeclarePrivSymbol(XmlDecl);
AScript_DeclarePrivSymbol(StartDoctypeDecl);
AScript_DeclarePrivSymbol(EndDoctypeDecl);
AScript_DeclarePrivSymbol(ElementDecl);
AScript_DeclarePrivSymbol(AttlistDecl);
AScript_DeclarePrivSymbol(EntityDecl);
AScript_DeclarePrivSymbol(NotationDecl);
AScript_DeclarePrivSymbol(NotStandalone);

AScript_DeclareClass(Parser);

class Object_Element : public Object_Dict {
public:
	Object_Element(Environment &env, const TCHAR *name, const TCHAR **atts);
	virtual String ToString(Signal sig, bool exprFlag);
};

class Object_Parser : public Object {
private:
	XML_Parser _parser;
	Environment *_pEnv;
	Signal *_pSig;
	Value _valueObj;
public:
	inline static Object_Parser *GetSelfObj(Context &context) {
		return dynamic_cast<Object_Parser *>(context.GetSelfObj());
	}
public:
	Object_Parser(Class *pClass);
	virtual ~Object_Parser();
	void Parse(Environment &env, Signal &sig, const Value &valueObj, File &file);
	const Value &GetValueObj() { return _valueObj; }
	Environment &GetEnv() { return *_pEnv; }
private:
	void CallHandler(const Symbol *pSymbol, const ValueList argList);
	static void XMLCALL StartElementHandler(void *userData, const XML_Char *name, const XML_Char **atts);
	static void XMLCALL EndElementHandler(void *userData, const XML_Char *name);
	static void XMLCALL CharacterDataHandler(void *userData, const XML_Char *s, int len);
	static void XMLCALL ProcessingInstructionHandler(void *userData, const XML_Char *target, const XML_Char *data);
	static void XMLCALL CommentHandler(void *userData, const XML_Char *data);
	static void XMLCALL StartCdataSectionHandler(void *userData);
	static void XMLCALL EndCdataSectionHandler(void *userData);
	static void XMLCALL DefaultHandler(void *userData, const XML_Char *s, int len);
	static void XMLCALL DefaultHandlerExpand(void *userData, const XML_Char *s, int len);
	static int  XMLCALL ExternalEntityRefHandler(XML_Parser p, const XML_Char *context, const XML_Char *base, const XML_Char *systemId, const XML_Char *publicId);
	static void XMLCALL SkippedEntityHandler(void *userData, const XML_Char *entityName, int isParameterEntity);
	static int  XMLCALL UnknownEncodingHandler(void *encodingHandlerData, const XML_Char *name, XML_Encoding *info);
	static void XMLCALL StartNamespaceDeclHandler(void *userData, const XML_Char *prefix, const XML_Char *uri);
	static void XMLCALL EndNamespaceDeclHandler(void *userData, const XML_Char *prefix);
	static void XMLCALL XmlDeclHandler(void *userData, const XML_Char *version, const XML_Char *encoding, int standalone);
	static void XMLCALL StartDoctypeDeclHandler(void *userData, const XML_Char *doctypeName, const XML_Char *systemId, const XML_Char *publicId, int hasInternalSubset);
	static void XMLCALL EndDoctypeDeclHandler(void *userData);
	static void XMLCALL ElementDeclHandler(void *userData, const XML_Char *name, XML_Content *model);
	static void XMLCALL AttlistDeclHandler(void *userData, const XML_Char *elname, const XML_Char *attname, const XML_Char *attType, const XML_Char *dflt, int isRequired);
	static void XMLCALL EntityDeclHandler(void *userData, const XML_Char *entityName, int isParameterEntity, const XML_Char *value, int valueLength, const XML_Char *base, const XML_Char *systemId, const XML_Char *publicId, const XML_Char *notationName);
	static void XMLCALL NotationDeclHandler(void *userData, const XML_Char *notationName, const XML_Char *base, const XML_Char *systemId, const XML_Char *publicId);
	static int  XMLCALL NotStandaloneHandler(void *userData);
};

void Object_Parser::CallHandler(const Symbol *pSymbol, const ValueList argList)
{
	const Function *pFunc = LookupFunction(pSymbol, false);
	if (pFunc != NULL) {
		Environment &env = *_pEnv;
		Signal &sig = *_pSig;
		pFunc->Eval(env, sig, Context(argList));
		if (sig.IsSignalled()) {
			::XML_StopParser(_parser, XML_FALSE);
		}
	}
}

void Object_Parser::StartElementHandler(void *userData,
								const XML_Char *name, const XML_Char **atts)
{
	Object_Parser *pObj = reinterpret_cast<Object_Parser *>(userData);
	Environment &env = pObj->GetEnv();
	ValueList valListArg;
	valListArg.push_back(pObj->GetValueObj());
	do {
		Value valueOfDict(new Object_Element(env, name, atts), VTYPE_Dict);
		valListArg.push_back(valueOfDict);
	} while (0);
	pObj->CallHandler(AScript_PrivSymbol(StartElement), valListArg);
}

void Object_Parser::EndElementHandler(void *userData, const XML_Char *name)
{
	Object_Parser *pObj = reinterpret_cast<Object_Parser *>(userData);
	ValueList valListArg;
	valListArg.push_back(pObj->GetValueObj());
	valListArg.push_back(Value(*pObj, name));
	pObj->CallHandler(AScript_PrivSymbol(EndElement), valListArg);
}

void XMLCALL Object_Parser::CharacterDataHandler(void *userData,
												const XML_Char *text, int len)
{
	Object_Parser *pObj = reinterpret_cast<Object_Parser *>(userData);
	ValueList valListArg;
	valListArg.push_back(pObj->GetValueObj());
	valListArg.push_back(Value(*pObj, text, len));
	pObj->CallHandler(AScript_PrivSymbol(CharacterData), valListArg);
}

void XMLCALL Object_Parser::ProcessingInstructionHandler(void *userData,
									const XML_Char *target, const XML_Char *data)
{
	Object_Parser *pObj = reinterpret_cast<Object_Parser *>(userData);
	ValueList valListArg;
	valListArg.push_back(pObj->GetValueObj());
	valListArg.push_back(Value(*pObj, target));
	valListArg.push_back(Value(*pObj, data));
	pObj->CallHandler(AScript_PrivSymbol(ProcessingInstruction), valListArg);
}

void XMLCALL Object_Parser::CommentHandler(void *userData, const XML_Char *data)
{
	Object_Parser *pObj = reinterpret_cast<Object_Parser *>(userData);
	ValueList valListArg;
	valListArg.push_back(pObj->GetValueObj());
	valListArg.push_back(Value(*pObj, data));
	pObj->CallHandler(AScript_PrivSymbol(Comment), valListArg);
}

void XMLCALL Object_Parser::StartCdataSectionHandler(void *userData)
{
	Object_Parser *pObj = reinterpret_cast<Object_Parser *>(userData);
	ValueList valListArg;
	valListArg.push_back(pObj->GetValueObj());
	pObj->CallHandler(AScript_PrivSymbol(StartCdataSection), valListArg);
}

void XMLCALL Object_Parser::EndCdataSectionHandler(void *userData)
{
	Object_Parser *pObj = reinterpret_cast<Object_Parser *>(userData);
	ValueList valListArg;
	valListArg.push_back(pObj->GetValueObj());
	pObj->CallHandler(AScript_PrivSymbol(EndCdataSection), valListArg);
}

void XMLCALL Object_Parser::DefaultHandler(void *userData,
											const XML_Char *text, int len)
{
	Object_Parser *pObj = reinterpret_cast<Object_Parser *>(userData);
	ValueList valListArg;
	valListArg.push_back(pObj->GetValueObj());
	valListArg.push_back(Value(*pObj, text, len));
	pObj->CallHandler(AScript_PrivSymbol(Default), valListArg);
}

void XMLCALL Object_Parser::DefaultHandlerExpand(void *userData,
											const XML_Char *text, int len)
{
	Object_Parser *pObj = reinterpret_cast<Object_Parser *>(userData);
	ValueList valListArg;
	valListArg.push_back(pObj->GetValueObj());
	valListArg.push_back(Value(*pObj, text, len));
	pObj->CallHandler(AScript_PrivSymbol(DefaultExpand), valListArg);
}

int XMLCALL Object_Parser::ExternalEntityRefHandler(XML_Parser parser,
							const XML_Char *context, const XML_Char *base,
							const XML_Char *systemId, const XML_Char *publicId)
{
	//Object_Parser *pObj = reinterpret_cast<Object_Parser *>(userData);
	//ValueList valListArg;
	//pObj->CallHandler(AScript_PrivSymbol(ExternalEntityRef), valListArg);
	return 0;
}

void XMLCALL Object_Parser::SkippedEntityHandler(void *userData,
							const XML_Char *entityName, int isParameterEntity)
{
	Object_Parser *pObj = reinterpret_cast<Object_Parser *>(userData);
	ValueList valListArg;
	valListArg.push_back(pObj->GetValueObj());
	valListArg.push_back(Value(*pObj, entityName));
	valListArg.push_back(Value(isParameterEntity != 0));
	pObj->CallHandler(AScript_PrivSymbol(SkippedEntity), valListArg);
}

int XMLCALL Object_Parser::UnknownEncodingHandler(void *encodingHandlerData,
							const XML_Char *name, XML_Encoding *info)
{
	//Object_Parser *pObj = reinterpret_cast<Object_Parser *>(encodingHandlerData);
	//ValueList valListArg;
	//pObj->CallHandler(AScript_PrivSymbol(UnknownEncoding), valListArg);
	//valListArg.push_back(Value(name));
	return 0;
}

void XMLCALL Object_Parser::StartNamespaceDeclHandler(void *userData,
							const XML_Char *prefix, const XML_Char *uri)
{
	Object_Parser *pObj = reinterpret_cast<Object_Parser *>(userData);
	ValueList valListArg;
	valListArg.push_back(pObj->GetValueObj());
	valListArg.push_back(Value(*pObj, prefix));
	valListArg.push_back(Value(*pObj, uri));
	pObj->CallHandler(AScript_PrivSymbol(StartNamespaceDecl), valListArg);
}

void XMLCALL Object_Parser::EndNamespaceDeclHandler(void *userData,
													const XML_Char *prefix)
{
	Object_Parser *pObj = reinterpret_cast<Object_Parser *>(userData);
	ValueList valListArg;
	valListArg.push_back(pObj->GetValueObj());
	valListArg.push_back(Value(*pObj, prefix));
	pObj->CallHandler(AScript_PrivSymbol(EndNamespaceDecl), valListArg);
}

void XMLCALL Object_Parser::XmlDeclHandler(void *userData,
				const XML_Char *version, const XML_Char *encoding, int standalone)
{
	Object_Parser *pObj = reinterpret_cast<Object_Parser *>(userData);
	ValueList valListArg;
	valListArg.push_back(pObj->GetValueObj());
	valListArg.push_back(Value(*pObj, version));
	valListArg.push_back(Value(*pObj, encoding));
	if (standalone >= 0) {
		valListArg.push_back(Value(standalone != 0));
	}
	pObj->CallHandler(AScript_PrivSymbol(XmlDecl), valListArg);
}

void XMLCALL Object_Parser::StartDoctypeDeclHandler(void *userData,
				const XML_Char *doctypeName, const XML_Char *systemId,
				const XML_Char *publicId, int hasInternalSubset)
{
	Object_Parser *pObj = reinterpret_cast<Object_Parser *>(userData);
	ValueList valListArg;
	valListArg.push_back(pObj->GetValueObj());
	valListArg.push_back(Value(*pObj, doctypeName));
	valListArg.push_back(Value(*pObj, systemId));
	valListArg.push_back(Value(*pObj, publicId));
	valListArg.push_back(Value(hasInternalSubset != 0));
	pObj->CallHandler(AScript_PrivSymbol(StartDoctypeDecl), valListArg);
}

void XMLCALL Object_Parser::EndDoctypeDeclHandler(void *userData)
{
	Object_Parser *pObj = reinterpret_cast<Object_Parser *>(userData);
	ValueList valListArg;
	valListArg.push_back(pObj->GetValueObj());
	pObj->CallHandler(AScript_PrivSymbol(EndDoctypeDecl), valListArg);
}

void XMLCALL Object_Parser::ElementDeclHandler(void *userData,
									const XML_Char *name, XML_Content *model)
{
	Object_Parser *pObj = reinterpret_cast<Object_Parser *>(userData);
	ValueList valListArg;
	valListArg.push_back(pObj->GetValueObj());
	valListArg.push_back(Value(*pObj, name));
	//**************************
	// todo
	//**************************
	pObj->CallHandler(AScript_PrivSymbol(ElementDecl), valListArg);
}

void XMLCALL Object_Parser::AttlistDeclHandler(void *userData,
			const XML_Char *elemName, const XML_Char *attName,
			const XML_Char *attType, const XML_Char *defaultValue, int isRequired)
{
	Object_Parser *pObj = reinterpret_cast<Object_Parser *>(userData);
	ValueList valListArg;
	valListArg.push_back(pObj->GetValueObj());
	valListArg.push_back(Value(*pObj, elemName));
	valListArg.push_back(Value(*pObj, attName));
	valListArg.push_back(Value(*pObj, attType));
	valListArg.push_back(Value(*pObj, defaultValue));
	valListArg.push_back(Value(isRequired != 0)); // #IMPLIED / #REQUIRED
	pObj->CallHandler(AScript_PrivSymbol(AttlistDecl), valListArg);
}

void XMLCALL Object_Parser::EntityDeclHandler(void *userData,
			const XML_Char *entityName, int isParameterEntity,
			const XML_Char *value, int valueLength, const XML_Char *base,
			const XML_Char *systemId, const XML_Char *publicId,
			const XML_Char *notationName)
{
	Object_Parser *pObj = reinterpret_cast<Object_Parser *>(userData);
	ValueList valListArg;
	valListArg.push_back(pObj->GetValueObj());
	valListArg.push_back(Value(*pObj, entityName));
	valListArg.push_back(Value(isParameterEntity != 0));
	valListArg.push_back(Value(*pObj, value, valueLength));
	valListArg.push_back(Value(*pObj, base));
	valListArg.push_back(Value(*pObj, systemId));
	valListArg.push_back(Value(*pObj, publicId));
	valListArg.push_back(Value(*pObj, notationName));
	pObj->CallHandler(AScript_PrivSymbol(EntityDecl), valListArg);
}

void XMLCALL Object_Parser::NotationDeclHandler(void *userData,
			const XML_Char *notationName, const XML_Char *base,
			const XML_Char *systemId, const XML_Char *publicId)
{
	Object_Parser *pObj = reinterpret_cast<Object_Parser *>(userData);
	ValueList valListArg;
	valListArg.push_back(pObj->GetValueObj());
	valListArg.push_back(Value(*pObj, notationName));
	valListArg.push_back(Value(*pObj, base));
	valListArg.push_back(Value(*pObj, systemId));
	valListArg.push_back(Value(*pObj, publicId));
	pObj->CallHandler(AScript_PrivSymbol(NotationDecl), valListArg);
}

int XMLCALL Object_Parser::NotStandaloneHandler(void *userData)
{
	Object_Parser *pObj = reinterpret_cast<Object_Parser *>(userData);
	ValueList valListArg;
	valListArg.push_back(pObj->GetValueObj());
	pObj->CallHandler(AScript_PrivSymbol(NotStandalone), valListArg);
	return 0;
}

Object_Parser::Object_Parser(Class *pClass) : Object(pClass), _pEnv(NULL), _pSig(NULL)
{
	_parser = ::XML_ParserCreate(NULL);
	::XML_SetUserData(_parser, this);
	::XML_SetStartElementHandler(_parser,			StartElementHandler);
	::XML_SetEndElementHandler(_parser,				EndElementHandler);
	::XML_SetCharacterDataHandler(_parser,			CharacterDataHandler);
	::XML_SetProcessingInstructionHandler(_parser,	ProcessingInstructionHandler);
	::XML_SetCommentHandler(_parser,				CommentHandler);
	::XML_SetStartCdataSectionHandler(_parser,		StartCdataSectionHandler);
	::XML_SetEndCdataSectionHandler(_parser,		EndCdataSectionHandler);
	::XML_SetDefaultHandler(_parser,				DefaultHandler);
	::XML_SetDefaultHandlerExpand(_parser,			DefaultHandlerExpand);
	::XML_SetExternalEntityRefHandler(_parser,		ExternalEntityRefHandler);
	::XML_SetSkippedEntityHandler(_parser,			SkippedEntityHandler);
	::XML_SetUnknownEncodingHandler(_parser,		UnknownEncodingHandler, this);
	::XML_SetStartNamespaceDeclHandler(_parser,		StartNamespaceDeclHandler);
	::XML_SetEndNamespaceDeclHandler(_parser,		EndNamespaceDeclHandler);
	::XML_SetXmlDeclHandler(_parser,				XmlDeclHandler);
	::XML_SetStartDoctypeDeclHandler(_parser,		StartDoctypeDeclHandler);
	::XML_SetEndDoctypeDeclHandler(_parser,			EndDoctypeDeclHandler);
	::XML_SetElementDeclHandler(_parser,			ElementDeclHandler);
	::XML_SetAttlistDeclHandler(_parser,			AttlistDeclHandler);
	::XML_SetEntityDeclHandler(_parser,				EntityDeclHandler);
	::XML_SetNotationDeclHandler(_parser,			NotationDeclHandler);
	::XML_SetNotStandaloneHandler(_parser,			NotStandaloneHandler);
}

Object_Parser::~Object_Parser()
{
	::XML_ParserFree(_parser);
}

void Object_Parser::Parse(Environment &env, Signal &sig,
											const Value &valueObj, File &file)
{
	const size_t bytesToRead = 1024 * 8;
	_pEnv = &env, _pSig = &sig, _valueObj = valueObj;
	for (;;) {
		char *buff = reinterpret_cast<char *>(::XML_GetBuffer(_parser, bytesToRead));
		size_t bytes = file.Read(buff, bytesToRead);
		int doneFlag = (bytes < bytesToRead);
		XML_Status status = ::XML_Parse(_parser, buff, bytes, doneFlag);
		if (sig.IsSignalled()) {
			break;
		} else if (status == XML_STATUS_ERROR) {
			sig.SetError(ERR_IOError, _T("expat: %s at line %lu\n"),
					::XML_ErrorString(XML_GetErrorCode(_parser)),
					::XML_GetCurrentLineNumber(_parser));
			break;
		} else if (status != XML_STATUS_OK) {
			break;
		}
		if (doneFlag) break;
	}
	_pEnv = NULL, _pSig = NULL;
}

// p = parser() {block}
AScript_DeclareFunctionBegin(parser)
	SymbolSet _symbolsAcceptable;
AScript_DeclareFunctionEnd(parser)
{
	SetMode(RSLTMODE_Normal, MAP_Off);
	DeclareBlock(OCCUR_Once);
	_symbolsAcceptable.Insert(AScript_PrivSymbol(StartElement));
	_symbolsAcceptable.Insert(AScript_PrivSymbol(EndElement));
	_symbolsAcceptable.Insert(AScript_PrivSymbol(CharacterData));
	_symbolsAcceptable.Insert(AScript_PrivSymbol(ProcessingInstruction));
	_symbolsAcceptable.Insert(AScript_PrivSymbol(Comment));
	_symbolsAcceptable.Insert(AScript_PrivSymbol(StartCdataSection));
	_symbolsAcceptable.Insert(AScript_PrivSymbol(EndCdataSection));
	_symbolsAcceptable.Insert(AScript_PrivSymbol(Default));
	_symbolsAcceptable.Insert(AScript_PrivSymbol(DefaultExpand));
	_symbolsAcceptable.Insert(AScript_PrivSymbol(ExternalEntityRef));
	_symbolsAcceptable.Insert(AScript_PrivSymbol(SkippedEntity));
	//_symbolsAcceptable.Insert(AScript_PrivSymbol(UnknownEncoding));
	_symbolsAcceptable.Insert(AScript_PrivSymbol(StartNamespaceDecl));
	_symbolsAcceptable.Insert(AScript_PrivSymbol(EndNamespaceDecl));
	_symbolsAcceptable.Insert(AScript_PrivSymbol(XmlDecl));
	_symbolsAcceptable.Insert(AScript_PrivSymbol(StartDoctypeDecl));
	_symbolsAcceptable.Insert(AScript_PrivSymbol(EndDoctypeDecl));
	_symbolsAcceptable.Insert(AScript_PrivSymbol(ElementDecl));
	_symbolsAcceptable.Insert(AScript_PrivSymbol(AttlistDecl));
	_symbolsAcceptable.Insert(AScript_PrivSymbol(EntityDecl));
	_symbolsAcceptable.Insert(AScript_PrivSymbol(NotationDecl));
	_symbolsAcceptable.Insert(AScript_PrivSymbol(NotStandalone));
}

AScript_ImplementFunction(parser)
{
	Object_Parser *pObj = new Object_Parser(AScript_Class(Parser, env));
	if (!pObj->BuildContent(env, sig, context.GetBlock(), &_symbolsAcceptable)) {
		Object::Delete(pObj);
		return Value::Null;
	}
	return Value(pObj, VTYPE_Object);
}

// p = element(name:string, %attrs) {block?}
AScript_DeclareFunction(element)
{
	SetMode(RSLTMODE_Normal, MAP_Off);
	DeclareArg(env, _T("name"), VTYPE_String);
	DeclareDictArg(_T("attrs"));
	DeclareBlock(OCCUR_ZeroOrOnce);
}

AScript_ImplementFunction(element)
{
	Object_Element *pObjElem = new Object_Element(env, context.GetString(0), NULL);
	foreach_const (ValueDict, iter, context.GetDict()) {
		pObjElem->GetDict()[iter->first] = iter->second;
	}
	const Expr_Block *pExprBlock = context.GetBlock();
	if (pExprBlock != NULL) {
		Environment envLister(&env, ENVTYPE_Lister);
		Value valueRaw = pExprBlock->GetExprList().ExecForList(envLister, sig, false);
		if (sig.IsSignalled() || !valueRaw.IsList()) return Value::Null;
		Value result;
		ValueList &valList = result.InitAsList(env);
		foreach_const (ValueList, pValue, valueRaw.GetList()) {
			valList.push_back(*pValue);
		}
		pObjElem->AssignValue(AScript_Symbol(children), result, false);
	}
	return Value(pObjElem, VTYPE_Dict);
}

// str = xml.Parser#parse(input)
AScript_DeclareMethod(Parser, parse)
{
	SetMode(RSLTMODE_Normal, MAP_Off);
	DeclareArg(env, _T("obj"), VTYPE_AnyType);
	DeclareArg(env, _T("input"), VTYPE_AnyType);
}

AScript_ImplementMethod(Parser, parse)
{
	Object_Parser *pObj = Object_Parser::GetSelfObj(context);
	if (context.IsFile(1)) {
		pObj->Parse(env, sig, context.GetValue(0), context.GetFile(1));
	}
	return Value::Null;
}

// implementation of class Parser
AScript_ImplementClass(Parser)
{
	AScript_AssignMethod(Parser, parse);
}

// Module entry
AScript_ModuleEntry()
{
	AScript_RealizePrivSymbol(StartElement);
	AScript_RealizePrivSymbol(EndElement);
	AScript_RealizePrivSymbol(CharacterData);
	AScript_RealizePrivSymbol(ProcessingInstruction);
	AScript_RealizePrivSymbol(Comment);
	AScript_RealizePrivSymbol(StartCdataSection);
	AScript_RealizePrivSymbol(EndCdataSection);
	AScript_RealizePrivSymbol(Default);
	AScript_RealizePrivSymbol(DefaultExpand);
	AScript_RealizePrivSymbol(ExternalEntityRef);
	AScript_RealizePrivSymbol(SkippedEntity);
	//AScript_RealizePrivSymbol(UnknownEncoding);
	AScript_RealizePrivSymbol(StartNamespaceDecl);
	AScript_RealizePrivSymbol(EndNamespaceDecl);
	AScript_RealizePrivSymbol(XmlDecl);
	AScript_RealizePrivSymbol(StartDoctypeDecl);
	AScript_RealizePrivSymbol(EndDoctypeDecl);
	AScript_RealizePrivSymbol(ElementDecl);
	AScript_RealizePrivSymbol(AttlistDecl);
	AScript_RealizePrivSymbol(EntityDecl);
	AScript_RealizePrivSymbol(NotationDecl);
	AScript_RealizePrivSymbol(NotStandalone);
	AScript_AssignFunction(parser);
	AScript_AssignFunction(element);
}

Object_Element::Object_Element(Environment &env, const TCHAR *name, const TCHAR **atts) :
												Object_Dict(env.GetClass_Dict())
{
	AssignValue(AScript_Symbol(name), Value(env, name), false);
	if (atts != NULL) {
		ValueDict &valDict = GetDict();
		for (const TCHAR **p = atts; *p != NULL && *(p + 1) != NULL; p += 2) {
			valDict[Value(env, *p)] = Value(env, *(p + 1));
		}
	}
	Value valueOfList;
	valueOfList.InitAsList(env);
	AssignValue(AScript_Symbol(children), valueOfList, false);
}

String Object_Element::ToString(Signal sig, bool exprFlag)
{
	String str;
	String name = _T("");
	do {
		const Value *pValue = LookupValue(AScript_Symbol(name), false);
		if (pValue != NULL) name = pValue->ToString(sig, false);
	} while (0);
	str += _T("<");
	str += name;
	foreach_const (ValueDict, iter, GetDict()) {
		str += _T(" ");
		str += iter->first.ToString(sig, false);
		str += _T("=\"");
		str += iter->second.ToString(sig, false);
		str += _T("\"");
	}
	do {
		const Value *pValChildren = LookupValue(AScript_Symbol(children), false);
		if (pValChildren == NULL || !pValChildren->IsList() ||
										pValChildren->GetList().empty()) {
			str += _T(" />");
		} else {
			str += _T(">\n");
			foreach_const (ValueList, pValue, pValChildren->GetList()) {
				str += pValue->ToString(sig, false);
				str += _T("\n");
			}
			str += _T("</");
			str += name;
			str += _T(">");
		}
	} while (0);
	return str;
}

AScript_EndModule(xml)

AScript_DLLModuleEntry(xml)
