//#define ASCRIPT_DLL_MODULE
//-----------------------------------------------------------------------------
// AScript time module
//-----------------------------------------------------------------------------
#include "Module_time.h"

AScript_BeginModule(time)

// time.sleep(secs)
AScript_DeclareFunction(sleep)
{
	DeclareArg(env, _T("secs"), VTYPE_Number);
}

#if defined(WINVER)
AScript_ImplementFunction(sleep)
{
	::Sleep(static_cast<DWORD>(context.GetNumber(0) * 1000));
	return Value::Null;
}
#else
AScript_ImplementFunction(sleep)
{
	return Value::Null;
}
#endif

// time.gmtime(t?:number)
AScript_DeclareFunction(gmtime)
{
	//DeclareArg(env, _T("t"), VTYPE_Number, false, OCCUR_ZeroOrOnce);
}

#if defined(WINVER)
AScript_ImplementFunction(gmtime)
{
	if (context.IsNumber(0)) {
		return Value::Null;
	} else {
		SYSTEMTIME st;
		::GetSystemTime(&st);
		Object_DateTime *pObj = new Object_DateTime(env.GetClass_DateTime(), DateTime(st));
		return Value(pObj, VTYPE_DateTime);
	}
}
#else
AScript_ImplementFunction(gmtime)
{
	return Value::Null;
}
#endif

// time.localtime(t?:number)
AScript_DeclareFunction(localtime)
{
	//DeclareArg(env, _T("t"), VTYPE_Number, false, OCCUR_ZeroOrOnce);
}

#if defined(WINVER)
AScript_ImplementFunction(localtime)
{
	if (context.IsNumber(0)) {
		return Value::Null;
	} else {
		SYSTEMTIME st;
		::GetLocalTime(&st);
		Object_DateTime *pObj = new Object_DateTime(env.GetClass_DateTime(), DateTime(st));
		return Value(pObj, VTYPE_DateTime);
	}
}
#else
AScript_ImplementFunction(localtime)
{
	return Value::Null;
}
#endif

// time.clock()
AScript_DeclareFunction(clock)
{
}

#if defined(WINVER)
AScript_ImplementFunction(clock)
{
	LARGE_INTEGER freq, counter;
	if (::QueryPerformanceFrequency(&freq) && ::QueryPerformanceCounter(&counter)) {
		return Value(static_cast<Number>(counter.QuadPart) / freq.QuadPart);
	} else {
		return Value(static_cast<Number>(::GetTickCount()) / 1000);
	}
}
#else
AScript_ImplementFunction(sleep)
{
	return Value::Null;
}
#endif

AScript_ModuleEntry()
{
	AScript_AssignFunction(sleep);
	AScript_AssignFunction(gmtime);
	AScript_AssignFunction(localtime);
	AScript_AssignFunction(clock);
}

AScript_EndModule(time)

AScript_DLLModuleEntry(time)
