#ifndef __OBJECT_STRING_H__
#define __OBJECT_STRING_H__

#include "Common.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_String / Object_String
//-----------------------------------------------------------------------------
class Class_String : public Class {
public:
	Class_String(Class *pClassSuper, const Symbol *pSymbol);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class Object_String : public Object {
public:
	inline static Object_String *GetSelfObj(Context &context) {
		return dynamic_cast<Object_String *>(context.GetSelfObj());
	}
private:
	String _str;
public:
	inline Object_String(Class *pClass) : Object(pClass) {}
	inline Object_String(Class *pClass, const TCHAR *str) : Object(pClass), _str(str) {}
	inline Object_String(Class *pClass, const TCHAR *str, size_t len) :
											Object(pClass), _str(str, len) {}
	Object_String(const Object_String &obj);
	virtual ~Object_String();
	virtual Object *Clone() const;
	virtual String ToString(Signal sig, bool exprFlag);
	inline const TCHAR *GetString() const { return _str.c_str(); }
	static Value Split(Environment &env, Signal sig, const Function *pFunc,
		ContextBase &contextBase, const TCHAR *str, const TCHAR *sep, int maxNumber);
};

}

#endif
