#ifndef __OBJECT_FUNCTION_H__
#define __OBJECT_FUNCTION_H__

#include "Common.h"
#include "Expr.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_Function / Object_Function
//-----------------------------------------------------------------------------
class Class_Function : public Class {
public:
	Class_Function(Class *pClassSuper, const Symbol *pSymbol);
	void Prepare();
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class Object_Function : public Object {
public:
	inline static Object_Function *GetSelfObj(Context &context) {
		return dynamic_cast<Object_Function *>(context.GetSelfObj());
	}
public:
	class Constructor : public ConstructorBase {
	public:
		Constructor(Environment &env, const TCHAR *name = AScript_Symbol(Function)->GetName());
		virtual Value DoEval(Environment &env, Signal sig, Context &context) const;
	};
	class ExprVisitorEx : public ExprVisitor {
	private:
		SymbolSet _symbolSet;
		ExprList &_exprList;
	public:
		inline ExprVisitorEx(ExprList &exprList) : _exprList(exprList) {}
		virtual bool Visit(const Expr *pExpr);
	};
private:
	Function *_pFunc;
public:
	inline Object_Function(Class *pClass, Function *pFunc) :
									Object(pClass), _pFunc(pFunc) {}
	inline Object_Function(const Object_Function &obj) :
									Object(obj), _pFunc(obj._pFunc->IncRef()) {}
	~Object_Function();
	virtual bool IsFunction() const;
	virtual Object *Clone() const;
	inline Function *GetFunction() { return _pFunc; }
	inline const Function *GetFunction() const { return _pFunc; }
	virtual String ToString(Signal sig, bool exprFlag);
	virtual Value Call(Environment &env, Signal sig,
							Value &value, ContextExpr &contextExpr);
};

}

#endif
