#ifndef __CODEC_JAPANESE_H__
#define __CODEC_JAPANESE_H__

#include "Codec.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Codec_Encoder_CP932
//-----------------------------------------------------------------------------
class Codec_Encoder_CP932 : public Codec_Encoder {
public:
	inline Codec_Encoder_CP932(bool processEOLFlag) : Codec_Encoder(processEOLFlag) {}
	virtual Result FeedUTF32(unsigned long codeUTF32, char &chConv);
};

//-----------------------------------------------------------------------------
// Codec_Encoder_EUCJP
//-----------------------------------------------------------------------------
class Codec_Encoder_EUCJP : public Codec_Encoder {
public:
	inline Codec_Encoder_EUCJP(bool processEOLFlag) : Codec_Encoder(processEOLFlag) {}
	virtual Result FeedUTF32(unsigned long codeUTF32, char &chConv);
};

//-----------------------------------------------------------------------------
// Codec_Decoder_CP932
//-----------------------------------------------------------------------------
class Codec_Decoder_CP932 : public Codec_Decoder {
private:
	unsigned short _codeCP932;
public:
	inline Codec_Decoder_CP932(bool processEOLFlag) :
						Codec_Decoder(processEOLFlag), _codeCP932(0x0000) {}
	virtual Result FeedChar(char ch, char &chConv);
};

//-----------------------------------------------------------------------------
// Codec_Decoder_EUCJP
//-----------------------------------------------------------------------------
class Codec_Decoder_EUCJP : public Codec_Decoder {
private:
	unsigned short _codeEUCJP;
public:
	inline Codec_Decoder_EUCJP(bool processEOLFlag) :
						Codec_Decoder(processEOLFlag), _codeEUCJP(0x0000) {}
	virtual Result FeedChar(char ch, char &chConv);
};

}

#endif
