//
// Object_Matrix
//

#include "Object_Matrix.h"
#include "Expr.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Object_Matrix
//-----------------------------------------------------------------------------
Object *Object_Matrix::Clone() const
{
	return new Object_Matrix(*this);
}

// Constructor: Matrix() {block?}
Object_Matrix::Constructor::Constructor(Environment &env, const char *name) :
							ConstructorBase(name, env.GetClass_Matrix())
{
	DeclareBlock(OCCUR_ZeroOrOnce);
}

Value Object_Matrix::Constructor::DoEval(Environment &env, Signal sig, Context &context) const
{
	Environment envLister(&env, ENVTYPE_Lister);
	const Expr_Block *pExprBlock = context.GetBlock();
	Value result = pExprBlock->GetExprList().ExecForList(envLister, sig, false);
	if (!result.GetList().CheckMatrix(NULL, NULL)) {
		sig.SetError(ERR_ValueError, "invalid matrix initialization");
		return Value::Null;
	}
	return result;
}

//-----------------------------------------------------------------------------
// AScript interfaces for Object_Matrix
//-----------------------------------------------------------------------------


// Assignment
Class_Matrix::Class_Matrix(Class *pClassSuper, const Symbol *pSymbol) :
												Class_List(pClassSuper, pSymbol)
{
}

Object *Class_Matrix::CreateDescendant(Environment &env, Signal sig, Class *pClass)
{
	return new Object_Matrix((pClass == NULL)? this : pClass);
}

}
