#ifndef __MODULE_H__
#define __MODULE_H__

#include "Object.h"

namespace AScript {

class Environment;
class Signal;

//-----------------------------------------------------------------------------
// Module
//-----------------------------------------------------------------------------
class Module : public ObjectBase {
protected:
	const Symbol *_pSymbol;
private:
	inline Module(const Module &module) :
					ObjectBase(module), _pSymbol(module._pSymbol) {}
public:
	inline Module(Environment *pEnvOuter, const Symbol *pSymbol) :
					ObjectBase(pEnvOuter, ENVTYPE_Module), _pSymbol(pSymbol) {}
	virtual ~Module();
	inline Module *IncRef() { _cntRef++; return this; }
	inline const char *GetName() const { return _pSymbol->GetName(); }
	inline bool IsAnonymous() const {
		return _pSymbol->IsIdentical(AScript_Symbol(_anonymous_));
	}
	inline void SetSymbol(const Symbol *pSymbol) { _pSymbol = pSymbol; }
	inline const Symbol *GetSymbol() const { return _pSymbol; }
	virtual bool IsModule() const;
	virtual Module *Clone() const;
	virtual String ToString(Signal sig, bool exprFlag);
};

void InitModule(Environment &env);

}

//-----------------------------------------------------------------------------
// Macros and functions to implement modules
//-----------------------------------------------------------------------------
#define AScript_BeginModuleHeader(name) \
namespace AScript {														\
namespace ModuleNS_##name {												\
void MixIn(Environment &env, Signal sig);								\
Module *Import(Environment &env, Signal sig);

#define AScript_EndModuleHeader(name) \
} }

#define AScript_BeginModule(name) \
namespace AScript { \
namespace ModuleNS_##name {

#define AScript_EndModule(name) \
Module *Import(Environment &env, Signal sig)					\
{																\
	Module *pModule = new Module(&env, Symbol::Add(#name));		\
	MixIn(*pModule, sig);										\
	if (sig.IsSignalled()) {									\
		delete pModule;											\
		return NULL;											\
	}															\
	env.AssignModule(pModule);									\
	return pModule;												\
}																\
void Terminate(Module *pModule)									\
{																\
	_Terminate(pModule);										\
}																\
}}

#define AScript_BeginSubModule(name) \
namespace SubModuleNS_##name {

#define AScript_EndSubModule(name) \
}

#define AScript_AssignSubModule(name) \
do {																	\
	Module *pModule = new Module(&env, Symbol::Add(#name));				\
	SubModuleNS_##name::MixIn(*pModule, sig);							\
	if (sig.IsSignalled()) {											\
		delete pModule;													\
		return;															\
	}																	\
	env.AssignModule(pModule);											\
} while (0)

#if defined(ASCRIPT_MODULE_SEPARATED)
#define AScript_DLLModuleEntry(name) \
extern "C" DLLEXPORT													\
void AScriptModuleEntry(AScript::Environment &env, AScript::Signal sig)	\
{																		\
	AScript::InitModule(env);											\
	AScript::ModuleNS_##name::MixIn(env, sig);							\
}																		\
extern "C" DLLEXPORT													\
void AScriptModuleTerminate(AScript::Module *pModule)					\
{																		\
	AScript::ModuleNS_##name::Terminate(pModule);						\
}
#else // ASCRIPT_MODULE_INTEGRATED
#define AScript_DLLModuleEntry(name) \
namespace AScript {														\
namespace ModuleNS_##name {												\
struct Integrator {														\
	inline Integrator() {												\
		Environment::IntegrateModule(#name, MixIn, Terminate);			\
	}																	\
	static Integrator integrator;										\
};																		\
Integrator Integrator::integrator;										\
} }
#endif

#define AScript_ModuleEntry() \
void MixIn(Environment &env, Signal sig)

#define AScript_ModuleTerminate() \
void _Terminate(Module *pModule)

#endif
