//
// Object_DateTime
//

#include "Object_DateTime.h"
#include "Expr.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Object_DateTime
//-----------------------------------------------------------------------------
Object_DateTime::Object_DateTime(const Object_DateTime &obj) :
										Object(obj), _dateTime(obj._dateTime)
{
}

Object_DateTime::~Object_DateTime()
{
}

Object *Object_DateTime::Clone() const
{
	return new Object_DateTime(*this);
}

String Object_DateTime::ToString(Signal sig, bool exprFlag)
{
	String str;
	str += "<DateTime:";
	str += _dateTime.ToString("%Y-%m-%d %H:%M:%S");
	str += ">";
	return str;
}

//-----------------------------------------------------------------------------
// AScript interfaces for Object_DateTime
//-----------------------------------------------------------------------------
// DateTime#year()
AScript_DeclareMethod(DateTime, year)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(DateTime, year)
{
	const DateTime &dateTime = Object_DateTime::GetSelfObj(context)->GetDateTime();
	return Value(static_cast<Number>(dateTime.GetYear()));
}

// DateTime#month()
AScript_DeclareMethod(DateTime, month)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(DateTime, month)
{
	const DateTime &dateTime = Object_DateTime::GetSelfObj(context)->GetDateTime();
	return Value(static_cast<Number>(dateTime.GetMonth()));
}

// DateTime#day()
AScript_DeclareMethod(DateTime, day)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(DateTime, day)
{
	const DateTime &dateTime = Object_DateTime::GetSelfObj(context)->GetDateTime();
	return Value(static_cast<Number>(dateTime.GetDay()));
}

// DateTime#hour()
AScript_DeclareMethod(DateTime, hour)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(DateTime, hour)
{
	const DateTime &dateTime = Object_DateTime::GetSelfObj(context)->GetDateTime();
	return Value(static_cast<Number>(dateTime.GetHour()));
}

// DateTime#min()
AScript_DeclareMethod(DateTime, min)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(DateTime, min)
{
	const DateTime &dateTime = Object_DateTime::GetSelfObj(context)->GetDateTime();
	return Value(static_cast<Number>(dateTime.GetMinute()));
}

// DateTime#sec()
AScript_DeclareMethod(DateTime, sec)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(DateTime, sec)
{
	const DateTime &dateTime = Object_DateTime::GetSelfObj(context)->GetDateTime();
	return Value(static_cast<Number>(dateTime.GetSecond()));
}

// DateTime#usec()
AScript_DeclareMethod(DateTime, usec)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(DateTime, usec)
{
	const DateTime &dateTime = Object_DateTime::GetSelfObj(context)->GetDateTime();
	return Value(static_cast<Number>(dateTime.GetUSec()));
}

// DateTime#wday()
// 0:Sun, 1:Mon, 2:Tue, 3:Wed, 4:Thu, 5:Fri, 6:Sat
AScript_DeclareMethod(DateTime, wday)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(DateTime, wday)
{
	const DateTime &dateTime = Object_DateTime::GetSelfObj(context)->GetDateTime();
	return Value(static_cast<Number>(dateTime.GetDayOfWeek()));
}

// DateTime#yday()
AScript_DeclareMethod(DateTime, yday)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(DateTime, yday)
{
	const DateTime &dateTime = Object_DateTime::GetSelfObj(context)->GetDateTime();
	return Value(static_cast<Number>(dateTime.GetDayOfYear() + 1));
}

// DateTime#format(format:string)
AScript_DeclareMethod(DateTime, format)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "format", VTYPE_String);
}

AScript_ImplementMethod(DateTime, format)
{
	const DateTime &dateTime = Object_DateTime::GetSelfObj(context)->GetDateTime();
	return Value(env, dateTime.ToString(context.GetString(0)).c_str());
}

Class_DateTime::Class_DateTime(Class *pClassSuper) : Class(pClassSuper)
{
	AScript_AssignMethod(DateTime, year);
	AScript_AssignMethod(DateTime, month);
	AScript_AssignMethod(DateTime, day);
	AScript_AssignMethod(DateTime, hour);
	AScript_AssignMethod(DateTime, min);
	AScript_AssignMethod(DateTime, sec);
	AScript_AssignMethod(DateTime, usec);
	AScript_AssignMethod(DateTime, wday);
	AScript_AssignMethod(DateTime, yday);
	AScript_AssignMethod(DateTime, format);
}

Object *Class_DateTime::CreateDescendant(Environment &env, Signal sig, Class *pClass)
{
	ERROREND(env, "this function must not be called");
	return NULL;
}

}
