//
// Object_FileStat
//

#include "Object_FileStat.h"
#include "Object_DateTime.h"
#include "Expr.h"

namespace AScript {

Object_FileStat::Object_FileStat(const Object_FileStat &obj) :
										Object(obj), _fileStat(obj._fileStat)
{
}

Object_FileStat::~Object_FileStat()
{
}

Object *Object_FileStat::Clone() const
{
	return new Object_FileStat(*this);
}

String Object_FileStat::ToString(Signal sig, bool exprFlag)
{
	String str;
	str += "<FileStat:";
	str += _fileStat.GetPathName();
	str += ">";
	return str;
}

// FileStat#pathname()
AScript_DeclareMethod(FileStat, pathname)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, pathname)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(env, fileStat.GetPathName());
}

// FileStat#basename()
AScript_DeclareMethod(FileStat, basename)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, basename)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(env, File::ExtractBaseName(fileStat.GetPathName()).c_str());
}

// FileStat#dirname()
AScript_DeclareMethod(FileStat, dirname)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, dirname)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(env, File::ExtractDirName(fileStat.GetPathName()).c_str());
}

// FileStat#size()
AScript_DeclareMethod(FileStat, size)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, size)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(static_cast<Number>(fileStat.GetSize()));
}

// FileStat#uid()
AScript_DeclareMethod(FileStat, uid)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, uid)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(static_cast<Number>(fileStat.GetUid()));
}

// FileStat#gid()
AScript_DeclareMethod(FileStat, gid)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, gid)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(static_cast<Number>(fileStat.GetGid()));
}

// FileStat#atime()
AScript_DeclareMethod(FileStat, atime)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, atime)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	Object_DateTime *pObj =
			new Object_DateTime(env.LookupClass(VTYPE_DateTime), fileStat.GetATime());
	return Value(pObj, VTYPE_DateTime);
}

// FileStat#mtime()
AScript_DeclareMethod(FileStat, mtime)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, mtime)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	Object_DateTime *pObj =
			new Object_DateTime(env.LookupClass(VTYPE_DateTime), fileStat.GetMTime());
	return Value(pObj, VTYPE_DateTime);
}

// FileStat#ctime()
AScript_DeclareMethod(FileStat, ctime)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, ctime)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	Object_DateTime *pObj =
			new Object_DateTime(env.LookupClass(VTYPE_DateTime), fileStat.GetCTime());
	return Value(pObj, VTYPE_DateTime);
}

// FileStat#isdir()
AScript_DeclareMethod(FileStat, isdir)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, isdir)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(fileStat.IsDir());
}

// FileStat#ischr()
AScript_DeclareMethod(FileStat, ischr)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, ischr)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(fileStat.IsChr());
}

// FileStat#isblk()
AScript_DeclareMethod(FileStat, isblk)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, isblk)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(fileStat.IsBlk());
}

// FileStat#isreg()
AScript_DeclareMethod(FileStat, isreg)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, isreg)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(fileStat.IsReg());
}

// FileStat#isfifo()
AScript_DeclareMethod(FileStat, isfifo)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, isfifo)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(fileStat.IsFifo());
}

// FileStat#islnk()
AScript_DeclareMethod(FileStat, islnk)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, islnk)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(fileStat.IsLnk());
}

// FileStat#issock()
AScript_DeclareMethod(FileStat, issock)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, issock)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(fileStat.IsSock());
}

Class_FileStat::Class_FileStat(Class *pClassSuper) : Class(pClassSuper)
{
	AScript_AssignMethod(FileStat, pathname);
	AScript_AssignMethod(FileStat, basename);
	AScript_AssignMethod(FileStat, dirname);
	AScript_AssignMethod(FileStat, size);
	AScript_AssignMethod(FileStat, uid);
	AScript_AssignMethod(FileStat, gid);
	AScript_AssignMethod(FileStat, atime);
	AScript_AssignMethod(FileStat, mtime);
	AScript_AssignMethod(FileStat, ctime);
	AScript_AssignMethod(FileStat, isdir);
	AScript_AssignMethod(FileStat, ischr);
	AScript_AssignMethod(FileStat, isblk);
	AScript_AssignMethod(FileStat, isreg);
	AScript_AssignMethod(FileStat, isfifo);
	AScript_AssignMethod(FileStat, islnk);
	AScript_AssignMethod(FileStat, issock);
}

Object *Class_FileStat::CreateDescendant(Environment &env, Signal sig, Class *pClass)
{
	ERROREND(env, "this function must not be called");
	return NULL;
}

}
