//
// Object_Environment
//

#include "Object_Environment.h"
#include "Expr.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Object_Environment
//-----------------------------------------------------------------------------
Object_Environment::Object_Environment(const Object_Environment &obj) :
													Object(obj), _env(obj._env)
{
}

Object_Environment::~Object_Environment()
{
}

Object *Object_Environment::Clone() const
{
	return new Object_Environment(*this);
}

String Object_Environment::ToString(Signal sig, bool exprFlag)
{
	String str;
	EnvType envType = _env.GetTopFrame().GetType();
	str += "<environment:";
	str += GetEnvTypeName(envType);
	str += ">";
	return str;
}

//-----------------------------------------------------------------------------
// AScript interfaces for Object_Environment
//-----------------------------------------------------------------------------
// environment#eval(expr:expr):map
AScript_DeclareMethod(Environment, eval)
{
	SetMode(RSLTMODE_Normal, MAP_On, FLAT_Off);
	DeclareArg(env, "expr", VTYPE_Expr);
}

AScript_ImplementMethod(Environment, eval)
{
	Object_Environment *pSelf = Object_Environment::GetSelfObj(context);
	return context.GetExpr(0)->Exec(pSelf->GetEnv(), sig);
}

// environment#lookup(symbol:symbol, escalate:boolean => true):map
AScript_DeclareMethod(Environment, lookup)
{
	SetMode(RSLTMODE_Normal, MAP_On, FLAT_Off);
	DeclareArg(env, "symbol", VTYPE_Symbol);
	DeclareArg(env, "escalate", VTYPE_Boolean, OCCUR_Once, false,
													new Expr_Value(true));
}

AScript_ImplementMethod(Environment, lookup)
{
	Object_Environment *pSelf = Object_Environment::GetSelfObj(context);
	const Value *pValue = pSelf->GetEnv().LookupValue(
								context.GetSymbol(0), context.GetBoolean(1));
	if (pValue == NULL) return Value::Null;
	return *pValue;
}

// assignment
Class_Environment::Class_Environment(Environment &env) :
										Class(env.LookupClass(VTYPE_Object))
{
	AScript_AssignMethod(Environment, eval);
	AScript_AssignMethod(Environment, lookup);
}

Object *Class_Environment::CreateDescendant(Environment &env, Signal sig, Class *pClass)
{
	ERROREND(env, "this function must not be called");
	return NULL;
}

}
