//
// Object_TimeDelta
//

#include "Object_TimeDelta.h"
#include "Expr.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Object_TimeDelta
//-----------------------------------------------------------------------------
Object_TimeDelta::Object_TimeDelta(const Object_TimeDelta &obj) :
										Object(obj), _timeDelta(obj._timeDelta)
{
}

Object_TimeDelta::~Object_TimeDelta()
{
}

Object *Object_TimeDelta::Clone() const
{
	return new Object_TimeDelta(*this);
}

String Object_TimeDelta::ToString(Signal sig, bool exprFlag)
{
	String str;
	str += "<timedelta:";
	str += _timeDelta.ToString("%Y-%m-%d %H:%M:%S");
	str += ">";
	return str;
}

//-----------------------------------------------------------------------------
// AScript interfaces for Object_TimeDelta
//-----------------------------------------------------------------------------
// timedelta#days()
AScript_DeclareMethod(TimeDelta, days)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	SetHelp(
	"Returns a number of days in the timedelta object. The value is between\n"
	"-999999999 and 999999999.");
}

AScript_ImplementMethod(TimeDelta, days)
{
	const TimeDelta &timeDelta = Object_TimeDelta::GetSelfObj(context)->GetTimeDelta();
	return Value(static_cast<Number>(timeDelta.GetDays()));
}

// timedelta#secs()
AScript_DeclareMethod(TimeDelta, secs)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	SetHelp(
	"Returns a number of seconds in the timedelta object. The value is between\n"
	"0 and (3600 * 24 - 1).");
}

AScript_ImplementMethod(TimeDelta, secs)
{
	const TimeDelta &timeDelta = Object_TimeDelta::GetSelfObj(context)->GetTimeDelta();
	return Value(static_cast<Number>(timeDelta.GetSecsRaw()));
}

// timedelta#usecs()
AScript_DeclareMethod(TimeDelta, usecs)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	SetHelp(
	"Returns a number of micro seconds in the timedelta object. The value is between\n"
	"0 and 999999.");
}

AScript_ImplementMethod(TimeDelta, usecs)
{
	const TimeDelta &timeDelta = Object_TimeDelta::GetSelfObj(context)->GetTimeDelta();
	return Value(static_cast<Number>(timeDelta.GetUSecs()));
}

// assignment
Class_TimeDelta::Class_TimeDelta(Environment &env) : Class(env.LookupClass(VTYPE_Object))
{
	AScript_AssignMethod(TimeDelta, days);
	AScript_AssignMethod(TimeDelta, secs);
	AScript_AssignMethod(TimeDelta, usecs);
}

Object *Class_TimeDelta::CreateDescendant(Environment &env, Signal sig, Class *pClass)
{
	ERROREND(env, "this function must not be called");
	return NULL;
}

}
