//-----------------------------------------------------------------------------
// AScript test module
//-----------------------------------------------------------------------------
#include <ascript.h>

AScript_BeginModule(test)

//-----------------------------------------------------------------------------
// AScript module functions: test
//-----------------------------------------------------------------------------
// test.skeleton()
AScript_DeclareFunction(skeleton)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementFunction(skeleton)
{
	return Value::Null;
}

// result = test.adder(num1:number, num2:number)
AScript_DeclareFunction(adder)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "num1", VTYPE_Number);
	DeclareArg(env, "num2", VTYPE_Number);
}

AScript_ImplementFunction(adder)
{
	return Value(context.GetNumber(0) + context.GetNumber(1));
}

// result = test.adder2(num1:number, num2:number):map
// automapping version of adder(). see differences in their implementations.
AScript_DeclareFunction(adder2)
{
	SetMode(RSLTMODE_Normal, MAP_On, FLAT_Off);
	DeclareArg(env, "num1", VTYPE_Number);
	DeclareArg(env, "num2", VTYPE_Number);
}

AScript_ImplementFunction(adder2)
{
	return Value(context.GetNumber(0) + context.GetNumber(1));
}

// Module entry
AScript_ModuleEntry()
{
	// value assignment
	AScript_AssignValue(foo, Value(env, "a value in test module"));
	// function assignment
	AScript_AssignFunction(skeleton);
	AScript_AssignFunction(adder);
	AScript_AssignFunction(adder2);
}

AScript_ModuleTerminate()
{
}

AScript_EndModule(test)

AScript_RegisterModule(test)
