#include <wx/wx.h>
#include <wx/textctrl.h>
#include <ascript.h>

//-----------------------------------------------------------------------------
// App
//-----------------------------------------------------------------------------
class App : public wxApp {
public:
	virtual bool OnInit();
};

//-----------------------------------------------------------------------------
// Frame
//-----------------------------------------------------------------------------
class Frame : public wxFrame {
public:
	Frame();
private:
	DECLARE_EVENT_TABLE()
};

//-----------------------------------------------------------------------------
// Panel
//-----------------------------------------------------------------------------
class Panel : public wxPanel {
private:
	enum {
		ID_BTN_HelloWorld = 1000,
	};
public:
	Panel(wxWindow *pParent, wxWindowID id);
private:
	DECLARE_EVENT_TABLE()
	void OnButton_HelloWorld(wxCommandEvent &event);
};

//-----------------------------------------------------------------------------
// App
//-----------------------------------------------------------------------------
IMPLEMENT_APP(App)

bool App::OnInit()
{
	Frame *pFrame = new Frame();
	pFrame->Show();
	SetTopWindow(pFrame);
	return true;
}

//-----------------------------------------------------------------------------
// Frame
//-----------------------------------------------------------------------------
Frame::Frame() : wxFrame(NULL, wxID_ANY, wxT("HelloWorld"))
{
	new Panel(this, wxID_ANY);
}

BEGIN_EVENT_TABLE(Frame, wxFrame)
END_EVENT_TABLE()

//-----------------------------------------------------------------------------
// Panel
//-----------------------------------------------------------------------------
Panel::Panel(wxWindow *pParent, wxWindowID id) :
		wxPanel(pParent, id, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL)
{
	wxBoxSizer *pOuterBox = new wxBoxSizer(wxVERTICAL);
	SetSizer(pOuterBox);
	wxBoxSizer *pVBox = new wxBoxSizer(wxVERTICAL);
	pOuterBox->Add(pVBox, wxSizerFlags(1).Expand());
	do {
		wxButton *pCtrl = new wxButton(this, ID_BTN_HelloWorld, wxT("Hello World"));
		pVBox->Add(pCtrl, wxSizerFlags(0).Expand());
	} while (0);
	do {
		wxTextCtrl *pCtrl = new wxTextCtrl(this, wxID_ANY, wxT(""),
				wxDefaultPosition, wxDefaultSize, wxWANTS_CHARS | wxTE_MULTILINE);
		pVBox->Add(pCtrl, wxSizerFlags(1).Expand());
	} while (0);
}

BEGIN_EVENT_TABLE(Panel, wxPanel)
	EVT_BUTTON(ID_BTN_HelloWorld, Panel::OnButton_HelloWorld)
END_EVENT_TABLE()

void Panel::OnButton_HelloWorld(wxCommandEvent &event)
{
	AScript::Signal sig;
	AScript::EnvironmentRoot env(sig, 0, NULL);
	AScript::Expr *pExpr = AScript::Parser().ParseFile(env, sig, "test.az");
	if (sig.IsSignalled()) {
		::wxMessageBox(sig.GetErrString(), wxT("HelloWorld"));
		return;
	}
	pExpr->Exec(env, sig);
	AScript::Expr::Delete(pExpr);
	if (sig.IsSignalled()) {
		::wxMessageBox(sig.GetErrString(), wxT("HelloWorld"));
		return;
	}
}
