#include "Symbol.h"
#include "String.h"
#include "Value.h"
#include "Function.h"

extern "C" {
#include "SFMT.h"
}

//-----------------------------------------------------------------------------
// Heap access functions
//-----------------------------------------------------------------------------
#if defined(HAVE_WINDOWS_H)
// malloc() and free() don't work correctly when they're used across
// Windows' DLL boundary. see KB190799 in MSDN.
DLLEXPORT void *operator new (size_t bytes)
{
	return ::LocalAlloc(LMEM_FIXED, bytes);
}

DLLEXPORT void operator delete (void *p)
{
	::LocalFree(p);
}
#endif

namespace AScript {

const int MAX_STACK_LEVEL = 20000;

void SFMT_init_gen_rand(unsigned long seed)
{
	::init_gen_rand(seed);	// initialize random generator SFMT
}

bool IsBigEndian()
{
	long num = 0x12345678;
	return *reinterpret_cast<char *>(&num) == 0x12;
}

const char *GetVersion()
{
	return VERSION;
}

int RandomNumberGenerator::operator()(int n)
{
	return static_cast<int>(::genrand_real2() * n);
}

}
