//-----------------------------------------------------------------------------
// AScript sys module
//-----------------------------------------------------------------------------
#include "Module.h"
#include "Object_File.h"
#include "Object_DateTime.h"

AScript_BeginModule(sys)

//-----------------------------------------------------------------------------
// AScript module functions: sys
//-----------------------------------------------------------------------------
// sys.echo()
AScript_DeclareFunction(echo)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "flag", VTYPE_Boolean);
}

AScript_ImplementFunction(echo)
{
	env.SetEchoFlag(context.GetBoolean(0));
	return Value::Null;
}

// sys.exit(status?:number)
AScript_DeclareFunction(exit)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "status", VTYPE_Number, OCCUR_ZeroOrOnce);
}

AScript_ImplementFunction(exit)
{
	::exit(context.IsNumber(0)? context.GetInt(0) : 0);
	return Value::Null;
}

// listcodec()
AScript_DeclareFunction(listcodec)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementFunction(listcodec)
{
	Value result;
	ValueList &valList = result.InitAsList(env);
	foreach_const (CodecFactory::List, ppCodecFactory, CodecFactory::GetList()) {
		const CodecFactory *pCodecFactory = *ppCodecFactory;
		valList.push_back(Value(env, pCodecFactory->GetName()));
	}
	return result;
}

AScript_ModuleEntry()
{
	// value assignment
	do {
		Value value;
		ValueList &valList = value.InitAsList(env);
		valList.push_back(Value(env, "."));
#if defined(HAVE_WINDOWS_H)
		valList.push_back(Value(env, File::GetBaseDir().c_str()));
		do {
			String dirName(File::GetBaseDir());
			dirName += File::Separator;
			dirName += "DLLs";
			valList.push_back(Value(env, dirName.c_str()));
		} while (0);
		do {
			String dirName(File::GetBaseDir());
			dirName += File::Separator;
			dirName += "Lib";
			valList.push_back(Value(env, dirName.c_str()));
		} while (0);
#endif
		const char *str = ::getenv("ASCRIPTPATH");
		if (str != NULL) {
			SplitPathList(env, str, valList);
		}
		AScript_AssignValue(path, value);
	} while (0);
	do {
		Value value;
		value.InitAsFile(env)->GetFile().OpenStdin();
		AScript_AssignValue(stdin, value);
	} while (0);
	do {
		Value value;
		value.InitAsFile(env)->GetFile().OpenStdout();
		AScript_AssignValue(stdout, value);
	} while (0);
	do {
		Value value;
		value.InitAsFile(env)->GetFile().OpenStderr();
		AScript_AssignValue(stderr, value);
	} while (0);
	AScript_AssignValue(ps1, Value(env, ">>> "));
	AScript_AssignValue(ps2, Value(env, "... "));
	// function assignment
	AScript_AssignFunction(echo);
	AScript_AssignFunction(exit);
	AScript_AssignFunction(listcodec);
}

AScript_ModuleTerminate()
{
}

void Setup(Module *pModule, Signal sig, int argc, const char *argv[])
{
	Environment &env = *pModule;
	Value value;
	ValueList &valList = value.InitAsList(env);
	if (argc >= 2 && argv != NULL) {
		valList.push_back(Value(env, File::MakeAbsPath(argv[1], NULL).c_str()));
		for (int i = 2; i < argc; i++) {
			const char *arg = argv[i];
			valList.push_back(Value(env, arg));
		}
	}
	env.AssignValue(Symbol::Add("argv"), value, false);
	env.GetGlobal()->_pModule_sys = pModule;
}

AScript_EndModule(sys)

AScript_RegisterModule(sys)
