#ifndef __OBJECT_DATETIME_H__
#define __OBJECT_DATETIME_H__

#include "Object.h"
#include "Environment.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_DateTime / Object_DateTime
//-----------------------------------------------------------------------------
class DLLEXPORT Class_DateTime : public Class {
public:
	Class_DateTime(Environment &env);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class DLLEXPORT Object_DateTime : public Object {
public:
	inline static Object_DateTime *GetSelfObj(Context &context) {
		return dynamic_cast<Object_DateTime *>(context.GetSelfObj());
	}
private:
	DateTime _dateTime;
public:
	inline Object_DateTime(Class *pClass, const DateTime &dateTime) :
									Object(pClass), _dateTime(dateTime) {}
	Object_DateTime(const Object_DateTime &obj);
	virtual ~Object_DateTime();
	virtual Object *Clone() const;
	virtual String ToString(Signal sig, bool exprFlag);
	inline const DateTime &GetDateTime() const { return _dateTime; }
};

}

#endif
