#==============================================================================
# Makefile for Borland C++
#==============================================================================
# cl /wd4996 /EHsc AScript.cpp Main.cpp

VERSION = build015

SRCS_LIB = \
Common.cpp Algorithm.cpp Codec.cpp Codec_Japanese.cpp Codec_ISO8859.cpp \
Symbol.cpp String.cpp Signal.cpp Formatter.cpp Option.cpp \
File.cpp DateTime.cpp Value.cpp Iterator.cpp Declaration.cpp Environment.cpp \
Function.cpp Object.cpp Module.cpp OAL.cpp \
Object_Function.cpp Object_String.cpp Object_Bytes.cpp \
Object_List.cpp Object_Matrix.cpp Object_Dict.cpp \
Object_File.cpp Object_FileStat.cpp Object_DateTime.cpp Object_TimeDelta.cpp \
Object_Expr.cpp Object_Environment.cpp Object_Error.cpp Object_URI.cpp \
Object_Struct.cpp Object_Custom.cpp Object_Iterator.cpp Object_Semaphore.cpp \
Operator.cpp Expr.cpp Parser.cpp

OBJS_EXTRA = sfmt.obj

LIB_ASCRIPT = ascript.lib
LIB_ASCRIPT_S = ascript_s.lib
DLL_ASCRIPT = ..\ascript.dll

SRCS_LIB = $(SRCS_LIB) \
Module_math.cpp \
Module_builtins.cpp \
Module_os.cpp \
Module_sys.cpp \
Module_time.cpp \
Module_string.cpp

SVNREPO = https://svn.sourceforge.jp/svnroot/ascript

ZIPSRCFILE_PRE = ascript-$(VERSION)-src
ZIPBINFILE = ascript-$(VERSION)-win32.zip

DISTFILES = \
AScript\DLLs\*.azd AScript\ascript.exe AScript\ascript.dll \
AScript\lib\*.az \
AScript\test\test-*.az \
AScript\test\50records-en.csv AScript\test\50records-jp.csv \
AScript\test\temperature.txt \
AScript\test\chars-cp932.txt \
AScript\test\chars-eucjp.txt \
AScript\test\chars-utf8-jp.txt \
AScript\test\testall.bat AScript\test\result\test-*.sample.txt \
AScript\sample\*.az AScript\sample\*.bat

ONIGDIR = onig-5.9.2
EXPATDIR = expat-2.0.1
SQLITEDIR = sqlite-amalgamation-3_6_23_1
SFMTDIR = SFMT-src-1.3.3

LDFLAGS = -tWC -tWM -M -q \
-L$(MAKEDIR)\..\Lib -L$(MAKEDIR)\..\Lib\psdk -lS:10000000

LDFLAGS_DLL = -tWD -tWM -M -q \
-L$(MAKEDIR)\..\Lib -L$(MAKEDIR)\..\Lib\psdk -lS:10000000

CFLAGS = \
-q -I$(MAKEDIR)\..\Include -w-8057 -w-8004 \
-DVERSION=\"$(VERSION)\" \
-I$(ONIGDIR) \
-I$(SFMTDIR) \
-I$(EXPATDIR)\lib \
-I$(SQLITEDIR)

#CFLAGS = $(CFLAGS) -DDEBUG_ASCRIPT

LIBS = $(ONIGDIR)\onig_s.lib
LIBS = $(LIBS) $(EXPATDIR)\bcb5\release\libexpats_mtd.lib

.cpp.obj:
	@bcc32 $(CFLAGS) -c -o$*.obj $<

all: all-stub

#------------------------------------------------------------------------------
SRCS_MODULE_CSV = Module_csv.cpp
!if 0
TGT_MODULE_CSV = ..\DLLs\csv.azd
TGT_MODULES = $(TGT_MODULES) $(TGT_MODULE_CSV)
$(TGT_MODULE_CSV): $(SRCS_MODULE_CSV:.cpp=.obj) $(LIB_ASCRIPT)
	@bcc32 $(LDFLAGS_DLL) -e$@ $** $(LIBS)
	@echo $@ was generated
Module_csv.obj: Module_csv.cpp
	@bcc32 $(CFLAGS) -DASCRIPT_MODULE_SEPARATED -c Module_csv.cpp
!else
SRCS_INTEGRATED_MODULE = $(SRCS_INTEGRATED_MODULE) $(SRCS_MODULE_CSV)
!endif

#------------------------------------------------------------------------------
SRCS_MODULE_NET = Module_net.cpp
!if 0
TGT_MODULE_NET = ..\DLLs\net.azd
TGT_MODULES = $(TGT_MODULES) $(TGT_MODULE_NET)
$(TGT_MODULE_NET): $(SRCS_MODULE_NET:.cpp=.obj) $(LIB_ASCRIPT)
	@bcc32 $(LDFLAGS_DLL) -e$@ $** $(LIBS)
	@echo $@ was generated
Module_net.obj: Module_net.cpp
	@bcc32 $(CFLAGS) -DASCRIPT_MODULE_SEPARATED -c Module_net.cpp
!else
SRCS_INTEGRATED_MODULE = $(SRCS_INTEGRATED_MODULE) $(SRCS_MODULE_NET)
!endif

#------------------------------------------------------------------------------
SRCS_MODULE_RE = Module_re.cpp
!if 1
TGT_MODULE_RE = ..\DLLs\re.azd
TGT_MODULES = $(TGT_MODULES) $(TGT_MODULE_RE)
$(TGT_MODULE_RE): $(SRCS_MODULE_RE:.cpp=.obj) $(LIB_ASCRIPT)
	@bcc32 $(LDFLAGS_DLL) -e$@ $** $(LIBS)
	@echo $@ was generated
Module_re.obj: Module_re.cpp
	@bcc32 $(CFLAGS) -DASCRIPT_MODULE_SEPARATED -c Module_re.cpp
!else
SRCS_INTEGRATED_MODULE = $(SRCS_INTEGRATED_MODULE) $(SRCS_MODULE_RE)
!endif

#------------------------------------------------------------------------------
SRCS_MODULE_XML = Module_xml.cpp
!if 1
TGT_MODULE_XML = ..\DLLs\xml.azd
TGT_MODULES = $(TGT_MODULES) $(TGT_MODULE_XML)
$(TGT_MODULE_XML): $(SRCS_MODULE_XML:.cpp=.obj) $(LIB_ASCRIPT)
	@bcc32 $(LDFLAGS_DLL) -e$@ $** $(LIBS)
	@echo $@ was generated
Module_xml.obj: Module_xml.cpp
	@bcc32 $(CFLAGS) -DASCRIPT_MODULE_SEPARATED -c Module_xml.cpp
!else
SRCS_INTEGRATED_MODULE = $(SRCS_INTEGRATED_MODULE) $(SRCS_MODULE_XML)
!endif

#------------------------------------------------------------------------------
SRCS_MODULE_CANVAS = Module_canvas.cpp
!if 1
TGT_MODULE_CANVAS = ..\DLLs\canvas.azd
TGT_MODULES = $(TGT_MODULES) $(TGT_MODULE_CANVAS)
$(TGT_MODULE_CANVAS): $(SRCS_MODULE_CANVAS:.cpp=.obj) $(LIB_ASCRIPT)
	@bcc32 $(LDFLAGS_DLL) -e$@ $** $(LIBS)
	@echo $@ was generated
Module_canvas.obj: Module_canvas.cpp
	@bcc32 $(CFLAGS) -DASCRIPT_MODULE_SEPARATED -c Module_canvas.cpp
!else
SRCS_INTEGRATED_MODULE = $(SRCS_INTEGRATED_MODULE) $(SRCS_MODULE_CANVAS)
!endif

#------------------------------------------------------------------------------
SRCS_MODULE_WIN32OLE = Module_win32ole.cpp
!if 1
TGT_MODULE_WIN32OLE = ..\DLLs\win32ole.azd
TGT_MODULES = $(TGT_MODULES) $(TGT_MODULE_WIN32OLE)
$(TGT_MODULE_WIN32OLE): $(SRCS_MODULE_WIN32OLE:.cpp=.obj) $(LIB_ASCRIPT)
	@bcc32 $(LDFLAGS_DLL) -e$@ $** $(LIBS)
	@echo $@ was generated
Module_win32ole.obj: Module_win32ole.cpp
	@bcc32 $(CFLAGS) -DASCRIPT_MODULE_SEPARATED -c Module_win32ole.cpp
!else
SRCS_INTEGRATED_MODULE = $(SRCS_INTEGRATED_MODULE) $(SRCS_MODULE_WIN32OLE)
!endif

#------------------------------------------------------------------------------
SRCS_MODULE_SQLITE = Module_sqlite3.cpp
!if 1
TGT_MODULE_SQLITE = ..\DLLs\sqlite3.azd
TGT_MODULES = $(TGT_MODULES) $(TGT_MODULE_SQLITE)
$(TGT_MODULE_SQLITE): $(SRCS_MODULE_SQLITE:.cpp=.obj) sqlite3.obj $(LIB_ASCRIPT)
	@bcc32 $(LDFLAGS_DLL) -e$@ $** $(LIBS)
	@echo $@ was generated
Module_sqlite3.obj: Module_sqlite3.cpp
	@bcc32 $(CFLAGS) -DASCRIPT_MODULE_SEPARATED -c Module_sqlite3.cpp
!else
SRCS_INTEGRATED_MODULE = $(SRCS_INTEGRATED_MODULE) $(SRCS_MODULE_SQLITE)
!endif

sqlite3.obj: $(SQLITEDIR)\sqlite3.c
	@bcc32 -I$(MAKEDIR)\..\Include -q -w-8004 -w-8065 -c -o$@ $**

#------------------------------------------------------------------------------
SRCS_MODULE_SAMPLE = Module_sample.cpp
!if 1
TGT_MODULE_SAMPLE = ..\DLLs\sample.azd
TGT_MODULES = $(TGT_MODULES) $(TGT_MODULE_SAMPLE)
$(TGT_MODULE_SAMPLE): $(SRCS_MODULE_SAMPLE:.cpp=.obj) $(LIB_ASCRIPT)
	@bcc32 $(LDFLAGS_DLL) -e$@ $** $(LIBS)
	@echo $@ was generated
Module_sample.obj: Module_sample.cpp
	@bcc32 $(CFLAGS) -DASCRIPT_MODULE_SEPARATED -c Module_sample.cpp
!else
SRCS_INTEGRATED_MODULE = $(SRCS_INTEGRATED_MODULE) $(SRCS_MODULE_SAMPLE)
!endif

#------------------------------------------------------------------------------
SRCS_ASCRIPT = Main.cpp
TGT_ASCRIPT = ..\ascript.exe
$(TGT_ASCRIPT): $(SRCS_ASCRIPT:.cpp=.obj) $(LIB_ASCRIPT)
	@bcc32 $(LDFLAGS) -e$@ $** $(LIBS)
	@echo $@ was generated

#------------------------------------------------------------------------------
SRCS_SCRATCH = Scratch.cpp
TGT_SCRATCH = scratch.exe
$(TGT_SCRATCH): $(SRCS_SCRATCH:.cpp=.obj) $(LIB_ASCRIPT)
	@bcc32 $(LDFLAGS) -e$@ $** $(LIBS)
	@echo $@ was generated

#------------------------------------------------------------------------------
$(LIB_ASCRIPT): $(DLL_ASCRIPT)
	@implib $@ $(DLL_ASCRIPT) >nul
	@echo $@ was generated

#------------------------------------------------------------------------------
$(LIB_ASCRIPT_S): $(SRCS_LIB:.cpp=.obj) $(SRCS_INTEGRATED_MODULE:.cpp=.obj) $(OBJS_EXTRA)
	@if exist $@ del $@ >nul
	@tlib $@ /P128 /a $**
	@echo $@ was generated

#------------------------------------------------------------------------------
$(DLL_ASCRIPT): $(SRCS_LIB:.cpp=.obj) $(SRCS_INTEGRATED_MODULE:.cpp=.obj) $(OBJS_EXTRA) DllMain.obj
	@bcc32 $(LDFLAGS_DLL) -e$@ $**
	@echo $@ was generated

#------------------------------------------------------------------------------
sfmt.obj: $(SFMTDIR)\sfmt.c
	@bcc32 -I$(MAKEDIR)\..\Include -q -w-8027 -c -o$@ $**

#------------------------------------------------------------------------------
all-stub: $(LIB_ASCRIPT) $(LIB_ASCRIPT_S) $(TGT_ASCRIPT) $(TGT_SCRATCH) $(TGT_MODULES)

clean:
	@del $(LIB_ASCRIPT) $(DLL_ASCRIPT) $(TGT_ASCRIPT) $(TGT_SCRATCH) $(TGT_MODULES) \
		..\*.tds ..\DLLs\*.tds *.obj $(OBJS_EXTRA)

listtag:
	svn ls $(SVNREPO)/tags

deltag:
	svn del $(SVNREPO)/tags/$(VERSION) -m ""

maketag:
	svn copy $(SVNREPO)/trunk $(SVNREPO)/tags/$(VERSION) -m "version $(VERSION) release"

distsrc:
	if exist ascript-$(VERSION) rmdir /s /q ascript-$(VERSION)
	svn export $(SVNREPO)/tags/$(VERSION) ascript-$(VERSION)
	7z a $(ZIPSRCFILE_PRE).tar ascript-$(VERSION)
	7z a $(ZIPSRCFILE_PRE).tar.gz $(ZIPSRCFILE_PRE).tar
	del $(ZIPSRCFILE_PRE).tar
	move /Y $(ZIPSRCFILE_PRE).tar.gz ..\..
	rmdir /s /q ascript-$(VERSION)

distbin:
	cd ..\..
	del $(ZIPBINFILE)
	7z a $(ZIPBINFILE) $(DISTFILES)
