!if !$d(WXVER)
WXVER = 2.8.10
!endif
TARGET = ..\..\ascriptshell.exe
SRCS = Application.cpp FrameMain.cpp FrameScribble.cpp PanelScribble.cpp
SRCS = $(SRCS) AScriptShell.cpp ConfigDialog.cpp
SRCS = $(SRCS) Module_scribble.cpp
RCFILE = AScriptShell.rc

#------------------------------------------------------------------------------
WXDIR = $(MAKEDIR)\..\wxWidgets-$(WXVER)

CFLAGS = -v -P -Od -a8 -g0 -D__WXMSW__ -DNOPCH -w-8057 -I. \
	-I$(MAKEDIR)\..\Include \
	-I$(WXDIR)\lib\bcc_lib\msw \
	-I$(WXDIR)\include \
	-I..

RCFLAGS = -32 -r -d__WXMSW__  \
	-i$(MAKEDIR)\..\include \
	-i$(WXDIR)\lib\bcc_lib\msw \
	-i$(WXDIR)\include

LDFLAGS = -Tpe -q -v -aa \
	-L$(MAKEDIR)\..\Lib \
	-L$(MAKEDIR)\..\Lib\psdk \
	-L$(WXDIR)\lib\bcc_lib \
	-L..

OBJS = $(SRCS:.cpp=.obj)

RESFILE = $(RCFILE:.rc=.res)

LIBS = wxbase28.lib wxmsw28_adv.lib wxmsw28_core.lib wxmsw28_html.lib \
	wxtiff.lib wxjpeg.lib wxpng.lib wxzlib.lib wxregex.lib wxexpat.lib \
	ole2w32.lib oleacc.lib odbc32.lib import32.lib cw32mt.lib
LIBS = $(LIBS) ascript.lib

.cpp.obj:
	@bcc32 -q -c $(CFLAGS) -o$@ $<
.rc.res:
	@brcc32 $(RCFLAGS) -fo$@ $<

all: $(TARGET)

$(TARGET): $(OBJS) $(RESFILE)
	@ilink32 $(LDFLAGS) $(LIBPATHFLAGS) c0w32.obj $(OBJS),$@,,$(LIBS),,$(RESFILE)
	@echo $@ was generated

clean:
	del $(TARGET) $(OBJS) $(RESFILE) \
		$(TARGET:.exe=.tds) $(TARGET:.exe=.map) \
		$(TARGET:.exe=.ils) $(TARGET:.exe=.ilf) \
		$(TARGET:.exe=.ild) $(TARGET:.exe=.ilc) \
		$(TARGET:.exe=.tr2) $(TARGET:.exe=.td2)
