#ifndef __DECLARATION_H__
#define __DECLARATION_H__

#include "Value.h"

namespace AScript {

class Class;
class Expr;
class Environment;

//-----------------------------------------------------------------------------
// Declaration
//-----------------------------------------------------------------------------
class DLLEXPORT Declaration {
private:
	const Symbol *_pSymbol;
	ValueType _valType;
	OccurPattern _occurPattern;
	bool _listFlag;
	bool _nomapFlag;
	Expr *_pExprDefault;
private:
	~Declaration();
public:
	Declaration(const Declaration &decl);
	Declaration(const Symbol *pSymbol, ValueType valType,
		OccurPattern occurPattern, bool listFlag, bool nomapFlag, Expr *pExprDefault);
	static Declaration *Create(Environment &env, Signal sig, const Expr *pExpr);
	inline Declaration *Clone() const { return new Declaration(*this); }
	inline static void Delete(Declaration *pDecl) { delete pDecl; }
	inline const Symbol *GetSymbol() const { return _pSymbol; }
	inline bool GetListFlag() const { return _listFlag; }
	inline bool GetNoMapFlag() const { return _nomapFlag; }
	inline void SetOccurPattern(OccurPattern occurPattern) { _occurPattern = occurPattern; }
	inline OccurPattern GetOccurPattern() const { return _occurPattern; }
	inline const Expr *GetExprDefault() const { return _pExprDefault; }
	inline ValueType GetValueType() const { return _valType; }
	inline bool IsMandatory() const {
		return _occurPattern == OCCUR_Once || _occurPattern == OCCUR_OnceOrMore;
	}
	inline bool IsOptional() const {
		return _occurPattern == OCCUR_ZeroOrOnce || _pExprDefault != NULL;
	}
	inline bool IsVariableLength() const {
		return _occurPattern == OCCUR_ZeroOrMore || _occurPattern == OCCUR_OnceOrMore;
	}
	inline bool IsType(ValueType valType) const { return _valType == valType; }
	inline bool IsQuote() const { return IsType(VTYPE_Quote); }
	inline bool IsAlwaysMappable() const {
		return (_occurPattern == OCCUR_Once || _occurPattern == OCCUR_ZeroOrOnce) &&
				!IsType(VTYPE_Any) && !IsType(VTYPE_List) && !_listFlag;
	}
	inline bool IsApplicable(const Value &value) const {
		return !(value.IsList() || value.IsIterator()) ||
				((IsType(VTYPE_List) || _listFlag) && value.IsFlatList());
	}
	String ToString() const;
};

class DLLEXPORT DeclarationList : public std::vector<Declaration *> {
public:
	static const DeclarationList Null;
public:
	inline DeclarationList() {}
	~DeclarationList();
	bool IsVariableLength() const;
	bool IsApplicable(const ValueList &valList) const;
	void SetAsLoose();
	String ToString() const;
};

class DLLEXPORT DeclarationOwner : public DeclarationList {
public:
	inline DeclarationOwner() {}
	DeclarationOwner(const DeclarationOwner &declOwner);
	~DeclarationOwner();
	void operator=(const DeclarationOwner &declOwner);
};

}

#endif
