#ifndef __OBJECT_BYTES_H__
#define __OBJECT_BYTES_H__

#include "Object.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_Bytes / Object_Bytes
//-----------------------------------------------------------------------------
class DLLEXPORT Class_Bytes : public Class {
public:
	Class_Bytes(Environment &env);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class DLLEXPORT Object_Bytes : public Object {
public:
	class IteratorByte : public Iterator {
	private:
		Object_Bytes *_pObj;
		int _cnt, _cntMax;
		Bytes::const_iterator _pCur;
	public:
		IteratorByte(Object_Bytes *pObj, int cntMax);
		virtual ~IteratorByte();
		virtual bool DoNext(Signal sig, Value &value);
		virtual String ToString(Signal sig) const;
	};
	class IteratorUnpack : public Iterator {
	private:
		Object_Bytes *_pObj;
		String _format;
		size_t _offset, _offsetInit;
		int _cntMax, _cnt;
	public:
		IteratorUnpack(Object_Bytes *pObj, const char *format, size_t offset, int cntMax);
		virtual ~IteratorUnpack();
		virtual bool DoNext(Signal sig, Value &value);
		virtual String ToString(Signal sig) const;
	};
public:
	inline static Object_Bytes *GetSelfObj(Context &context) {
		return dynamic_cast<Object_Bytes *>(context.GetSelfObj());
	}
private:
	Bytes _bytes;
public:
	inline Object_Bytes(Class *pClass) : Object(pClass) {}
	inline Object_Bytes(Class *pClass, const Bytes &bytes) :
										Object(pClass), _bytes(bytes) {}
	Object_Bytes(const Object_Bytes &obj);
	virtual ~Object_Bytes();
	virtual Object *Clone() const;
	virtual Value GetByIndex(Signal sig, const Value &valueIdx);
	virtual void SetByIndex(Signal sig, const Value &valueIdx, const Value &value);
	virtual Iterator *CreateIterator(Signal sig);
	virtual String ToString(Signal sig, bool exprFlag);
	inline Bytes &GetBytes() { return _bytes; }
	inline const Bytes &GetBytes() const { return _bytes; }
	bool Pack(Signal sig, size_t &offset,
							const char *format, const ValueList &valList);
	Value Unpack(Signal sig, size_t &offset,
							const char *format, bool exeedErrorFlag);
	bool PackForward(Signal sig, size_t offset, size_t size);
	static void PackUShort(Bytes::iterator pByte,
									bool bigEndianFlag, unsigned short num);
	static void PackULong(Bytes::iterator pByte,
									bool bigEndianFlag, unsigned long num);
	static void PackUInt64(Bytes::iterator pByte,
									bool bigEndianFlag, uint64 num);
	bool UnpackForward(Signal sig, size_t &offset, int distance, bool exceedErrorFlag);
	static unsigned short UnpackUShort(Bytes::iterator pByte, bool bigEndianFlag);
	static unsigned long UnpackULong(Bytes::iterator pByte, bool bigEndianFlag);
	static uint64 UnpackUInt64(Bytes::iterator pByte, bool bigEndianFlag);
	static bool CheckString(Signal sig,
				const ValueList &valList, ValueList::const_iterator pValue);
	static bool CheckNumber(Signal sig,
				const ValueList &valList, ValueList::const_iterator pValue);
	static bool CheckNumber(Signal sig, const ValueList &valList,
				ValueList::const_iterator pValue, Number numMin, Number numMax);
};

//-----------------------------------------------------------------------------
// Class_BytesPtr / Object_BytesPtr
//-----------------------------------------------------------------------------
class DLLEXPORT Class_BytesPtr : public Class {
public:
	Class_BytesPtr(Environment &env);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class DLLEXPORT Object_BytesPtr : public Object {
public:
	inline static Object_BytesPtr *GetSelfObj(Context &context) {
		return dynamic_cast<Object_BytesPtr *>(context.GetSelfObj());
	}
private:
	Object_Bytes *_pObjBytes;
	size_t _offset;
public:
	inline Object_BytesPtr(Class *pClass, Object_Bytes *pObjBytes, size_t offset) :
		Object(pClass), _pObjBytes(pObjBytes), _offset(offset) {}
	inline Object_BytesPtr(const Object_BytesPtr &obj) :
		Object(obj), _pObjBytes(dynamic_cast<Object_Bytes *>(obj._pObjBytes->IncRef())),
		_offset(obj._offset) {}
	virtual ~Object_BytesPtr();
	virtual Object *Clone() const;
	virtual String ToString(Signal sig, bool exprFlag);
	inline Object_Bytes *GetBytesObj() { return _pObjBytes; }
	inline Bytes &GetBytes() { return _pObjBytes->GetBytes(); }
	inline const Bytes &GetBytes() const { return _pObjBytes->GetBytes(); }
	inline size_t GetOffset() const { return _offset; }
	inline void Reset() { _offset = 0; }
	bool Pack(Signal sig, bool forwardFlag,
							const char *format, const ValueList &valList);
	Value Unpack(Signal sig, bool forwardFlag,
							const char *format, bool exeedErrorFlag);
	bool UnpackForward(Signal sig, int distance, bool exceedErrorFlag);
};

}

#endif
