#ifndef __OBJECT_FILE_H__
#define __OBJECT_FILE_H__

#include "Object.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_File / Object_File
//-----------------------------------------------------------------------------
class DLLEXPORT Class_File : public Class {
public:
	Class_File(Environment &env);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class DLLEXPORT Object_File : public Object {
public:
	class IteratorLine : public Iterator {
	private:
		Object_File *_pObj;
		int _nLinesMax;
		bool _includeEOLFlag;
		int _nLines;
	public:
		inline IteratorLine(Object_File *pObj, int nLinesMax, bool includeEOLFlag) :
					Iterator(false), _pObj(pObj), _nLinesMax(nLinesMax),
					_includeEOLFlag(includeEOLFlag), _nLines(0) {}
		virtual ~IteratorLine();
		virtual bool DoNext(Signal sig, Value &value);
		virtual String ToString(Signal sig) const;
	};
public:
	inline static Object_File *GetSelfObj(Context &context) {
		return dynamic_cast<Object_File *>(context.GetSelfObj());
	}
private:
	File _file;
public:
	inline Object_File(Class *pClass) : Object(pClass) {}
	//inline Object_File(const Object_File &obj) : Object(obj), _file(obj._file) {}
	virtual ~Object_File();
	virtual bool IsFile() const;
	virtual Object *Clone() const;
	inline File &GetFile() { return _file; }
	bool IsWritable(Signal sig);
	bool IsReadable(Signal sig);
	virtual Iterator *CreateIterator(Signal sig);
	virtual String ToString(Signal sig, bool exprFlag);
};

}

#endif
