#==============================================================================
# Makefile for Borland C++
#==============================================================================
ASCRIPT_VERSION = build018

LIB_ASCRIPT_D = ..\lib\libascript.bcc.lib
LIB_ASCRIPT_S = ..\lib\libascript_s.bcc.lib
DLL_ASCRIPT = ..\libascript.bcc.dll

SRCS = \
Common.cpp Algorithm.cpp Codec.cpp Codec_Japanese.cpp Codec_ISO8859.cpp \
Symbol.cpp String.cpp Signal.cpp Formatter.cpp Option.cpp \
File.cpp DateTime.cpp Value.cpp Iterator.cpp Declaration.cpp Environment.cpp \
Function.cpp Object.cpp Module.cpp OAL.cpp \
Object_Function.cpp Object_String.cpp Object_Bytes.cpp \
Object_List.cpp Object_Matrix.cpp Object_Dict.cpp \
Object_File.cpp Object_FileStat.cpp Object_DateTime.cpp Object_TimeDelta.cpp \
Object_Expr.cpp Object_Environment.cpp Object_Error.cpp Object_URI.cpp \
Object_Struct.cpp Object_Custom.cpp Object_Iterator.cpp Object_Semaphore.cpp \
Object_Image.cpp Object_Audio.cpp Object_Codec.cpp \
Operator.cpp Expr.cpp Parser.cpp DLLMain.cpp

SRCS = $(SRCS) \
Module_math.cpp \
Module_builtins.cpp \
Module_os.cpp \
Module_sys.cpp \
Module_time.cpp \
Module_string.cpp \
Module_csv.cpp \
Module_net.cpp

OBJS_EXTRA = sfmt.obj

SVNREPO = https://svn.sourceforge.jp/svnroot/ascript

ZIPSRCFILE_PRE = ascript-$(ASCRIPT_VERSION)-src
ZIPBINFILE = ascript-$(ASCRIPT_VERSION)-win32.zip
ZIPBINFILE_EXTRA = ascript-extra-$(ASCRIPT_VERSION)-win32.zip

DISTFILES = \
AScript\module\*.azd AScript\module\*.az \
AScript\libascript.bcc.dll AScript\ascript.exe AScript\ascriptshell.exe \
AScript\test\test-*.az \
AScript\test\50records-en.csv AScript\test\50records-jp.csv \
AScript\test\temperature.txt \
AScript\test\chars-cp932.txt \
AScript\test\chars-eucjp.txt \
AScript\test\chars-utf8-jp.txt \
AScript\test\testall.bat AScript\test\result\test-*.sample.txt \
AScript\sample\misc\*.az AScript\sample\misc\*.bat \
AScript\sample\opengl\*.az AScript\sample\opengl\*.rgb \
AScript\sample\sdl\*.az \
AScript\sample\win32ole\*.az

DISTFILES_EXTRA = \
AScript\extra\*.dll

SFMTDIR = ..\extra\SFMT-src-1.3.3

LDFLAGS = -tWD -tWM -M -q \
-L$(MAKEDIR)\..\Lib -L$(MAKEDIR)\..\Lib\psdk -lS:10000000

CFLAGS = \
-q -I$(MAKEDIR)\..\Include -w-8057 -w-8004 \
-DASCRIPT_VERSION=\"$(ASCRIPT_VERSION)\" -DASCRIPT_EXPORTS

#CFLAGS = $(CFLAGS) -DDEBUG_ASCRIPT

.cpp.obj:
	@bcc32 $(CFLAGS) -c $<

build: $(LIB_ASCRIPT_D) $(LIB_ASCRIPT_S) build_modules

$(LIB_ASCRIPT_D): $(DLL_ASCRIPT)
	@implib $@ $(DLL_ASCRIPT) >nul
	@echo $@ was generated

$(LIB_ASCRIPT_S): $(SRCS:.cpp=.obj) $(OBJS_EXTRA)
	@if exist $@ del $@ >nul
	@tlib $@ /P128 /a $**
	@echo $@ was generated

$(DLL_ASCRIPT): $(SRCS:.cpp=.obj) $(OBJS_EXTRA)
	@bcc32 $(LDFLAGS) -e$@ $**
	@echo $@ was generated

sfmt.obj: $(SFMTDIR)\sfmt.c
	@bcc32 -I$(MAKEDIR)\..\Include -q -w-8027 -c -o$@ $**

clean: clean_modules
	@del $(SRCS:.cpp=.obj)
	@del $(LIB_ASCRIPT_D) $(LIB_ASCRIPT_S) $(DLL_ASCRIPT) $(OBJS_EXTRA)
	@del $(DLL_ASCRIPT:.dll=.map) $(DLL_ASCRIPT:.dll=.tds)

build_modules:
	@cd AScript
	@make
	@cd ..\AScriptShell
	@make
	@cd ..\Module_sample
	@make
	@cd ..\Module_canvas
	@make
	@cd ..\Module_re
	@make
	@cd ..\Module_sqlite3
	@make
	@cd ..\Module_win32ole
	@make
	@cd ..\Module_xml
	@make
	@cd ..\Module_mysql
	@make
	@cd ..\Module_postgresql
	@make
	@cd ..\Module_sdl
	@make
	@cd ..\Module_opengl
	@make
	@cd ..\Module_glu
	@make
	@cd ..\Module_jpeg
	@make
	@cd ..\Module_png
	@make
	@cd ..\Module_tiff
	@make
	@cd ..

clean_modules:
	@cd AScript
	@make clean
	@cd ..\AScriptShell
	@make clean
	@cd ..\Module_sample
	@make clean
	@cd ..\Module_canvas
	@make clean
	@cd ..\Module_re
	@make clean
	@cd ..\Module_sqlite3
	@make clean
	@cd ..\Module_win32ole
	@make clean
	@cd ..\Module_xml
	@make clean
	@cd ..\Module_mysql
	@make clean
	@cd ..\Module_postgresql
	@make clean
	@cd ..\Module_sdl
	@make clean
	@cd ..\Module_opengl
	@make clean
	@cd ..\Module_glu
	@make clean
	@cd ..\Module_jpeg
	@make clean
	@cd ..\Module_png
	@make clean
	@cd ..\Module_tiff
	@make clean
	@cd ..

#------------------------------------------------------------------------------
listtag:
	svn ls $(SVNREPO)/tags

deltag:
	svn del $(SVNREPO)/tags/$(ASCRIPT_VERSION) -m ""

maketag:
	svn copy $(SVNREPO)/trunk $(SVNREPO)/tags/$(ASCRIPT_VERSION) -m "version $(ASCRIPT_VERSION) release"

distsrc:
	if exist ascript-$(ASCRIPT_VERSION) rmdir /s /q ascript-$(ASCRIPT_VERSION)
	svn export $(SVNREPO)/tags/$(ASCRIPT_VERSION) ascript-$(ASCRIPT_VERSION)
	7z a $(ZIPSRCFILE_PRE).tar ascript-$(ASCRIPT_VERSION)
	7z a $(ZIPSRCFILE_PRE).tar.gz $(ZIPSRCFILE_PRE).tar
	del $(ZIPSRCFILE_PRE).tar
	move /Y $(ZIPSRCFILE_PRE).tar.gz ..\..
	rmdir /s /q ascript-$(ASCRIPT_VERSION)

distbin:
	cd ..\..
	del $(ZIPBINFILE)
	7z a $(ZIPBINFILE) $(DISTFILES)
	7z a $(ZIPBINFILE_EXTRA) $(DISTFILES_EXTRA)
