#==============================================================================
# Makefile for Borland C++
#==============================================================================
!if !$d(ASCRIPTDIR)
ASCRIPTDIR = ..\..
!endif

SRCS = Module_sdl.cpp
LIBS = $(ASCRIPTDIR)\lib\libascript.bcc.lib
LIBS_SDL = SDL.bcc.lib SDL_image.bcc.lib SDL_ttf.bcc.lib SDL_mixer.bcc.lib
TARGET = $(ASCRIPTDIR)\module\sdl.azd

SDLDIR = SDL-1.2.14
SDLIMAGEDIR = SDL_image-1.2.10
SDLTTFDIR = SDL_ttf-2.0.10
SDLMIXERDIR = SDL_mixer-1.2.11
CFLAGS = -D__DMC__ -I$(ASCRIPTDIR)\include \
	-I$(SDLDIR)\include -I$(SDLIMAGEDIR)\include \
	-I$(SDLTTFDIR)\include -I$(SDLMIXERDIR)\include
LDFLAGS =

all: $(LIBS_SDL) $(TARGET)
SDL.bcc.lib: $(SDLDIR)\lib\SDL.dll
	@implib -a $@ $**
SDL_image.bcc.lib: $(SDLIMAGEDIR)\lib\SDL_image.dll
	@implib -a $@ $**
SDL_ttf.bcc.lib: $(SDLTTFDIR)\lib\SDL_ttf.dll
	@implib -a $@ $**
SDL_mixer.bcc.lib: $(SDLMIXERDIR)\lib\SDL_mixer.dll
	@implib -a $@ $**
#------------------------------------------------------------------------------
CFLAGS = $(CFLAGS) -q -w-8057 -w-8004 -DASCRIPT_MODULE_SEPARATED \
-I$(MAKEDIR)\..\Include

LDFLAGS = $(LDFLAGS) -tWD -tWM -M -q \
-L$(MAKEDIR)\..\Lib -L$(MAKEDIR)\..\Lib\psdk

.cpp.obj:
	@bcc32 $(CFLAGS) -c $<

OBJS = $(SRCS:.cpp=.obj)

$(TARGET): $(OBJS) $(LIBS)
	@bcc32 $(LDFLAGS) -e$@ $(OBJS) $(LIBS) $(LIBS_SDL)
	@echo $@ was generated

clean:
	@del $(OBJS) $(TARGET) $(TARGET:.azd=.map) $(TARGET:.azd=.tds) $(LIBS_SDL)
