#ifndef __OBJECT_IMAGE_H__
#define __OBJECT_IMAGE_H__

#include "Object.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_Image
//-----------------------------------------------------------------------------
class DLLDECLARE Class_Image : public Class {
public:
	Class_Image(Environment &env);
};

//-----------------------------------------------------------------------------
// Object_ImageBase
//-----------------------------------------------------------------------------
class DLLDECLARE Object_Image : public Object {
public:
	enum Format {
		FORMAT_None,
		FORMAT_RGB, FORMAT_RGBA,
	};
public:
	inline static Object_Image *GetSelfObj(Context &context) {
		return dynamic_cast<Object_Image *>(context.GetSelfObj());
	}
protected:
	Format _format;
	size_t _width, _height;
	unsigned char *_buff;
	struct {
		size_t bitsPerPixel;
		size_t bytesPerPixel;
		size_t bytesPerLine;
	} _metrics;
#if defined(HAVE_WINDOWS_H)
	HBITMAP _hBmp;
#endif
public:
	Object_Image(Class *pClass, Format format);
	Object_Image(const Object_Image &obj);
	virtual ~Object_Image();
	virtual Object *Clone() const;
	inline bool IsValid() const { return _buff != NULL; }
	inline Format GetFormat() const { return _format; }
	inline size_t GetWidth() const { return _width; }
	inline size_t GetHeight() const { return _height; }
	inline unsigned char *GetBuffer() { return _buff; }
	inline size_t GetBitsPerPixel() const { return _metrics.bitsPerPixel; }
	inline size_t GetBytesPerPixel() const { return _metrics.bytesPerPixel; }
	inline size_t GetBytesPerLine() const { return _metrics.bytesPerLine; }
	inline size_t GetBufferSize() const {
		return GetBytesPerLine() * _height;
	}
	inline unsigned char *GetPointer(size_t x, size_t y) {
		return _buff + GetBytesPerLine() * y + GetBytesPerPixel() * x;
	}
	bool IsWindowDIB() const;
#if defined(HAVE_WINDOWS_H)
	inline HBITMAP GetHBITMAP() { return _hBmp; }
#endif
	bool CheckEmpty(Signal sig) const;
	bool CheckValidity(Signal sig) const;
	virtual Value EvalGetter(Signal sig, const Symbol *pSymbol, bool &evaluatedFlag);
	virtual Value EvalSetter(Signal sig, const Symbol *pSymbol,
									const Value &value, bool &evaluatedFlag);
	virtual String ToString(Signal sig, bool exprFlag);
	bool AllocBuffer(Signal sig, size_t width, size_t height);
	void FreeBuffer();
	inline bool CheckCoord(int x, int y) const {
		return 0 <= x && x < static_cast<int>(_width) &&
				0 <= y && y < static_cast<int>(_height);
	}
	bool CheckCoord(Signal sig, size_t x, size_t y) const;
	bool PutPixel(Signal sig, unsigned char *buff, const ValueList &valList);
	bool GetPixel(Signal sig, unsigned char *buff, ValueList &valList);
	bool Store(Signal sig, size_t x, size_t y, size_t width, size_t height,
						const Symbol *pSymbol, const Object_Matrix *pObjMat);
	bool Store(Signal sig, size_t x, size_t y, size_t width, size_t height,
						const Symbol *pSymbol, Iterator *pIterator);
	bool Extract(Signal sig, size_t x, size_t y, size_t width, size_t height,
						const Symbol *pSymbol, Object_Matrix *pObjMat);
	bool Extract(Signal sig, size_t x, size_t y, size_t width, size_t height,
						const Symbol *pSymbol, Object_List *pObjList);
	bool FillRect(Signal sig, size_t x, size_t y,
					size_t width, size_t height, const ValueList &color);
	inline bool Fill(Signal sig, const ValueList &color) {
		return FillRect(sig, 0, 0, _width, _height, color);
	}
	bool ReadBMP(Signal sig, File &file);
	bool WriteBMP(Signal sig, File &file);
	size_t SymbolToPixelOffset(Signal sig, const Symbol *pSymbol) const;
	static Format SymbolToFormat(Signal sig, const Symbol *pSymbol);
	static const Symbol *FormatToSymbol(Format format);
private:
	void InitMetrics();
};

}

#endif
