#ifndef __PACKEDVAR__
#define __PACKEDVAR__

#define XPackedUShort_LE(x) \
unsigned char x##_b0, x##_b8

#define XPackedUShort_BE(x) \
unsigned char x##_b8, x##_b0

#define XPackedULong_LE(x) \
unsigned char x##_b0, x##_b8, x##_b16, x##_b24

#define XPackedULong_BE(x) \
unsigned char x##_b24, x##_b16, x##_b8, x##_b0

#define XPackedShort_LE(x) XPackedUShort_LE(x)
#define XPackedLong_LE(x) XPackedULong_LE(x)
#define XPackedShort_BE(x) XPackedUShort_BE(x)
#define XPackedLong_BE(x) XPackedULong_BE(x)

#define XPackUShort(x, n) do { \
	x##_b0 = static_cast<unsigned char>((static_cast<unsigned short>(n) >> 0) & 0xff); \
	x##_b8 = static_cast<unsigned char>((static_cast<unsigned short>(n) >> 8) & 0xff); \
} while (0)

#define XPackULong(x, n) do { \
	x##_b0 = static_cast<unsigned char>((static_cast<unsigned long>(n) >> 0) & 0xff); \
	x##_b8 = static_cast<unsigned char>((static_cast<unsigned long>(n) >> 8) & 0xff); \
	x##_b16 = static_cast<unsigned char>((static_cast<unsigned long>(n) >> 16) & 0xff); \
	x##_b24 = static_cast<unsigned char>((static_cast<unsigned long>(n) >> 24) & 0xff); \
} while (0)

#define XUnpackUShort(x) \
((static_cast<unsigned short>(x##_b0) << 0) | (static_cast<unsigned short>(x##_b8) << 8))

#define XUnpackULong(x) \
((static_cast<unsigned long>(x##_b0) << 0) | (static_cast<unsigned long>(x##_b8) << 8) | \
 (static_cast<unsigned long>(x##_b16) << 16) | (static_cast<unsigned long>(x##_b24) << 24))

#define XPackShort(x, n) XPackUShort(x, n)
#define XPackLong(x, n) XPackULong(x, n)
#define XUnpackShort(x) static_cast<short>(XUnpackUShort(x))
#define XUnpackLong(x) static_cast<long>(XUnpackUShort(x))

#endif
